/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.distribution;

import com.installshield.util.FileUtils;
import com.installshield.util.jvm.IndexEntry;
import com.installshield.util.jvm.Instructions;
import com.installshield.util.jvm.LaunchScript;
import com.installshield.util.jvm.LauncherEntry;
import com.installshield.util.jvm.LauncherWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ShellScriptLauncherWriter
extends LauncherWriter {
    private Vector indexEntrySupport = new Vector();
    private Vector fileIndexTable = new Vector();
    static String FILEINDEX = "FILEINDEX";
    static String FILEINDEX_COUNT = "FILEINDEXCOUNT";
    static int MAX_FILE_ENTRY_SIZE = 256;
    static int FIXED_ENTRY_SIZE_TOTAL = 44;
    static int NO_OF_DELIMITERS = 7;
    static int MAX_FILE_NAME_SIZE = MAX_FILE_ENTRY_SIZE - FIXED_ENTRY_SIZE_TOTAL - NO_OF_DELIMITERS;
    static int FILE_OFFSET_BOUNDARY = 1024;

    private int calculatePadding(int n) {
        return FILE_OFFSET_BOUNDARY - n % FILE_OFFSET_BOUNDARY;
    }

    private String convertToHexString(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        char[] cArray = new char[n2];
        if (string.length() > 0 && string.length() < n2) {
            int n3 = 0;
            while (n3 < n2 - string.length()) {
                cArray[n3] = 48;
                ++n3;
            }
            int n4 = n3;
            int n5 = 0;
            while (n4 < n2) {
                cArray[n4] = string.charAt(n5);
                ++n4;
                ++n5;
            }
        } else if (string.length() == n2) {
            string.getChars(0, string.length(), cArray, 0);
        } else {
            cArray = new char[]{};
        }
        return new String(cArray);
    }

    String createFileIndexEntry(IndexEntry indexEntry, int n) {
        if (indexEntry.fileNameOnly.length() > MAX_FILE_NAME_SIZE) {
            indexEntry.fileNameOnly = indexEntry.fileNameOnly.substring(0, MAX_FILE_NAME_SIZE);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FILEINDEX).append(n).append('=');
        stringBuffer.append(this.convertToHexString(indexEntry.fileType, 2)).append(":");
        stringBuffer.append(this.convertToHexString(n, 8)).append(":");
        stringBuffer.append(this.convertToHexString(indexEntry.byteLength, 8)).append(":");
        stringBuffer.append(this.convertToHexString(indexEntry.offset, 8)).append(":");
        stringBuffer.append(indexEntry.fileNameOnly).append(":");
        stringBuffer.append(this.convertToHexString(indexEntry.isCompressed ? 1 : 0, 2)).append(":");
        stringBuffer.append(this.convertToHexString(indexEntry.decompressedFileCount, 8)).append(":");
        stringBuffer.append(this.convertToHexString(indexEntry.decompressedSize, 8)).append('\n');
        return stringBuffer.toString();
    }

    private void createFileIndexTable() throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = (int)LauncherWriter.getInputStreamSize(this.getLauncherStub().openStream());
        LauncherEntry launcherEntry = null;
        n = 0;
        while (n < this.getEntries().size()) {
            launcherEntry = (LauncherEntry)this.getEntries().elementAt(n);
            if (launcherEntry != null && !(launcherEntry instanceof Instructions) && !(launcherEntry instanceof LaunchScript)) {
                this.indexEntrySupport.addElement(new IndexEntry(launcherEntry.getType(), (int)launcherEntry.calculateSize(), 0, launcherEntry.getName(), launcherEntry.isCompressed(), (int)launcherEntry.getDecompressedFileCount(), (int)launcherEntry.calculateTotalDecompressedSize()));
            } else if (launcherEntry instanceof LaunchScript || launcherEntry instanceof Instructions) {
                n2 += (int)launcherEntry.calculateSize();
            }
            ++n;
        }
        IndexEntry indexEntry = null;
        n = 0;
        while (n < this.indexEntrySupport.size()) {
            indexEntry = (IndexEntry)this.indexEntrySupport.elementAt(n);
            n2 += FILEINDEX.length() + Integer.toString(n).length() + 1 + FIXED_ENTRY_SIZE_TOTAL + NO_OF_DELIMITERS + indexEntry.fileNameOnly.length() + 1;
            ++n;
        }
        n2 += FILEINDEX_COUNT.length() + 1 + Integer.toString(n).length() + 1;
        n2 += this.calculatePadding(n2);
        n = 0;
        while (n < this.indexEntrySupport.size()) {
            indexEntry = (IndexEntry)this.indexEntrySupport.elementAt(n);
            indexEntry.offset = n2;
            n2 += indexEntry.byteLength + this.calculatePadding(indexEntry.byteLength);
            this.fileIndexTable.addElement(this.createFileIndexEntry(indexEntry, n));
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FILEINDEX_COUNT).append('=').append(Integer.toString(n)).append('\n');
        this.fileIndexTable.addElement(stringBuffer.toString());
    }

    private int pad(DataOutputStream dataOutputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < this.calculatePadding(n)) {
            dataOutputStream.writeByte(35);
            ++n2;
        }
        return dataOutputStream.size();
    }

    public void write() throws IOException {
        this.validate();
        this.createFileIndexTable();
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.getFileName()));
        try {
            InputStream inputStream = this.getLauncherStub().openStream();
            FileUtils.copy(inputStream, dataOutputStream);
            inputStream.close();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = null;
            int n = 0;
            while (n < this.fileIndexTable.size()) {
                string = (String)this.fileIndexTable.elementAt(n);
                byteArrayOutputStream.write(string.getBytes(), 0, string.length());
                ++n;
            }
            byteArrayOutputStream.writeTo(dataOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            if (!this.isOuterLauncherWriter()) {
                this.getLaunchScript().write(dataOutputStream);
            }
            this.getInstructions().write(dataOutputStream);
            this.pad(dataOutputStream, dataOutputStream.size());
            LauncherEntry launcherEntry = null;
            int n2 = 0;
            while (n2 < this.getEntries().size()) {
                launcherEntry = (LauncherEntry)this.getEntries().elementAt(n2);
                if (launcherEntry != null && !(launcherEntry instanceof Instructions) && !(launcherEntry instanceof LaunchScript)) {
                    this.pad(dataOutputStream, launcherEntry.write(dataOutputStream));
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            try {
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var3_8 = null;
        try {
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {}
    }
}

