/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.archive.index.ArchiveIndexAccessor;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.actions.Files;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;

public class Win32SelfRegisteringFiles2
extends Files {
    private boolean deferRegistration = false;
    private boolean runtimeErrors = false;
    static /* synthetic */ Class class$com$installshield$wizard$platform$win32$Win32Platform;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass("com.installshield.product.actions.Files");
            productBuilderSupport.putClass((class$com$installshield$wizard$platform$win32$Win32Platform != null ? class$com$installshield$wizard$platform$win32$Win32Platform : (class$com$installshield$wizard$platform$win32$Win32Platform = Win32SelfRegisteringFiles2.class$("com.installshield.wizard.platform.win32.Win32Platform"))).getName());
            productBuilderSupport.putRequiredService("systemUtilService");
            super.build(productBuilderSupport);
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void deletingFileDuringUninstall(String string) {
        this.unregisterFile(string);
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (!Win32Platform.targetIsWindowsMachine()) {
            return;
        }
        this.runtimeErrors = false;
        super.install(productActionSupport);
        if (this.runtimeErrors) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32SelfRegisteringFiles.installError", new String[]{this.getBeanId()}));
        }
    }

    protected void moveFileWithFileService(String string, File file, MutableOperationState mutableOperationState, FileService fileService, ArchiveIndexAccessor archiveIndexAccessor, int n, ProductActionSupport productActionSupport) throws IOException, ServiceException {
        if (fileService.moveFile(string, file.getAbsolutePath(), true) == 1) {
            this.deferRegistration = true;
        }
    }

    protected void overwritingFileDuringInstall(String string, int n, ArchiveIndexAccessor archiveIndexAccessor, int n2, ProductActionSupport productActionSupport) {
        this.unregisterFile(string);
    }

    protected void overwritingFileDuringReplace(String string, int n, ArchiveIndexAccessor archiveIndexAccessor, int n2, ProductActionSupport productActionSupport) {
        this.unregisterFile(string);
    }

    private void registerFile(String string) {
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
            int n = Win32Utils.registerDLL(systemUtilService, string, this.deferRegistration);
            if (n != 0) {
                this.runtimeErrors = true;
                this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32SelfRegisteringFiles.errorRegistering", new String[]{string, new Integer(n).toString()}));
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "wrn", exception);
            this.runtimeErrors = true;
        }
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        if (!Win32Platform.targetIsWindowsMachine()) {
            return;
        }
        this.runtimeErrors = false;
        super.replace(productAction, productActionSupport);
        if (this.runtimeErrors) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32SelfRegisteringFiles.installError", new String[]{this.getBeanId()}));
        }
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!Win32Platform.targetIsWindowsMachine()) {
            return;
        }
        this.runtimeErrors = false;
        super.uninstall(productActionSupport);
        if (this.runtimeErrors) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32SelfRegisteringFiles.uninstallError", new String[]{this.getBeanId()}));
        }
    }

    private void unregisterFile(String string) {
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
            int n = Win32Utils.unregisterDLL(systemUtilService, string, this.deferRegistration);
            if (n != 0) {
                this.runtimeErrors = true;
                this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32SelfRegisteringFiles.errorUnregistering", new String[]{string, new Integer(n).toString()}));
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "wrn", exception);
            this.runtimeErrors = true;
        }
    }

    protected void wroteFileDuringInstall(String string, boolean bl) {
        this.registerFile(string);
    }

    protected void wroteFileDuringReplace(String string, boolean bl) {
        this.registerFile(string);
    }
}

