/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;

public class Win32RegistryKeyExistsProductBeanCondition
extends ProductBeanCondition {
    private int hive = 4;
    private String key = "";

    public void build(ProductBuilderSupport productBuilderSupport) {
        super.build(productBuilderSupport);
        productBuilderSupport.putRequiredService("win32RegistryService");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public String defaultName() {
        return "Win32RegistryKeyExists";
    }

    public String describe() {
        if (this.getEvaluate() == 1) {
            return String.valueOf(this.key) + " must exist";
        }
        return String.valueOf(this.key) + " must NOT exist";
    }

    protected boolean evaluateTrueCondition() {
        if (!Win32Platform.targetIsWindowsMachine()) {
            return this.getEvaluate() != 1;
        }
        try {
            WizardServices wizardServices = this.getProductBean().getServices();
            Win32RegistryService win32RegistryService = (Win32RegistryService)wizardServices.getService("win32RegistryService");
            return win32RegistryService.keyExists(this.hive, wizardServices.resolveString(this.key));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    public int getHive() {
        return this.hive;
    }

    public String getKey() {
        return this.key;
    }

    public void setHive(int n) {
        this.hive = n;
    }

    public void setKey(String string) {
        this.key = string;
    }
}

