/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;

public class Win32RegistryValueExistsProductBeanCondition
extends ProductBeanCondition {
    private int hive = 4;
    private String key = "";
    private String valueName = "";

    public void build(ProductBuilderSupport productBuilderSupport) {
        super.build(productBuilderSupport);
        productBuilderSupport.putRequiredService("win32RegistryService");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public String defaultName() {
        return "Win32RegistryValueExists";
    }

    public String describe() {
        if (this.getEvaluate() == 1) {
            return String.valueOf(this.valueName) + " must exist";
        }
        return String.valueOf(this.valueName) + " must NOT exist";
    }

    protected boolean evaluateTrueCondition() {
        if (!Win32Platform.targetIsWindowsMachine()) {
            return this.getEvaluate() != 1;
        }
        try {
            WizardServices wizardServices = this.getProductBean().getServices();
            Win32RegistryService win32RegistryService = (Win32RegistryService)wizardServices.getService("win32RegistryService");
            return win32RegistryService.valueExists(this.hive, wizardServices.resolveString(this.key), wizardServices.resolveString(this.valueName));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    public int getHive() {
        return this.hive;
    }

    public String getKey() {
        return this.key;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setHive(int n) {
        this.hive = n;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setValueName(String string) {
        this.valueName = string;
    }
}

