/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.archive.ArchiveURLStreamHandler;
import com.installshield.archive.MediaInf;
import com.installshield.archive.index.ArchiveIndex;
import com.installshield.archive.index.ArchiveIndexAccessor;
import com.installshield.archive.index.ArchiveIndexReader;
import com.installshield.archive.index.ResourceIndexRange;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LogListener;
import com.installshield.util.StringResolver;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverMethod;
import com.installshield.util.URLUtils;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.service.ResourceStorageInfo;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.ServicesDependentStringResolverMethod;
import com.installshield.wizard.service.StringResolverMethodDef;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractWizardServices
implements WizardServicesImpl {
    private Hashtable mediaLocations = new Hashtable();
    private String id;
    private String home;
    private String mediaArchiveHome;
    private String externalResourcesHome;
    private String externalResourceLocation;
    private ServicesDefinition servicesDef;
    private Hashtable values = new Hashtable();
    int currentMediaNumber;
    ArchiveIndexReader reader = null;
    boolean usingTestStructure = false;
    boolean storeMediaLocations = true;
    Hashtable queuedIndexRanges = new Hashtable();
    Hashtable storedResources = new Hashtable();
    int lastStoredMediaNum;
    private StringResolver stringResolver = new StringResolver();
    private boolean initializedLog = false;
    private boolean errorsLogged = false;
    private boolean warningsLogged = false;
    private Vector logListeners = new Vector();
    private WizardLog log = new WizardLog();

    protected AbstractWizardServices(String string, String string2, String string3, String string4, String string5, ServicesDefinition servicesDefinition) {
        this.id = string;
        this.home = string2;
        this.mediaArchiveHome = string3;
        this.externalResourcesHome = string4;
        this.externalResourceLocation = string5;
        this.servicesDef = servicesDefinition;
        this.usingTestStructure = AbstractWizardServices.isTestStructure(string3);
        this.storeMediaLocations = AbstractWizardServices.shouldStoreMediaLocations(string3, string4);
        this.currentMediaNumber = 1;
        this.createStringResolverMethods(servicesDefinition);
        this.initArchiveIndexReader();
        this.clearIndexedResourceQueue();
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void addStringResolverMethod(StringResolverMethod stringResolverMethod) {
        if (stringResolverMethod instanceof ServicesDependentStringResolverMethod) {
            ((ServicesDependentStringResolverMethod)stringResolverMethod).initialize(this);
        }
        this.stringResolver.addMethod(stringResolverMethod);
    }

    protected abstract void addStringResolverMethod(StringResolverMethod var1, int var2);

    public void clearIndexedResourceQueue() {
        if (this.storingQueuedResources()) {
            this.lastStoredMediaNum = -1;
            this.queuedIndexRanges.clear();
        }
    }

    public void closeResourceArchive(String string) throws IOException {
        ArchiveURLStreamHandler.closeArchive(string);
    }

    private boolean compareMediaId(String string, String string2, int n) throws IOException {
        boolean bl = false;
        File file = new File(string);
        String string3 = FileUtils.getParent(file.getAbsolutePath());
        if (new File(string3).exists()) {
            if (file.exists()) {
                InputStream inputStream = new URL("ismpfile", "", -1, URLUtils.encode(string)).openStream();
                MediaInf mediaInf = new MediaInf(inputStream);
                inputStream.close();
                bl = mediaInf.getMediaId() == n;
            } else if (n == 1) {
                bl = true;
            }
        }
        return bl;
    }

    private String createMediaLocation(String string, int n, String string2) throws ServiceException, IOException {
        String string3 = FileUtils.canonizePath(string2);
        if (!this.usingTestStructure) {
            if (this.getMediaLocation(string, n) == null) {
                return string3;
            }
            return this.getMediaLocation(string, n);
        }
        return FileUtils.createFileName(FileUtils.getParent(string3), "disk" + n);
    }

    private String createSpannedResourceDefaultPath(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 == 0) {
            return FileUtils.getParent(this.getMediaArchiveHome());
        }
        if (n2 == 1) {
            return FileUtils.getParent(this.getMediaArchiveHome());
        }
        if (n2 == 2) {
            return this.externalResourcesHome;
        }
        return null;
    }

    private String createSpannedResourceLocation(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 == 0) {
            return FileUtils.getName(FileUtils.removeTerminalSeparator(this.getMediaArchiveHome()));
        }
        if (n2 == 1) {
            return FileUtils.getName(FileUtils.removeTerminalSeparator(this.getMediaArchiveHome()));
        }
        if (n2 == 2) {
            return this.externalResourceLocation;
        }
        return null;
    }

    private String createSpannedResourceName(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 == 0) {
            String string = this.getArchiveIndexReader().getFileName(n);
            return string.startsWith("/") ? String.valueOf(this.getId()) + string : String.valueOf(this.getId()) + "/" + string;
        }
        if (n2 == 1) {
            String string = this.getArchiveIndexReader().getMD5Name(n);
            String string2 = "md5/" + string;
            return string2.startsWith("/") ? String.valueOf(this.getId()) + string2 : String.valueOf(this.getId()) + "/" + string2;
        }
        if (n2 == 2) {
            String string = FileUtils.normalizeFileName(this.getArchiveIndexReader().getSource(n));
            String string3 = this.getArchiveIndexReader().getFileName(n);
            if (string == null || string.trim().length() == 0) {
                return string3.startsWith("/") ? string3.substring(1) : string3;
            }
            return string3.startsWith("/") ? String.valueOf(string) + string3 : String.valueOf(string) + "/" + string3;
        }
        return null;
    }

    private URL createSpannedResourceURL(int n, String string) throws ServiceException, IOException {
        String string2 = FileUtils.createFileName(string, this.createSpannedResourceLocation(n));
        String string3 = this.createSpannedResourceName(n);
        if (this.isSpannedResourceArchived(n)) {
            return new URL("archive", "", -1, URLUtils.encodeArchiveURLPath(String.valueOf(string2) + "+/" + string3));
        }
        return new URL("ismpfile", "", -1, URLUtils.encode(FileUtils.createFileName(string2, string3)));
    }

    protected void createStringResolverMethods(ServicesDefinition servicesDefinition) {
        int n = 0;
        while (n < servicesDefinition.getStringResolverMethodCount()) {
            StringResolverMethodDef stringResolverMethodDef = servicesDefinition.getStringResolverMethod(n);
            try {
                Class<?> clazz = Class.forName(stringResolverMethodDef.getClassName());
                StringResolverMethod stringResolverMethod = (StringResolverMethod)clazz.newInstance();
                this.addStringResolverMethod(stringResolverMethod, stringResolverMethodDef.getContext());
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: cannot instantiate string resolver method " + stringResolverMethodDef.getClassName() + ": " + throwable);
            }
            ++n;
        }
    }

    private String createUniqueResourceKey(int n) {
        try {
            ArchiveIndexReader archiveIndexReader = this.getArchiveIndexReader();
            int n2 = archiveIndexReader.getResourceType(n);
            int n3 = archiveIndexReader.getStartMediaNumber(n);
            int n4 = archiveIndexReader.getEndMediaNumber(n);
            String string = String.valueOf(n2) + "|" + n3 + "|" + n4 + "|";
            if (n2 == 2) {
                return String.valueOf(string) + archiveIndexReader.getSource(n) + "|" + archiveIndexReader.getFileName(n);
            }
            if (n2 == 0) {
                return String.valueOf(string) + archiveIndexReader.getFileName(n);
            }
            if (n2 == 1) {
                return String.valueOf(string) + archiveIndexReader.getMD5Name(n);
            }
            return null;
        }
        catch (Exception exception) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Could not create url storage key: " + n);
                exception.printStackTrace();
            }
            return null;
        }
    }

    public abstract void displayUserMessage(String var1, String var2, int var3) throws ServiceException;

    private String ensureProperMedia(String string, int n, String string2) throws ServiceException, IOException {
        String string3;
        String string4 = this.createMediaLocation(string, n, string2);
        if (!this.usingTestStructure) {
            while (!this.isProperMedia(string, n, string4)) {
                try {
                    String string5 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.askForMediaTitle");
                    String string6 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.askForMediaMessage", new String[]{Integer.toString(n)});
                    String string7 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "okWithMn");
                    String string8 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancelWithMn");
                    UserInputRequest userInputRequest = new UserInputRequest();
                    userInputRequest.setTitle(string5);
                    userInputRequest.setPrompt(string6);
                    userInputRequest.setType(9);
                    userInputRequest.setTextValue(string4);
                    Object[] objectArray = new Object[]{string7, string8};
                    userInputRequest.setResponseOptions(objectArray);
                    UserInputResponse userInputResponse = this.userInputRequested(userInputRequest);
                    if (userInputResponse.getResponse() != string8) {
                        string4 = userInputResponse.getResponseText();
                        continue;
                    }
                    throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.mediaUnavailableError"));
                }
                catch (ServiceException serviceException) {
                    if (serviceException.getErrorCode() == 317) {
                        throw new ServiceException(317, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.multiMediaInSilentMode"));
                    }
                    throw serviceException;
                }
            }
            this.setMediaLocation(string, n, string4);
            string3 = string4;
        } else {
            if (!this.isProperMedia(string, n, string4)) {
                throw new IOException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.invalidTestFolderLayout"));
            }
            string3 = string4;
        }
        return string3;
    }

    public void ensureResources(String string, String string2) throws ServiceException {
    }

    public URL getApplicationResource(String string) throws IOException {
        URL uRL = null;
        if (string != null) {
            Object object;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            CommandLineTokenizer commandLineTokenizer = new CommandLineTokenizer(this.servicesDef.getResourcePath());
            while (uRL == null && commandLineTokenizer.hasMoreElements()) {
                try {
                    object = FileUtils.createFileName(FileUtils.getParent(this.getHome()), (String)commandLineTokenizer.nextElement());
                    uRL = new URL("archive", "", -1, URLUtils.encodeArchiveURLPath(String.valueOf(object) + string));
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    uRL = null;
                }
            }
            if (uRL == null) {
                uRL = new URL("archive", "", -1, URLUtils.encodeArchiveURLPath(String.valueOf(this.getHome()) + "+/" + this.getId() + string));
                object = uRL.openStream();
                ((InputStream)object).close();
            }
        }
        return uRL;
    }

    public ArchiveIndexAccessor getArchiveIndexAccessor() throws ServiceException, IOException {
        return this.getArchiveIndexReader();
    }

    private ArchiveIndexReader getArchiveIndexReader() throws ServiceException, IOException {
        if (this.reader == null) {
            try {
                URL uRL = this.getResource("index");
                this.reader = ArchiveIndex.getReader(uRL);
            }
            catch (IOException iOException) {
                throw new ServiceException(305, "Archive index is unavailable: " + this.getId() + "/" + "index");
            }
        }
        return this.reader;
    }

    private int getCurrentMediaNumber() {
        return this.currentMediaNumber;
    }

    public URL getExternalResource(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 != 2) {
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.notExternalResource", new String[]{Integer.toString(n)}));
        }
        return this.getSpannedResource(n);
    }

    public String getExternalResourceLocation() {
        return this.externalResourceLocation;
    }

    public String getExternalResourcesHome() {
        return this.externalResourcesHome;
    }

    public String getHome() {
        return this.home;
    }

    public String getId() {
        return this.id;
    }

    public URL getIndexedResource(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 != 1) {
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.notIndexedResource", new String[]{Integer.toString(n)}));
        }
        URL uRL = this.getSpannedResource(n);
        return new URL("compressed", "", -1, uRL.toExternalForm());
    }

    private int getLastSegmentStored(int n) {
        ResourceStorageInfo resourceStorageInfo = this.getStoredResourceInfo(n);
        if (resourceStorageInfo != null) {
            return resourceStorageInfo.lastSegmentStored;
        }
        return -1;
    }

    public String getMediaArchiveHome() {
        return this.mediaArchiveHome;
    }

    public String getMediaLocation(String string, int n) throws ServiceException {
        if (string == null || string.trim().length() == 0) {
            throw new ServiceException(2, "Media context cannot be null or empty string.");
        }
        if (n <= 0) {
            throw new ServiceException(2, "Media number must be greater than zero.");
        }
        if (this.storeMediaLocations) {
            Hashtable hashtable;
            String string2 = null;
            String string3 = string;
            Integer n2 = new Integer(n);
            if (this.mediaLocations.containsKey(string3) && (hashtable = (Hashtable)this.mediaLocations.get(string3)).containsKey(n2)) {
                string2 = (String)hashtable.get(n2);
            }
            return string2;
        }
        return null;
    }

    public URL getNormalResource(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 != 0) {
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.notNormalResource", new String[]{Integer.toString(n)}));
        }
        return this.getSpannedResource(n);
    }

    public URL getResource(String string) throws IOException {
        return this.getApplicationResource(string);
    }

    public abstract Service getService(String var1) throws ServiceException;

    public ServicesDefinition getServicesDefinition() {
        return this.servicesDef;
    }

    private URL getSpannedResource(int n) throws ServiceException, IOException {
        return this.getSpannedResource(n, new Hashtable());
    }

    private URL getSpannedResource(int n, Hashtable hashtable) throws ServiceException, IOException {
        String string = this.createUniqueResourceKey(n);
        URL uRL = this.getStoredResourceURL(n);
        if (uRL == null && string != null && !hashtable.containsKey(string)) {
            String string2 = this.createSpannedResourceDefaultPath(n);
            String string3 = this.createSpannedResourceLocation(n);
            String string4 = this.createSpannedResourceName(n);
            if (string2 != null && string3 != null && string4 != null) {
                int n2;
                String string5;
                boolean bl;
                int n3;
                int n4;
                block23: {
                    n4 = this.getArchiveIndexReader().getStartMediaNumber(n);
                    n3 = this.getArchiveIndexReader().getEndMediaNumber(n);
                    bl = this.getArchiveIndexReader().isDuplicateResource(n);
                    string5 = this.ensureProperMedia("disk.root", this.getCurrentMediaNumber(), string2);
                    n2 = n4;
                    if (this.getLastSegmentStored(n) != -1) {
                        n2 = Math.min(this.getLastSegmentStored(n) + 1, n3);
                    }
                    if (this.storingQueuedResources() && !this.isProperMedia("disk.root", n2, this.createMediaLocation("disk.root", n4, string2))) {
                        if (this.getCurrentMediaNumber() > n2) {
                            try {
                                if (this.shouldStoreQueuedOnMedia(this.getCurrentMediaNumber())) {
                                    this.storeQueuedResources(this.getCurrentMediaNumber(), string5, n, hashtable);
                                }
                            }
                            catch (Exception exception) {
                                if (System.getProperty("is.debug") == null) break block23;
                                exception.printStackTrace();
                            }
                        } else {
                            int n5 = this.getCurrentMediaNumber();
                            while (n5 < n2) {
                                block24: {
                                    try {
                                        if (this.shouldStoreQueuedOnMedia(n5)) {
                                            string5 = this.ensureProperMedia("disk.root", n5, string2);
                                            this.setCurrentMediaNumber(n5);
                                            this.storeQueuedResources(n5, string5, n, hashtable);
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (System.getProperty("is.debug") == null) break block24;
                                        exception.printStackTrace();
                                    }
                                }
                                ++n5;
                            }
                        }
                    }
                }
                string5 = this.ensureProperMedia("disk.root", n2, string2);
                this.setCurrentMediaNumber(n2);
                if (n4 == n3 && !bl) {
                    uRL = this.createSpannedResourceURL(n, string5);
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                } else {
                    try {
                        int n6 = n2;
                        while (n6 <= n3) {
                            URL uRL2 = this.createSpannedResourceURL(n, string5);
                            this.storeResourceSegment(n, n6, uRL2);
                            if (n6 != n3) {
                                block25: {
                                    if (this.storingQueuedResources() && this.shouldStoreQueuedOnMedia(n6)) {
                                        try {
                                            this.storeQueuedResources(n6, string5, n, hashtable);
                                        }
                                        catch (Exception exception) {
                                            if (System.getProperty("is.debug") == null) break block25;
                                            exception.printStackTrace();
                                        }
                                    }
                                }
                                int n7 = n6 + 1;
                                string5 = this.ensureProperMedia("disk.root", n7, string2);
                                this.setCurrentMediaNumber(n7);
                            }
                            ++n6;
                        }
                        uRL = this.getStoredResourceURL(n);
                    }
                    catch (IOException iOException) {
                        uRL = null;
                        throw new IOException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.resourceNotFound", new String[]{iOException.getMessage()}));
                    }
                }
            }
        }
        if (uRL == null) {
            throw new IOException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AbstractWizardServices.resourceNotFound"));
        }
        return uRL;
    }

    private ResourceStorageInfo getStoredResourceInfo(int n) {
        String string = this.createUniqueResourceKey(n);
        if (string != null) {
            return (ResourceStorageInfo)this.storedResources.get(string);
        }
        return null;
    }

    private URL getStoredResourceURL(int n) throws IOException {
        ResourceStorageInfo resourceStorageInfo = this.getStoredResourceInfo(n);
        if (resourceStorageInfo != null) {
            return resourceStorageInfo.getResourceURL();
        }
        return null;
    }

    public Object getUserInput(String string, String string2, Object[] objectArray, Object object) throws ServiceException {
        return null;
    }

    public Object getValue(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.values.get(string);
        }
        return var2_2;
    }

    public WizardLog getWizardLog() {
        return this.log;
    }

    public abstract WizardServices getWizardServices(String var1) throws ServiceException;

    protected void initArchiveIndexReader() {
        try {
            this.getArchiveIndexReader();
        }
        catch (Throwable throwable) {}
    }

    private void initializeLog(WizardLog wizardLog) {
        try {
            if (this.isServiceAvailable("logService")) {
                wizardLog.setLogService(this.getService("logService"));
            }
        }
        catch (ServiceException serviceException) {
            System.err.println("WARNING: could not obtain log service -- defaulting to standard wizard logging");
        }
        this.initializedLog = true;
    }

    private boolean isProperMedia(String string, int n, String string2) throws ServiceException, IOException {
        if (string2 != null) {
            String string3 = String.valueOf(FileUtils.appendSeparator(string2)) + "media.inf";
            return this.compareMediaId(string3, string, n);
        }
        return false;
    }

    public abstract boolean isServiceAvailable(String var1) throws ServiceException;

    private boolean isSpannedResourceArchived(int n) throws ServiceException, IOException {
        int n2 = this.getArchiveIndexReader().getResourceType(n);
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            return true;
        }
        if (n2 == 2) {
            return false;
        }
        return false;
    }

    private static boolean isTestStructure(String string) {
        String string2;
        String string3 = FileUtils.getParent(string);
        if (string3 != null && (string2 = FileUtils.canonizePath(string3)) != null) {
            String string4 = FileUtils.getName(string2);
            return string4 != null && string4.startsWith("disk");
        }
        return false;
    }

    public void logEvent(Object object, String string, Object object2) {
        this.errorsLogged |= string.startsWith("err");
        this.warningsLogged |= string.startsWith("wrn");
        if (this.log != null) {
            if (!this.initializedLog) {
                this.initializeLog(this.log);
            }
            this.log.logEvent(object, string, object2);
        }
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(object, string, object2);
            ++n;
        }
    }

    private static ResourceIndexRange[] mergeRanges(ResourceIndexRange[] resourceIndexRangeArray) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (resourceIndexRangeArray.length > 0) {
            Arrays.sort(resourceIndexRangeArray);
            object = new ResourceIndexRange(resourceIndexRangeArray[0]);
            int n = 1;
            while (n < resourceIndexRangeArray.length) {
                ResourceIndexRange resourceIndexRange = resourceIndexRangeArray[n];
                if (!((ResourceIndexRange)object).merge(resourceIndexRange)) {
                    vector.add(object);
                    object = new ResourceIndexRange(resourceIndexRange);
                }
                ++n;
            }
            vector.add(object);
        }
        object = new ResourceIndexRange[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void putResourceLocation(String string) {
        this.servicesDef.putResourceLocation(string);
    }

    public void queueIndexedResources(ResourceIndexRange[] resourceIndexRangeArray) throws ServiceException, IOException {
        if (this.storingQueuedResources()) {
            int n;
            Object object;
            this.clearIndexedResourceQueue();
            ArchiveIndexReader archiveIndexReader = this.getArchiveIndexReader();
            ResourceIndexRange[] resourceIndexRangeArray2 = AbstractWizardServices.mergeRanges(resourceIndexRangeArray);
            int n2 = 0;
            while (n2 < resourceIndexRangeArray2.length) {
                object = resourceIndexRangeArray2[n2];
                int n3 = ((ResourceIndexRange)object).getRangeOffset() + ((ResourceIndexRange)object).getRangeLength();
                int n4 = ((ResourceIndexRange)object).getRangeOffset();
                while (n4 < n3) {
                    int n5 = archiveIndexReader.getStartMediaNumber(n4);
                    n = archiveIndexReader.getEndMediaNumber(n4);
                    if (archiveIndexReader.isDuplicateResource(n4) || n5 != n) {
                        int n6 = n5;
                        while (n6 <= n) {
                            if (this.queuedIndexRanges.get(new Integer(n6)) == null) {
                                this.queuedIndexRanges.put(new Integer(n6), new Vector());
                            }
                            Vector vector = (Vector)this.queuedIndexRanges.get(new Integer(n6));
                            vector.addElement(new ResourceIndexRange(n4));
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            object = this.queuedIndexRanges.keys();
            while (object.hasMoreElements()) {
                Integer n7 = (Integer)object.nextElement();
                Vector vector = (Vector)this.queuedIndexRanges.get(n7);
                Object[] objectArray = new ResourceIndexRange[vector.size()];
                vector.copyInto(objectArray);
                vector.removeAllElements();
                objectArray = AbstractWizardServices.mergeRanges((ResourceIndexRange[])objectArray);
                n = 0;
                while (n < objectArray.length) {
                    vector.addElement(objectArray[n]);
                    ++n;
                }
                this.queuedIndexRanges.put(n7, vector);
            }
        }
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    public void removeResourceLocation(String string) {
        this.servicesDef.removeResourceLocation(string);
    }

    public void removeStringResolverMethod(StringResolverMethod stringResolverMethod) {
        this.stringResolver.removeMethod(stringResolverMethod);
    }

    public String resolveString(String string) {
        return this.stringResolver.resolve(string);
    }

    public String resolveStringWithValidation(String string) throws StringResolverException {
        return this.stringResolver.resolveWithValidation(string);
    }

    public abstract Enumeration services();

    private void setCurrentMediaNumber(int n) {
        this.currentMediaNumber = n;
    }

    public void setMediaLocation(String string, int n, String string2) throws ServiceException {
        if (string == null || string.trim().length() == 0) {
            throw new ServiceException(2, "Media context cannot be null or empty string.");
        }
        if (n <= 0) {
            throw new ServiceException(2, "Media number must be greater than zero.");
        }
        if (this.storeMediaLocations) {
            String string3 = string;
            Integer n2 = new Integer(n);
            if (string2 == null || string2.trim().length() == 0) {
                Hashtable hashtable;
                if (this.mediaLocations.containsKey(string3) && (hashtable = (Hashtable)this.mediaLocations.get(string3)).containsKey(n2)) {
                    hashtable.remove(n2);
                }
            } else {
                if (!this.mediaLocations.containsKey(string3)) {
                    this.mediaLocations.put(string3, new Hashtable());
                }
                Hashtable hashtable = (Hashtable)this.mediaLocations.get(string3);
                hashtable.put(n2, string2);
            }
        }
    }

    public void setValue(String string, Object object) {
        if (string != null) {
            if (object != null) {
                this.values.put(string, object);
            } else {
                this.values.remove(string);
            }
        }
    }

    public void setValue(String string, Object object, boolean bl) throws ServiceException {
        this.setValue(string, object);
    }

    public void setWizardLog(WizardLog wizardLog) {
        this.log = wizardLog;
    }

    public abstract void setWizardServices(String var1, WizardServices var2) throws ServiceException;

    private static boolean shouldStoreMediaLocations(String string, String string2) {
        return FileUtils.comparePaths(FileUtils.getParent(string), string2);
    }

    private boolean shouldStoreQueuedOnMedia(int n) {
        return this.storingQueuedResources() && n > 0 && n > this.lastStoredMediaNum && this.queuedIndexRanges.get(new Integer(n)) != null;
    }

    public void shutdown() {
        ArchiveURLStreamHandler.closeAllArchives();
    }

    private void storeQueuedResources(int n, String string, int n2, Hashtable hashtable) throws IOException, ServiceException {
        if (this.storingQueuedResources() && this.shouldStoreQueuedOnMedia(n)) {
            hashtable.put(this.createUniqueResourceKey(n2), "");
            Integer n3 = new Integer(n);
            if (n > 0 && this.queuedIndexRanges.get(n3) != null) {
                Vector vector = (Vector)this.queuedIndexRanges.get(n3);
                int n4 = 0;
                while (n4 < vector.size()) {
                    ResourceIndexRange resourceIndexRange = (ResourceIndexRange)vector.elementAt(n4);
                    int n5 = resourceIndexRange.getRangeOffset();
                    int n6 = n5 + resourceIndexRange.getRangeLength();
                    int n7 = n5;
                    while (n7 < n6) {
                        String string2;
                        if (n7 != n2 && (string2 = this.createUniqueResourceKey(n7)) != null && !hashtable.containsKey(string2) && n > this.getLastSegmentStored(n7)) {
                            URL uRL = this.createSpannedResourceURL(n7, string);
                            this.storeResourceSegment(n7, n, uRL);
                        }
                        ++n7;
                    }
                    ++n4;
                }
            }
            this.lastStoredMediaNum = n;
        }
    }

    private ResourceStorageInfo storeResourceSegment(int n, int n2, URL uRL) throws ServiceException, IOException {
        String string;
        if (uRL != null && n2 > 0 && (string = this.createUniqueResourceKey(n)) != null) {
            if (this.storedResources.get(string) == null) {
                this.storedResources.put(string, new ResourceStorageInfo(FileUtils.createTempFile(), this.getArchiveIndexReader().getEndMediaNumber(n)));
            }
            ResourceStorageInfo resourceStorageInfo = (ResourceStorageInfo)this.storedResources.get(string);
            if (n2 > resourceStorageInfo.lastSegmentStored && n2 <= resourceStorageInfo.endMediaNum) {
                FileOutputStream fileOutputStream = new FileOutputStream(resourceStorageInfo.tempFileName, true);
                try {
                    InputStream inputStream = uRL.openStream();
                    FileUtils.copy(inputStream, fileOutputStream);
                    inputStream.close();
                    resourceStorageInfo.lastSegmentStored = n2;
                }
                catch (IOException iOException) {
                    File file;
                    this.storedResources.remove(string);
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    if ((file = new File(resourceStorageInfo.tempFileName)).exists() && file.delete()) {
                        FileUtils.deleteTempFile(resourceStorageInfo.tempFileName);
                    }
                    throw iOException;
                }
            }
            return resourceStorageInfo;
        }
        return null;
    }

    private boolean storingQueuedResources() {
        return this.usingTestStructure ^ true;
    }

    public abstract UserInputResponse userInputRequested(UserInputRequest var1) throws ServiceException;
}

