/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.wizard.service.AbstractService;
import com.installshield.wizard.service.ImplementorProxy;
import com.installshield.wizard.service.LocalImplementorProxy;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.ServiceImplementorDef;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;

public class ServiceFactory {
    private static ServiceImplementor createBestFitImpl(ServiceImplementorDef serviceImplementorDef) throws ServiceException {
        int n = 0;
        ServiceImplementor serviceImplementor = null;
        int n2 = 0;
        while (n2 < serviceImplementorDef.getImplCount()) {
            block6: {
                String string = serviceImplementorDef.getImpl(n2);
                try {
                    ServiceImplementor serviceImplementor2 = (ServiceImplementor)Class.forName(string).newInstance();
                    if (serviceImplementor2.getSystemCompatibility() > n) {
                        serviceImplementor = serviceImplementor2;
                        n = serviceImplementor.getSystemCompatibility();
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("could not load service implementor " + string + " due to the following exception: " + throwable);
                    if (System.getProperty("is.debug") == null) break block6;
                    throwable.printStackTrace();
                }
            }
            ++n2;
        }
        if (serviceImplementor == null) {
            serviceImplementor = ServiceFactory.createDefaultImpl(serviceImplementorDef);
        }
        if (serviceImplementor == null) {
            throw new ServiceException(313, serviceImplementorDef.getInterface());
        }
        return serviceImplementor;
    }

    private static ServiceImplementor createDefaultImpl(ServiceImplementorDef serviceImplementorDef) {
        try {
            return (ServiceImplementor)Class.forName(serviceImplementorDef.getDefaultImpl()).newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("could not load default service implementor " + serviceImplementorDef.getDefaultImpl() + " due to the following exception: " + throwable);
            if (System.getProperty("is.debug") != null) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private static Service createDefaultServiceImpl(String string, ServicesDefinition servicesDefinition) throws ServiceException {
        Service service = null;
        int n = 0;
        while (service == null && n < servicesDefinition.getServiceCount()) {
            ServiceDef serviceDef = servicesDefinition.getService(n);
            if (serviceDef.getName().equals(string)) {
                try {
                    Class<?> clazz = Class.forName(serviceDef.getInterface());
                    Class<?> clazz2 = Class.forName(serviceDef.getDefaultImpl());
                    if (!clazz.isAssignableFrom(clazz2)) {
                        throw new ServiceException(304, String.valueOf(clazz2.getName()) + " does not extend " + clazz.getName());
                    }
                    service = (Service)clazz2.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ServiceException(309, classNotFoundException.getClass().toString());
                }
                catch (Throwable throwable) {
                    throw new ServiceException(310, "could not instantiate " + throwable.getMessage());
                }
            }
            ++n;
        }
        if (service == null) {
            throw new ServiceException(306, string);
        }
        return service;
    }

    private static ServiceImplementor createImpl(String string, Class clazz, ServicesDefinition servicesDefinition, WizardServices wizardServices) throws ServiceException {
        int n = 0;
        while (n < servicesDefinition.getImplementorCount()) {
            block9: {
                ServiceImplementorDef serviceImplementorDef = servicesDefinition.getImplementor(n);
                if (serviceImplementorDef.getName().equals(string)) {
                    if (!serviceImplementorDef.getInterface().equals(clazz.getName())) {
                        throw new ServiceException(318, "implementor " + serviceImplementorDef.getName() + " is required by service to be " + clazz);
                    }
                    ServiceImplementor serviceImplementor = ServiceFactory.createBestFitImpl(serviceImplementorDef);
                    try {
                        if (serviceImplementor != null) {
                            serviceImplementor.initialize(serviceImplementorDef.getProperties(), wizardServices);
                        }
                        return serviceImplementor;
                    }
                    catch (Throwable throwable) {
                        ServiceImplementor serviceImplementor2;
                        System.err.println("WARNING: could not initialize impl " + serviceImplementor.getClass());
                        if (System.getProperty("is.debug") != null) {
                            throwable.printStackTrace();
                        }
                        if ((serviceImplementor2 = ServiceFactory.createDefaultImpl(serviceImplementorDef)) == null || serviceImplementor2.getClass() == serviceImplementor.getClass()) break block9;
                        try {
                            serviceImplementor2.initialize(serviceImplementorDef.getProperties(), wizardServices);
                            return serviceImplementor2;
                        }
                        catch (Throwable throwable2) {
                            System.err.println("WARNING: could not initialize default impl " + serviceImplementor2.getClass());
                            if (System.getProperty("is.debug") == null) break block9;
                            throwable2.printStackTrace();
                        }
                    }
                }
            }
            ++n;
        }
        throw new ServiceException(312, clazz.getName());
    }

    public static Service createService(String string, ServicesDefinition servicesDefinition, ImplementorProxy implementorProxy, WizardServices wizardServices) throws ServiceException {
        Service service = ServiceFactory.createDefaultServiceImpl(string, servicesDefinition);
        if (service instanceof AbstractService) {
            if (implementorProxy == null) {
                Class clazz = service.getServiceImplementorType();
                ServiceImplementor serviceImplementor = ServiceFactory.createImpl(string, clazz, servicesDefinition, wizardServices);
                implementorProxy = new LocalImplementorProxy(clazz, serviceImplementor);
            }
            ((AbstractService)service).setImplementorProxy(implementorProxy);
        }
        return service;
    }

    public static Service createService(String string, ServicesDefinition servicesDefinition, WizardServices wizardServices) throws ServiceException {
        return ServiceFactory.createService(string, servicesDefinition, null, wizardServices);
    }

    public static Service createService(String string, ServicesDefinition servicesDefinition, String[] stringArray) throws ServiceException {
        throw new RuntimeException("not implemented");
    }

    public static String getCurrentImplementorType(Service service) {
        if (service instanceof AbstractService) {
            ImplementorProxy implementorProxy = ((AbstractService)service).getImplementorProxy();
            return implementorProxy != null ? implementorProxy.getImplementorType() : null;
        }
        return null;
    }

    public static void shutdownService(Service service) throws ServiceException {
        ImplementorProxy implementorProxy;
        if (service instanceof AbstractService && (implementorProxy = ((AbstractService)service).getImplementorProxy()) != null) {
            implementorProxy.close();
        }
    }
}

