/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import com.installshield.util.MD5;
import com.installshield.wizard.swing.JFlowLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class SwingText
extends JPanel
implements KeyListener {
    public static final int HTML = 1;
    public static final int PLAIN_TEXT = 2;
    private String text;
    private boolean showBorder;
    private int contentType;
    private JComponent ui;
    private JScrollPane scroll;
    private JTextPane editorPane;
    private JTextArea textArea;

    public SwingText() {
        this("", 2, false);
    }

    public SwingText(String string) {
        this(string, 2, false);
    }

    public SwingText(String string, int n, boolean bl) {
        this.text = string;
        this.verifyContentType(n);
        this.contentType = n;
        this.showBorder = bl;
        this.setLayout(new BorderLayout());
        this.ui = this.createUI();
        this.add((Component)this.ui, "Center");
    }

    public void addNotify() {
        super.addNotify();
        if (this.ui == null) {
            this.ui = this.createUI();
            this.add((Component)this.ui, "Center");
        } else {
            this.add((Component)this.ui, "Center");
        }
        this.ui.setEnabled(this.isEnabled());
        this.ui.setForeground(this.getForeground());
        this.ui.setBackground(this.getBackground());
        if (this.ui instanceof Container) {
            this.enable(this.ui, this.isEnabled());
            this.foreground(this.ui, this.getForeground());
            this.background(this.ui, this.getBackground());
        }
        this.setTextImpl(this.text);
    }

    private void background(Container container, Color color) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (componentArray != null && n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.background((Container)componentArray[n], color);
            }
            componentArray[n].setBackground(color);
            ++n;
        }
    }

    private void createHtmlView(JScrollPane jScrollPane) {
        this.editorPane = new JTextPane(){

            public boolean isFocusCycleRoot() {
                return false;
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public boolean isManagingFocus() {
                return false;
            }
        };
        this.editorPane.setEditable(false);
        this.editorPane.addKeyListener(this);
        jScrollPane.setViewportView(this.editorPane);
    }

    private void createTextView(JScrollPane jScrollPane) {
        this.textArea = new JTextArea(){

            public boolean isManagingFocus() {
                return false;
            }
        };
        this.textArea.setEditable(false);
        this.textArea.addKeyListener(this);
        jScrollPane.setViewportView(this.textArea);
    }

    private JComponent createUI() {
        if (this.contentType != 1 && !this.showBorder) {
            return new JFlowLabel();
        }
        this.scroll = new JScrollPane();
        this.refreshUI(this.scroll);
        return this.scroll;
    }

    private void enable(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (componentArray != null && n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            if (componentArray[n] instanceof Container) {
                this.enable((Container)componentArray[n], bl);
            }
            ++n;
        }
    }

    private Color findBackground() {
        Color color = this.getBackground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getBackground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.white;
    }

    private Font findFont() {
        Font font = this.getFont();
        Container container = this.getParent();
        while (font == null && container != null) {
            font = container.getFont();
            container = container.getParent();
        }
        return font;
    }

    private Color findForeground() {
        Color color = this.getForeground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getForeground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.black;
    }

    private void foreground(Container container, Color color) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (componentArray != null && n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.foreground((Container)componentArray[n], color);
            }
            componentArray[n].setForeground(color);
            ++n;
        }
    }

    private String formatColor(Color color) {
        return "#" + MD5.toHex(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public String getText() {
        return this.text;
    }

    public JComponent getTextComponent() {
        if (this.ui instanceof JScrollPane) {
            return (JComponent)((JScrollPane)this.ui).getViewport().getView();
        }
        return this.ui;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t') {
            if ((keyEvent.getModifiers() & 1) != 0) {
                FocusManager.getCurrentManager().focusPreviousComponent(keyEvent.getComponent());
            } else {
                FocusManager.getCurrentManager().focusNextComponent(keyEvent.getComponent());
            }
        }
    }

    private void refreshHtmlView() {
        this.editorPane.setContentType("text/html");
        this.editorPane.setBackground(this.findBackground());
        this.editorPane.setForeground(this.findForeground());
        StyleSheet styleSheet = ((HTMLEditorKit)this.editorPane.getEditorKit()).getStyleSheet();
        Font font = this.findFont();
        styleSheet.addRule("body {font-size: " + font.getSize() + "pt; }");
        styleSheet.addRule("body {font-family: " + font.getFamily() + "; }");
        if (font.isPlain()) {
            styleSheet.addRule("body {font-style: normal; }");
        } else {
            if (font.isItalic()) {
                styleSheet.addRule("body {font-style: italic; }");
            }
            if (font.isBold()) {
                styleSheet.addRule("body {font-weight: bold; }");
            }
        }
    }

    private void refreshTextView() {
        this.textArea.setLineWrap(true);
        this.textArea.setFont(this.findFont());
        this.textArea.setWrapStyleWord(true);
        this.textArea.setForeground(this.findForeground());
        this.textArea.setBackground(this.findBackground());
        this.textArea.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
    }

    private void refreshUI(JScrollPane jScrollPane) {
        if (this.contentType == 1) {
            if (jScrollPane.getViewport().getView() == null) {
                this.createHtmlView(jScrollPane);
                this.refreshHtmlView();
                if (!this.showBorder) {
                    jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                }
            } else if (jScrollPane.getViewport().getView() instanceof JTextArea) {
                this.refreshTextView();
            } else {
                this.refreshHtmlView();
            }
        } else if (this.showBorder) {
            if (jScrollPane.getViewport().getView() == null) {
                this.createTextView(jScrollPane);
                this.refreshTextView();
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
                jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            } else {
                this.refreshTextView();
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.ui != null) {
            this.remove(this.ui);
            this.ui = null;
        }
    }

    private void reset() {
        if (this.ui != null) {
            if (this.ui instanceof JScrollPane) {
                this.refreshUI((JScrollPane)this.ui);
            } else if (this.ui instanceof JFlowLabel) {
                this.remove(this.ui);
                this.ui = this.createUI();
                this.add((Component)this.ui, "Center");
            }
            this.validate();
            this.repaint();
        }
    }

    public void setContentType(int n) {
        this.verifyContentType(n);
        this.contentType = n;
        this.reset();
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.reset();
    }

    public void setText(String string) {
        this.text = string;
        this.setTextImpl(string);
    }

    private void setTextImpl(String string) {
        if (this.ui instanceof JScrollPane) {
            Component component = ((JScrollPane)this.ui).getViewport().getView();
            if (component instanceof JTextPane) {
                JTextPane jTextPane = (JTextPane)component;
                jTextPane.setDocument(new HTMLEditorKit().createDefaultDocument());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><body text=\"");
                stringBuffer.append(this.formatColor(this.findForeground()));
                stringBuffer.append("\">");
                stringBuffer.append(string);
                stringBuffer.append("</body></html>");
                jTextPane.setText(stringBuffer.toString());
                jTextPane.setCaretPosition(1);
                jTextPane.getAccessibleContext().setAccessibleName(this.getAccessibleContext().getAccessibleName());
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setText(string);
                if (!string.equals("")) {
                    ((JTextArea)component).setCaretPosition(1);
                }
                ((JTextArea)component).getAccessibleContext().setAccessibleName(this.getAccessibleContext().getAccessibleName());
            }
        } else if (this.ui instanceof JFlowLabel) {
            ((JFlowLabel)this.ui).setText(string);
        }
    }

    private void verifyContentType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal content type: " + n);
        }
    }
}

