/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.JFlowLabel;
import com.installshield.wizard.swing.JISBranding;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SwingTextInputDialog
extends JDialog
implements ActionListener,
KeyListener {
    public static final int TEXT = 0;
    public static final int PATH_FILES_AND_DIRECTORIES = 1;
    public static final int PATH_DIRECTORIES_ONLY = 2;
    public static final int PATH_FILES_ONLY = 3;
    private String textValue;
    private int result;
    private int type;
    private JTextField userInputField = null;
    private JButton browseButton = null;
    private JButton[] buttons;
    private int transferFocusIndex = 0;
    private final int captionWidth = 10;

    public SwingTextInputDialog(Frame frame, String string, String string2, int n, String string3, String[] stringArray, int n2, Image image, String string4) {
        super(frame, string, true);
        JPanel jPanel;
        Object object;
        Accessible accessible;
        if (stringArray == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        if (n2 < 0 || n2 >= stringArray.length) {
            throw new IllegalArgumentException("defaultOptionIndex parameter must indicate acceptable index within the options array");
        }
        this.type = n;
        this.textValue = string3 != null ? string3 : "";
        this.transferFocusIndex = this.result = n2 >= 0 && n2 < stringArray.length ? n2 : 0;
        this.getContentPane().setForeground(SystemColor.controlText);
        this.getContentPane().setBackground(SystemColor.control);
        this.getContentPane().setLayout(new ColumnLayout());
        this.setTitle(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new ColumnLayout());
        this.getContentPane().add((Component)jPanel2, ColumnConstraints.createLeftAlign());
        this.setDefaultCloseOperation(0);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        if (image != null) {
            accessible = new ImageIcon(image);
            object = new JLabel((Icon)((Object)accessible));
            jPanel3.add((Component)object);
            jPanel3.add(Spacing.createHorizontalSpacing(5));
        }
        accessible = new JPanel(new ColumnLayout());
        object = new MnemonicString(string2);
        JFlowLabel jFlowLabel = new JFlowLabel(((MnemonicString)object).toString());
        ((Container)((Object)accessible)).add(jFlowLabel, ColumnConstraints.createLeftAlign());
        jPanel3.add((Component)((Object)accessible));
        jPanel2.add((Component)jPanel3, ColumnConstraints.createLeftAlign());
        if (n == 0) {
            jPanel2.add(Spacing.createVerticalSpacing(4));
            this.userInputField = new JTextField(this.textValue);
            jPanel2.add((Component)this.userInputField, ColumnConstraints.createHorizontalFill());
        } else {
            this.userInputField = new JTextField(40);
            this.userInputField.setText(this.textValue);
            jPanel2.add(Spacing.createVerticalSpacing(4));
            jPanel2.add((Component)this.userInputField, ColumnConstraints.createHorizontalFill());
            this.browseButton = this.createJButton(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browseWithMn"));
            jPanel2.add(Spacing.createVerticalSpacing(4));
            jPanel2.add((Component)this.browseButton, ColumnConstraints.createRightAlign());
        }
        this.userInputField.addKeyListener(this);
        if (((MnemonicString)object).isMnemonicSpecified()) {
            jFlowLabel.setDisplayedMnemonic(((MnemonicString)object).getMnemonicChar());
            jFlowLabel.setLabelFor(this.userInputField);
        }
        if (string4 != null && string4.trim().length() != 0) {
            jPanel = new JISBranding(string4);
            jPanel2.add(Spacing.createVerticalSpacing(4));
            jPanel2.add((Component)jPanel, ColumnConstraints.createHorizontalFill());
        }
        jPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.buttons = new JButton[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.buttons[n3] = this.createJButton(stringArray[n3]);
            jPanel.add(this.buttons[n3]);
            ++n3;
        }
        jPanel2.add(Spacing.createVerticalSpacing(10));
        jPanel2.add((Component)jPanel, ColumnConstraints.createCenterAlign());
        ((Component)this).setSize(375, 175);
        this.enableEvents(64L);
        this.pack();
        Frame frame2 = frame;
        synchronized (frame2) {
            Dimension dimension = frame.isVisible() ? frame.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            Point point = frame.isVisible() ? frame.getLocation() : new Point(0, 0);
            ((Component)this).setLocation(point.x + (dimension.width - this.getSize().width) / 2, point.y + (dimension.height - this.getSize().height) / 2);
        }
        this.setResizable(false);
    }

    public SwingTextInputDialog(Frame frame, String string, String string2, String string3, String[] stringArray, int n) {
        this(frame, string, string2, 0, string3, stringArray, n, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseButton) {
            String string;
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.userInputField.getText()));
            switch (this.type) {
                case 3: {
                    n = 0;
                    string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.File");
                    break;
                }
                case 2: {
                    n = 1;
                    string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder");
                    break;
                }
                default: {
                    string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.File");
                    n = 2;
                }
            }
            jFileChooser.setFileSelectionMode(n);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setLocation(this.getLocation().x + (this.getSize().width - jFileChooser.getSize().width) / 2, this.getLocation().y + (this.getSize().height - jFileChooser.getSize().height) / 2);
            int n2 = jFileChooser.showDialog(this, null);
            if (n2 == 0 && jFileChooser.getSelectedFile() != null) {
                this.userInputField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
            this.requestFocus();
        } else {
            this.result = -1;
            int n = 0;
            while (n < this.buttons.length) {
                if (this.buttons[n] == actionEvent.getSource()) {
                    this.result = n;
                    break;
                }
                ++n;
            }
            this.textValue = this.userInputField.getText();
            ((Component)this).setVisible(false);
        }
    }

    private JButton createJButton(String string) {
        MnemonicString mnemonicString = new MnemonicString(string);
        JButton jButton = new JButton(this.pad(mnemonicString.toString()));
        if (mnemonicString.isMnemonicSpecified()) {
            jButton.setMnemonic(mnemonicString.getMnemonicChar());
        }
        jButton.addActionListener(this);
        jButton.addKeyListener(this);
        return jButton;
    }

    public int getResult() {
        return this.result;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, ""));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private String pad(String string) {
        int n = 10 - string.length();
        if (n > 0) {
            n /= 2;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append(string);
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(' ');
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 202) {
            this.result = -1;
            ((Component)this).setVisible(false);
        } else if (windowEvent.getID() == 200) {
            this.userInputField.requestFocus();
            this.userInputField.selectAll();
        }
    }
}

