/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import com.installshield.util.FontDef;
import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.util.PropertyUtils;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.util.sort.LocaleCompare;
import com.installshield.util.sort.SortUtils;
import com.installshield.wizard.DefaultProgressRenderer;
import com.installshield.wizard.ProgressRenderer;
import com.installshield.wizard.ProgressRendererImpl;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardPanelImpl;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.awt.AWTWizardUI;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ComponentUtils;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.swing.BackgroundImagePanel;
import com.installshield.wizard.swing.DefaultProgressRendererSwingImpl;
import com.installshield.wizard.swing.JISBranding;
import com.installshield.wizard.swing.SwingMode;
import com.installshield.wizard.swing.SwingProgressRendererImpl;
import com.installshield.wizard.swing.SwingTextInputDialog;
import com.installshield.wizard.swing.SwingWizardPanelImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SwingWizardUI
extends AWTWizardUI
implements ActionListener {
    public static final int BACKGROUND = 100;
    private String backgroundInsets = "0, 140, 0, 0";
    private boolean useSystemLookAndFeel = true;
    private Hashtable javaDefaultColors = new Hashtable();
    private String[] bkgndColorProps = new String[]{"Panel.background", "OptionPane.background", "CheckBox.background", "RadioButton.background", "ToolBar.background"};
    private String[] frgndColorProps = new String[]{"text", "windowText", "Panel.foreground", "OptionPane.foreground", "OptionPane.messageForeground", "Button.foreground", "RadioButton.foreground", "CheckBox.foreground", "ComboBox.foreground", "Label.foreground", "List.foreground", "TextField.foreground", "PasswordField.foreground", "TextArea.foreground", "TextPane.foreground", "EditorPane.foreground", "EditorPane.inactiveForeground", "ToolBar.foreground"};
    private JOptionPane userInputPane = null;
    private JDialog userInputDialog = null;
    static /* synthetic */ Class class$com$installshield$wizard$swing$SwingWizardPanelImpl;

    public SwingWizardUI() {
        this.setWizardImageOrientation(100);
        this.setBackgroundColor("Color.white");
        this.setForegroundColor("Color.black");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (this.userInputPane != null && this.userInputDialog != null) {
            int n = 0;
            while (n < this.userInputPane.getOptions().length) {
                if (this.userInputPane.getOptions()[n] == actionEvent.getSource()) {
                    this.userInputPane.setValue(((JButton)actionEvent.getSource()).getActionCommand());
                    ((Component)this.userInputDialog).setVisible(false);
                }
                ++n;
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putPackage("com.installshield.wizard.swing");
            wizardBuilderSupport.getWizard().addStartupBean(new SwingMode());
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent(this, "err", exception);
        }
    }

    private Insets calculateInsets(String string) {
        Insets insets;
        block6: {
            insets = new Insets(0, 0, 0, 0);
            if (string == null || string.length() <= 0) break block6;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            try {
                if (stringTokenizer.hasMoreElements()) {
                    insets.top = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.left = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.bottom = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.right = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
            }
            catch (Throwable throwable) {}
        }
        return insets;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Component createBusyPanel(String string) {
        JLabel jLabel = new JLabel(string, 0);
        FontDef fontDef = this.getDefaultFont();
        if (fontDef != null) {
            jLabel.setFont(new Font(fontDef.getName(), 1, fontDef.getSize() + 2));
        }
        return jLabel;
    }

    protected Component createDefaultBranding() {
        return new JISBranding("InstallShield");
    }

    protected Frame createFrame() {
        JFrame jFrame;
        block3: {
            jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(0);
            Object object = UIManager.getDefaults().get("Panel.background");
            if (object instanceof Color) {
                ((Component)jFrame).setBackground((Color)object);
            }
            if (!this.isBackgroundImageUsed()) break block3;
            try {
                URL uRL = this.getWizard().getResource(this.getWizardImage());
                ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL));
                jFrame.setContentPane(new BackgroundImagePanel(imageIcon, this.getFrameResizable()));
            }
            catch (Exception exception) {}
        }
        return jFrame;
    }

    protected Container createImagePanel(String string) {
        Image image;
        if (string != null && string.trim().length() > 0 && (image = this.loadImage(string)) != null) {
            return new JLabel(new ImageIcon(image));
        }
        return null;
    }

    protected Container createInsetsPanel(int n, int n2, int n3, int n4) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        return jPanel;
    }

    protected Component createLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string, 0);
        if (font != null) {
            jLabel.setFont(font);
        }
        return jLabel;
    }

    protected AWTWizardUI.NavigationController createNavigationController() {
        if (this.getNavigationControllerType() != null && this.getNavigationControllerType().length() > 0) {
            try {
                return (AWTWizardUI.NavigationController)Class.forName(this.getNavigationControllerType()).newInstance();
            }
            catch (Throwable throwable) {
                System.out.println("WARNING: could not create navigation controller from class: " + this.getNavigationControllerType());
            }
        }
        return new SwingNavigationController();
    }

    protected Container createPanel() {
        return new JPanel();
    }

    public void disableCancelButton() {
        this.getNavigationController().cancel().setEnabled(false);
    }

    public void displayUserMessage(String string, String string2, int n) {
        this.userInputRequested(new UserInputRequest(string, string2, n));
    }

    protected void doDefaultLayout() {
        if (this.isBackgroundImageUsed()) {
            JPanel jPanel = (JPanel)this.createInsetsPanel(10, 10, 10, 10);
            this.getFrameContentPane().add((Component)jPanel, "Center");
            jPanel.setLayout(new BorderLayout(10, 10));
            jPanel.setOpaque(false);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            Insets insets = this.calculateInsets(this.getBackgroundInsets());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            jPanel2.setOpaque(false);
            jPanel.add((Component)jPanel2, "Center");
            ((JPanel)this.currentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            jPanel2.add((Component)this.currentPane, "Center");
            JPanel jPanel3 = (JPanel)this.createDefaultBranding();
            jPanel3.setOpaque(false);
            JPanel jPanel4 = (JPanel)this.createPanel();
            jPanel4.setOpaque(false);
            jPanel4.setLayout(new GridLayout(2, 1, 0, 0));
            jPanel4.add(jPanel3);
            jPanel4.add(this.controller.getComponent());
            jPanel.add((Component)jPanel4, "South");
        } else {
            super.doDefaultLayout();
        }
    }

    public String getBackgroundInsets() {
        return this.backgroundInsets;
    }

    public Locale getDefaultLocale(Locale[] localeArray, Locale locale, Wizard wizard) {
        class Com_installshield_wizard_swing_SwingWizardUI$1 {
            /* synthetic */ Com_installshield_wizard_swing_SwingWizardUI$1() {
            }
        }
        SwingLocaleDialog swingLocaleDialog = new SwingLocaleDialog(null, localeArray, locale, wizard);
        swingLocaleDialog.setVisible(true);
        while (swingLocaleDialog.isVisible()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                throw new Error();
            }
        }
        return swingLocaleDialog.getSelectedLocale();
    }

    protected ProgressRenderer getDefaultProgressRenderer() {
        DefaultProgressRenderer defaultProgressRenderer = new DefaultProgressRenderer();
        DefaultProgressRendererSwingImpl defaultProgressRendererSwingImpl = new DefaultProgressRendererSwingImpl();
        defaultProgressRenderer.setProgressRendererImpl(defaultProgressRendererSwingImpl);
        defaultProgressRendererSwingImpl.setProgressRenderer(defaultProgressRenderer);
        defaultProgressRendererSwingImpl.initialize();
        return defaultProgressRenderer;
    }

    protected Container getFrameContentPane() {
        return ((JFrame)this.getFrame()).getContentPane();
    }

    public String getName() {
        return "swing";
    }

    public WizardUI getNextUI(Wizard wizard) {
        int n = 0;
        while (n < wizard.getInterfaces().length) {
            if (wizard.getInterfaces()[n].getName().equals("awt")) {
                return wizard.getInterfaces()[n];
            }
            ++n;
        }
        return null;
    }

    protected Component getPanelComponent(WizardPanelImpl wizardPanelImpl) {
        if (wizardPanelImpl instanceof SwingWizardPanelImpl) {
            return (SwingWizardPanelImpl)wizardPanelImpl;
        }
        return super.getPanelComponent(wizardPanelImpl);
    }

    protected WizardPanelImpl getPanelImpl(WizardPanel wizardPanel) throws IllegalAccessException, InstantiationException {
        WizardPanelImpl wizardPanelImpl = wizardPanel.getWizardPanelImpl();
        if (wizardPanelImpl == null) {
            try {
                Class clazz = wizardPanel.getWizardPanelImpl("swing");
                if (clazz != null) {
                    wizardPanelImpl = (SwingWizardPanelImpl)clazz.newInstance();
                    ((SwingWizardPanelImpl)wizardPanelImpl).setPanel(wizardPanel);
                    wizardPanel.setWizardPanelImpl(wizardPanelImpl);
                }
            }
            catch (Exception exception) {
                wizardPanel.logEvent(this, "wrn", "Could not load swing panel: " + exception);
            }
        }
        if (wizardPanelImpl != null) {
            return wizardPanelImpl;
        }
        return super.getPanelImpl(wizardPanel);
    }

    protected Component getProgressRendererComponent(ProgressRenderer progressRenderer) {
        block3: {
            try {
                ProgressRendererImpl progressRendererImpl = this.getProgressRendererImpl(progressRenderer);
                if (progressRendererImpl instanceof SwingProgressRendererImpl) {
                    return (SwingProgressRendererImpl)progressRendererImpl;
                }
            }
            catch (Throwable throwable) {
                if (System.getProperty("is.debug") == null) break block3;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    protected ProgressRendererImpl getProgressRendererImpl(ProgressRenderer progressRenderer) throws IllegalAccessException, InstantiationException {
        Class clazz;
        if (progressRenderer.getProgressRendererImpl() != null && !(progressRenderer.getProgressRendererImpl() instanceof SwingProgressRendererImpl)) {
            throw new Error("unexpected progress renderer impl type");
        }
        SwingProgressRendererImpl swingProgressRendererImpl = (SwingProgressRendererImpl)progressRenderer.getProgressRendererImpl();
        if (swingProgressRendererImpl == null && (clazz = progressRenderer.getProgressRendererImpl("swing")) != null) {
            swingProgressRendererImpl = (SwingProgressRendererImpl)clazz.newInstance();
            swingProgressRendererImpl.setProgressRenderer(progressRenderer);
            progressRenderer.setProgressRendererImpl(swingProgressRendererImpl);
            swingProgressRendererImpl.initialize();
        }
        return swingProgressRendererImpl;
    }

    public boolean getUseSystemLookAndFeel() {
        return this.useSystemLookAndFeel;
    }

    public void initialize(Wizard wizard) {
        if (this.useSystemLookAndFeel) {
            SwingWizardUI.switchToSystemLAF(this, wizard.getServices());
        }
        int n = 0;
        while (n < this.bkgndColorProps.length) {
            this.javaDefaultColors.put(this.bkgndColorProps[n], UIManager.getDefaults().get(this.bkgndColorProps[n]));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.frgndColorProps.length) {
            this.javaDefaultColors.put(this.frgndColorProps[n2], UIManager.getDefaults().get(this.frgndColorProps[n2]));
            ++n2;
        }
        this.setWizardColors();
        FontDef fontDef = this.getDefaultFont();
        if (fontDef != null) {
            Font font = new Font(fontDef.getName(), fontDef.getStyle(), fontDef.getSize());
            Enumeration enumeration = UIManager.getDefaults().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!(UIManager.getDefaults().get(k) instanceof Font)) continue;
                UIManager.getDefaults().put(k, font);
            }
        }
        SwingWizardUI.initializeFileChooser();
        super.initialize(wizard);
    }

    private static void initializeFileChooser() {
        String[] stringArray = new String[]{"FileChooser.acceptAllFileFilterText", "", "FileChooser.cancelButtonText", "FileChooser.cancelButtonMnemonic", "FileChooser.cancelButtonToolTipText", "", "FileChooser.directoryDescriptionText", "", "FileChooser.directoryOpenButtonText", "", "FileChooser.directoryOpenButtonToolTipText", "", "FileChooser.fileDescriptionText", "", "FileChooser.helpButtonText", "FileChooser.helpButtonMnemonic", "FileChooser.helpButtonToolTipText", "", "FileChooser.newFolderErrorSeparator", "", "FileChooser.newFolderErrorText", "", "FileChooser.openButtonText", "FileChooser.openButtonMnemonic", "FileChooser.openButtonToolTipText", "", "FileChooser.openDialogTitleText", "", "FileChooser.other.newFolder.subsequent", "", "FileChooser.other.newFolder", "", "FileChooser.saveButtonText", "FileChooser.saveButtonMnemonic", "FileChooser.saveButtonToolTipText", "", "FileChooser.saveDialogTitleText", "", "FileChooser.updateButtonText", "FileChooser.updateButtonMnemonic", "FileChooser.updateButtonToolTipText", "", "FileChooser.win32.newFolder.subsequent", "", "FileChooser.win32.newFolder", "", "FileChooser.detailsViewButtonAccessibleName", "", "FileChooser.detailsViewButtonToolTipText", "", "FileChooser.fileAttrHeaderText", "", "FileChooser.fileDateHeaderText", "", "FileChooser.fileNameHeaderText", "", "FileChooser.fileNameLabelText", "FileChooser.fileNameLabelMnemonic", "FileChooser.fileSizeHeaderText", "", "FileChooser.filesOfTypeLabelText", "FileChooser.filesOfTypeLabelMnemonic", "FileChooser.fileTypeHeaderText", "", "FileChooser.homeFolderAccessibleName", "", "FileChooser.homeFolderToolTipText", "", "FileChooser.listViewButtonAccessibleName", "", "FileChooser.listViewButtonToolTipText", "", "FileChooser.lookInLabelText", "FileChooser.lookInLabelMnemonic", "FileChooser.newFolderAccessibleName", "", "FileChooser.newFolderToolTipText", "", "FileChooser.saveInLabelText", "", "FileChooser.upFolderAccessibleName", "", "FileChooser.upFolderToolTipText", "", "FileChooser.enterFileNameLabelText", "FileChooser.enterFileNameLabelMnemonic", "FileChooser.filesLabelText", "FileChooser.filesLabelMnemonic", "FileChooser.filterLabelText", "FileChooser.filterLabelMnemonic", "FileChooser.foldersLabelText", "FileChooser.foldersLabelMnemonic", "FileChooser.pathLabelText", "FileChooser.pathLabelMnemonic"};
        int n = 0;
        while (n < stringArray.length) {
            MnemonicString mnemonicString = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", stringArray[n]));
            UIManager.put(stringArray[n], mnemonicString.toString());
            if (stringArray[n + 1].length() > 0 && mnemonicString.isMnemonicSpecified()) {
                UIManager.put(stringArray[n + 1], new Integer(Character.toUpperCase(mnemonicString.getMnemonicChar())));
            }
            n += 2;
        }
    }

    private boolean isBackgroundImageUsed() {
        return this.getWizardImageOrientation() == 100 && this.getWizardImage() != null && !this.getWizardImage().equals("");
    }

    protected boolean isDisplayablePanel(WizardBean wizardBean) {
        if (!(wizardBean instanceof WizardPanel)) {
            return false;
        }
        Class clazz = ((WizardPanel)wizardBean).getWizardPanelImpl("swing");
        if (clazz == null) {
            return super.isDisplayablePanel(wizardBean);
        }
        return (class$com$installshield$wizard$swing$SwingWizardPanelImpl != null ? class$com$installshield$wizard$swing$SwingWizardPanelImpl : (class$com$installshield$wizard$swing$SwingWizardPanelImpl = SwingWizardUI.class$("com.installshield.wizard.swing.SwingWizardPanelImpl"))).isAssignableFrom(clazz);
    }

    protected boolean isPanelImplInitialized(WizardPanelImpl wizardPanelImpl) {
        if (wizardPanelImpl instanceof SwingWizardPanelImpl) {
            return ((SwingWizardPanelImpl)wizardPanelImpl).isInitialized();
        }
        return super.isPanelImplInitialized(wizardPanelImpl);
    }

    public void restoreDefaultColors() {
        Enumeration enumeration = this.javaDefaultColors.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            UIManager.getDefaults().put(k, this.javaDefaultColors.get(k));
        }
    }

    public void setBackgroundInsets(String string) {
        this.backgroundInsets = string;
    }

    protected void setPanelImplInitialized(WizardPanelImpl wizardPanelImpl) {
        if (wizardPanelImpl instanceof SwingWizardPanelImpl) {
            ((SwingWizardPanelImpl)wizardPanelImpl).setInitialized(true);
        } else {
            super.setPanelImplInitialized(wizardPanelImpl);
        }
    }

    public void setUseSystemLookAndFeel(boolean bl) {
        this.useSystemLookAndFeel = bl;
    }

    public void setWizardColors() {
        int n = 0;
        while (n < this.bkgndColorProps.length) {
            UIManager.getDefaults().put(this.bkgndColorProps[n], PropertyUtils.createColor(this.getBackgroundColor(), SystemColor.control));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.frgndColorProps.length) {
            UIManager.getDefaults().put(this.frgndColorProps[n2], PropertyUtils.createColor(this.getForegroundColor(), SystemColor.controlText));
            ++n2;
        }
    }

    private static void switchToSystemLAF(Object object, WizardServices wizardServices) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            wizardServices.logEvent(object, "wrn", "unable to use system look and feel");
            wizardServices.logEvent(object, "err", exception);
        }
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) {
        UserInputResponse userInputResponse;
        if (this.isInitialized()) {
            Object object;
            this.restoreDefaultColors();
            String[] stringArray = null;
            int n = 0;
            if (userInputRequest.getResponseOptions() != null) {
                stringArray = new String[userInputRequest.getResponseOptions().length];
                int n2 = 0;
                while (n2 < stringArray.length) {
                    object = userInputRequest.getResponseOptions()[n2].toString();
                    if (userInputRequest.getResponseOptions()[n2].equals(userInputRequest.getDefaultResponse())) {
                        n = n2;
                    }
                    stringArray[n2] = object;
                    ++n2;
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "okWithMn")};
            }
            if (userInputRequest.getType() == 5 || userInputRequest.getType() == 7 || userInputRequest.getType() == 6 || userInputRequest.getType() == 8 || userInputRequest.getType() == 9) {
                SwingTextInputDialog swingTextInputDialog;
                if (userInputRequest.getType() == 5) {
                    swingTextInputDialog = new SwingTextInputDialog(this.getFrame(), userInputRequest.getTitle(), userInputRequest.getPrompt(), userInputRequest.getTextValue(), stringArray, n);
                } else if (userInputRequest.getType() == 9) {
                    object = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(32, 32, AWTWizardUI.diskIconArray, 0, 32));
                    swingTextInputDialog = new SwingTextInputDialog(this.getFrame(), userInputRequest.getTitle(), userInputRequest.getPrompt(), 2, userInputRequest.getTextValue(), stringArray, n, (Image)object, "InstallShield");
                } else {
                    int n3;
                    switch (userInputRequest.getType()) {
                        case 8: {
                            n3 = 2;
                            break;
                        }
                        case 6: {
                            n3 = 3;
                            break;
                        }
                        default: {
                            n3 = 1;
                        }
                    }
                    swingTextInputDialog = new SwingTextInputDialog(this.getFrame(), userInputRequest.getTitle(), userInputRequest.getPrompt(), n3, userInputRequest.getTextValue(), stringArray, n, null, null);
                }
                ((Component)swingTextInputDialog).setVisible(true);
                int n4 = swingTextInputDialog.getResult();
                Object object2 = n4 == -1 ? userInputRequest.getDefaultResponse() : (userInputRequest.getResponseOptions() != null ? userInputRequest.getResponseOptions()[n4] : stringArray[n4]);
                userInputResponse = new UserInputResponse(swingTextInputDialog.getTextValue(), object2);
            } else {
                Object object3;
                this.userInputPane = new JOptionPane();
                JOptionPane.setRootFrame(this.getFrame());
                this.userInputPane.setMessage(userInputRequest.getPrompt());
                switch (userInputRequest.getType()) {
                    case 4: {
                        this.userInputPane.setMessageType(0);
                        break;
                    }
                    case 3: {
                        this.userInputPane.setMessageType(2);
                        break;
                    }
                    case 2: {
                        this.userInputPane.setMessageType(3);
                        break;
                    }
                    case 1: {
                        this.userInputPane.setMessageType(1);
                        break;
                    }
                }
                Object[] objectArray = new JButton[stringArray.length];
                object = null;
                int n5 = 0;
                while (n5 < stringArray.length) {
                    object3 = new MnemonicString(stringArray[n5]);
                    objectArray[n5] = new JButton(((MnemonicString)object3).toString());
                    if (((MnemonicString)object3).isMnemonicSpecified()) {
                        ((AbstractButton)objectArray[n5]).setMnemonic(((MnemonicString)object3).getMnemonicChar());
                    }
                    ((AbstractButton)objectArray[n5]).setActionCommand(stringArray[n5]);
                    if (n5 == n) {
                        object = objectArray[n5];
                    }
                    ((AbstractButton)objectArray[n5]).addActionListener(this);
                    ++n5;
                }
                this.userInputPane.setOptions(objectArray);
                object3 = userInputRequest.getTitle();
                this.userInputDialog = this.userInputPane.createDialog(this.getFrame(), (String)object3);
                FontMetrics fontMetrics = this.userInputDialog.getFontMetrics(this.userInputDialog.getFont());
                if (object3 != null) {
                    if (((String)object3).length() > 100) {
                        object3 = ((String)object3).substring(0, 100);
                    }
                    int n6 = fontMetrics.stringWidth((String)object3);
                    if (((String)object3).trim().length() <= 100 && n6 > this.userInputDialog.getWidth()) {
                        ((Component)this.userInputDialog).setSize(n6 + 200, this.userInputDialog.getHeight());
                        this.userInputDialog.validate();
                        this.userInputDialog.repaint();
                    }
                }
                ((JComponent)object).requestFocus();
                ((Component)this.userInputDialog).setVisible(true);
                Object object4 = this.userInputPane.getValue();
                int n7 = -1;
                if (object4 != null) {
                    int n8 = 0;
                    while (n8 < stringArray.length) {
                        if (object4.equals(stringArray[n8])) {
                            n7 = n8;
                        }
                        ++n8;
                    }
                }
                Object object5 = n7 == -1 ? userInputRequest.getDefaultResponse() : (userInputRequest.getResponseOptions() != null ? userInputRequest.getResponseOptions()[n7] : stringArray[n7]);
                userInputResponse = new UserInputResponse(object5);
            }
            this.setWizardColors();
        } else {
            this.waitUntilInitialized();
            userInputResponse = this.userInputRequested(userInputRequest);
        }
        return userInputResponse;
    }

    public class SwingNavigationController
    extends JPanel
    implements AWTWizardUI.NavigationController,
    ActionListener {
        private JButton back;
        private JButton next;
        private JButton cancel;
        private Vector listeners = new Vector();
        private int cancelType = 1;
        private final int captionWidth = 14;
        private final Insets insets = new Insets(0, 4, 4, 0);

        public SwingNavigationController() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(new BorderLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JPanel jPanel = new JPanel(gridBagLayout);
            if (SwingWizardUI.this.isBackgroundImageUsed()) {
                this.setOpaque(false);
                jPanel.setOpaque(false);
            }
            this.add((Component)jPanel, "East");
            MnemonicString mnemonicString = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "backWithMn"));
            this.back = new JButton(ComponentUtils.padButtonCaption(mnemonicString.toString()));
            jPanel.add((Component)this.back, gridBagConstraints);
            this.back.getAccessibleContext().setAccessibleName(mnemonicString.toString().replace('<', ' '));
            if (mnemonicString.isMnemonicSpecified()) {
                this.back.setMnemonic(mnemonicString.getMnemonicChar());
            }
            this.back.addActionListener(this);
            ++gridBagConstraints.gridx;
            MnemonicString mnemonicString2 = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "nextWithMn"));
            this.next = new JButton(ComponentUtils.padButtonCaption(mnemonicString2.toString()));
            jPanel.add((Component)this.next, gridBagConstraints);
            this.next.getAccessibleContext().setAccessibleName(mnemonicString2.toString().replace('>', ' '));
            if (mnemonicString2.isMnemonicSpecified()) {
                this.next.setMnemonic(mnemonicString2.getMnemonicChar());
            }
            this.next.addActionListener(this);
            this.cancel = new JButton();
            gridBagConstraints.insets.left = 10;
            ++gridBagConstraints.gridx;
            jPanel.add((Component)this.cancel, gridBagConstraints);
            this.refreshCancelCaption();
            this.cancel.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.notifyListeners(actionEvent);
        }

        public void addActionListener(ActionListener actionListener) {
            this.listeners.addElement(actionListener);
        }

        public Component back() {
            return this.back;
        }

        public Component cancel() {
            return this.cancel;
        }

        public int getCancelType() {
            return this.cancelType;
        }

        public Component getComponent() {
            return this;
        }

        public Component next() {
            return this.next;
        }

        private void notifyListeners(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }

        void refreshCancelCaption() {
            MnemonicString mnemonicString = this.cancelType == 1 ? new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancelWithMn")) : new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "finishWithMn"));
            this.cancel.setText(ComponentUtils.padButtonCaption(mnemonicString.toString()));
            if (mnemonicString.isMnemonicSpecified()) {
                this.cancel.setMnemonic(mnemonicString.getMnemonicChar());
            } else {
                this.cancel.setMnemonic(0);
            }
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listeners.removeElement(actionListener);
        }

        public void setCancelType(int n) {
            this.cancelType = n;
            this.refreshCancelCaption();
        }
    }

    private class SwingLocaleDialog
    extends JFrame
    implements ActionListener {
        private Locale[] available;
        private JComboBox locales;
        private JButton ok;
        private JButton cancel;
        private boolean parentSet = false;
        private Locale selectedLocale;
        private Wizard wizard = null;

        /* synthetic */ SwingLocaleDialog(1 var2_2, Locale[] localeArray, Locale locale, Wizard wizard) {
            this(localeArray, locale, wizard);
        }

        private SwingLocaleDialog(Locale[] localeArray, Locale locale, Wizard wizard) {
            Object object;
            Serializable serializable;
            this.wizard = wizard;
            this.available = localeArray;
            if (SwingWizardUI.this.getUseSystemLookAndFeel()) {
                SwingWizardUI.switchToSystemLAF(this, wizard.getServices());
            }
            this.enableEvents(64L);
            this.setTitle(wizard != null && wizard.getServices() != null ? wizard.getServices().resolveString(wizard.getTitle()) : "InstallShield Wizard");
            if (SwingWizardUI.this.getWizardIcon() != null && SwingWizardUI.this.getWizardIcon().trim().length() > 0 && wizard != null) {
                try {
                    serializable = wizard.getResource(SwingWizardUI.this.getWizardIcon());
                    object = Toolkit.getDefaultToolkit().getImage((URL)serializable);
                    ((Frame)this).setIconImage((Image)object);
                }
                catch (IOException iOException) {
                    System.out.println("WARNING: cannot load image URL: " + SwingWizardUI.this.getWizardIcon());
                }
            }
            this.getContentPane().setLayout(new BorderLayout());
            serializable = SwingWizardUI.this.createInsetsPanel(10, 10, 10, 10);
            this.getContentPane().add((Component)serializable, "Center");
            ((Container)serializable).setLayout(new ColumnLayout(15));
            object = new JLabel();
            ((Container)serializable).add((Component)object, ColumnConstraints.createHorizontalFill());
            MnemonicString mnemonicString = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.selectLanguage"));
            ((JLabel)object).setText(mnemonicString.toString());
            this.locales = new JComboBox();
            this.locales.setEditable(false);
            ((Container)serializable).add(this.locales, ColumnConstraints.createCenterAlign());
            SortUtils.qsort(localeArray, new LocaleCompare());
            int n = -1;
            int n2 = 0;
            while (n2 < localeArray.length) {
                this.locales.addItem(LocaleUtils.getLocaleDisplayName(localeArray[n2]));
                if (localeArray[n2].equals(locale)) {
                    n = n2;
                }
                ++n2;
            }
            if (this.locales.getItemCount() > 0) {
                this.locales.setSelectedIndex(n);
            }
            if (mnemonicString.isMnemonicSpecified()) {
                ((JLabel)object).setLabelFor(this.locales);
                ((JLabel)object).setDisplayedMnemonic(mnemonicString.getMnemonicChar());
            }
            ((Container)serializable).add(Spacing.createVerticalSpacing(3));
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
            ((Container)serializable).add(jPanel, ColumnConstraints.createCenterAlign());
            MnemonicString mnemonicString2 = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "okWithMn"));
            this.ok = new JButton(mnemonicString2.toString());
            jPanel.add(this.ok);
            this.ok.addActionListener(this);
            if (mnemonicString2.isMnemonicSpecified()) {
                this.ok.setMnemonic(mnemonicString2.getMnemonicChar());
            }
            MnemonicString mnemonicString3 = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancelWithMn"));
            this.cancel = new JButton(mnemonicString3.toString());
            jPanel.add(this.cancel);
            this.cancel.addActionListener(this);
            if (mnemonicString3.isMnemonicSpecified()) {
                this.cancel.setMnemonic(mnemonicString3.getMnemonicChar());
            }
            this.pack();
            this.setResizable(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.selectedLocale = actionEvent.getSource() == this.ok ? (this.locales.getSelectedIndex() != -1 ? this.available[this.locales.getSelectedIndex()] : Locale.getDefault()) : null;
            this.setVisible(false);
        }

        Locale getSelectedLocale() {
            return this.selectedLocale;
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.selectedLocale = null;
                this.setVisible(false);
            } else if (windowEvent.getID() == 200) {
                this.ok.requestFocus();
            }
        }

        public void setVisible(boolean bl) {
            if (bl && !this.isVisible()) {
                Point point;
                Dimension dimension;
                Dimension dimension2 = this.getSize();
                if (this.parentSet) {
                    dimension = this.getParent().getSize();
                    point = this.getParent().getLocation();
                } else {
                    dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    point = new Point(0, 0);
                }
                ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            }
            super.setVisible(bl);
        }
    }
}

