/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.conditions;

import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import java.util.Locale;

public class LocaleWizardBeanCondition
extends WizardBeanCondition {
    private String locale = "";

    public LocaleWizardBeanCondition() {
        this.setImmutable(true);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        if (this.locale.equals("")) {
            wizardBuilderSupport.logEvent(this, "err", "ERROR: cannot evaluate locale \"\"");
        }
    }

    public String defaultName() {
        return "locale";
    }

    public String describe() {
        Locale locale = PropertyUtils.createLocale(this.locale);
        if (locale != null) {
            if (this.getEvaluate() == 1) {
                return LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "LocaleWizardBeanCondition.defaultLocaleMustBe", new String[]{LocaleUtils.getLocaleDisplayName(locale)});
            }
            return LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "LocaleWizardBeanCondition.defaultLocaleMustNotBe", new String[]{LocaleUtils.getLocaleDisplayName(locale)});
        }
        return LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "LocaleWizardBeanCondition.errorEvaluation", new String[]{this.locale});
    }

    protected boolean evaluateTrueCondition() {
        boolean bl = false;
        if (this.locale.equals("")) {
            return bl;
        }
        Locale locale = PropertyUtils.createLocale(this.locale);
        Locale locale2 = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale2.getLanguage();
        if (string == null || string.equals("")) {
            bl = true;
        } else if (string.equals(string2)) {
            String string3 = locale.getCountry();
            String string4 = locale2.getCountry();
            if (string3 == null || string3.equals("")) {
                bl = true;
            } else if (string3.equals(string4)) {
                String string5 = locale.getVariant();
                String string6 = locale2.getVariant();
                if (string5 == null || string5.equals("")) {
                    bl = true;
                } else if (string5.equals(string6)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }
}

