/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizardx.panels.ApprovalPanel;
import com.installshield.wizardx.panels.TextDisplayPanelAWTImpl;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ApprovalPanelAWTImpl
extends TextDisplayPanelAWTImpl
implements ItemListener {
    private int choiceType = -1;
    private Component choiceUI = null;
    private Choice choice = null;
    private Checkbox check = null;
    private Checkbox approve = null;
    private Checkbox disapprove = null;

    private Component createChoiceUI() {
        String string = MnemonicString.stripMn(this.resolveString(this.getAP().getApproveCaption()));
        String string2 = MnemonicString.stripMn(this.resolveString(this.getAP().getDisapproveCaption()));
        InsetsPanel insetsPanel = new InsetsPanel(6, 0, 0, 0);
        insetsPanel.setLayout(this.createFlowLayout());
        if (this.getAP().getUiType() == 1) {
            this.choiceType = 1;
            this.choice = new Choice();
            insetsPanel.add(this.choice);
            this.choice.addItem(string);
            this.choice.addItem(string2);
            this.choice.addItemListener(this);
        } else if (this.getAP().getUiType() == 2) {
            this.choiceType = 2;
            this.check = new Checkbox(string);
            insetsPanel.add(this.check);
            this.check.addItemListener(this);
        } else if (this.getAP().getUiType() == 3) {
            this.choiceType = 3;
            Panel panel = new Panel(new ColumnLayout());
            insetsPanel.add(panel);
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            this.approve = new Checkbox(string, checkboxGroup, false);
            panel.add((Component)this.approve, ColumnConstraints.createLeftAlign());
            this.approve.addItemListener(this);
            this.disapprove = new Checkbox(string2, checkboxGroup, false);
            panel.add((Component)this.disapprove, ColumnConstraints.createLeftAlign());
            this.disapprove.addItemListener(this);
        }
        this.setSelection(this.getAP().getSelection());
        return insetsPanel;
    }

    private FlowLayout createFlowLayout() {
        if (this.getAP().getUiAlignment() == 3) {
            return new FlowLayout(1, 0, 0);
        }
        if (this.getAP().getUiAlignment() == 2) {
            return new FlowLayout(2, 0, 0);
        }
        return new FlowLayout(0, 0, 0);
    }

    protected ApprovalPanel getAP() {
        return (ApprovalPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.choiceUI = this.createChoiceUI();
        this.getContentPane().add(this.choiceUI, "South");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.getAP().setPropertyNotification(false);
        if (itemEvent.getSource() == this.choice) {
            if (this.choice.getSelectedIndex() == 0) {
                this.getAP().setSelection(1);
            } else {
                this.getAP().setSelection(2);
            }
        } else if (itemEvent.getSource() == this.check) {
            if (this.check.getState()) {
                this.getAP().setSelection(1);
            } else {
                this.getAP().setSelection(2);
            }
        } else if (itemEvent.getSource() == this.approve) {
            this.getAP().setSelection(1);
        } else if (itemEvent.getSource() == this.disapprove) {
            this.getAP().setSelection(2);
        }
        this.getAP().setPropertyNotification(true);
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        this.getContentPane().remove(this.choiceUI);
        this.choiceUI = this.createChoiceUI();
        this.getContentPane().add(this.choiceUI, "South");
        this.validate();
        this.repaint();
    }

    private void setSelection(int n) {
        if (this.choiceType == 1) {
            if (n == 1) {
                this.choice.select(0);
            } else {
                this.choice.select(1);
            }
        } else if (this.choiceType == 2) {
            this.check.setState(n == 1);
        } else if (this.choiceType == 3) {
            if (n == 0) {
                this.approve.setCheckboxGroup(null);
                this.disapprove.setCheckboxGroup(null);
            }
            this.approve.setState(n == 1);
            this.disapprove.setState(n == 2);
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            if (n == 0) {
                this.approve.setCheckboxGroup(checkboxGroup);
                this.disapprove.setCheckboxGroup(checkboxGroup);
            }
        }
    }
}

