/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizardx.panels.ChoiceItem;
import com.installshield.wizardx.panels.GenericInputField;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChoiceInputField
extends GenericInputField
implements ItemListener,
PropertyAccessible {
    public static int RADIO_BUTTON = 1;
    public static int CHECK_BOX = 2;
    public static int SINGLE_SELECT_LIST = 3;
    public static int DROP_DOWN = 4;
    public static int SCROLLABLE_LIST = 5;
    private Vector choiceList = new Vector();
    private ChoiceItem[] choices = new ChoiceItem[0];
    private int choiceType = 1;
    private Checkbox[] choiceButtons = null;
    private Checkbox[] checkBoxes = null;
    private List list = null;
    private Choice choiceComp = null;

    public ChoiceInputField() {
        this.setCaption("$L(com.installshield.wizardx.i18n.WizardXResources,UserInputPanel.multiSelectChoiceInputFieldCaption)");
    }

    public void addChoiceItem(ChoiceItem choiceItem) {
        this.choiceList.addElement(choiceItem);
    }

    public void clearChoices() {
        this.choiceList = new Vector();
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        boolean bl = false;
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.caption");
        while (!bl) {
            TTYDisplay.showNewline();
            TTYDisplay.showText(this.wizardServices.resolveString(this.getCaption()));
            Vector vector = this.getTableData();
            TTYDisplay.displayTable(vector);
            TTYDisplay.showNewline();
            int n = TTYDisplay.queryValue(string, 0, 0, vector.size(), "");
            if (n != 0) {
                this.updateSelectedIndex(n - 1);
                if (!TTYDisplay.accessbilityEnabled() || this.isMultiSelect()) continue;
                String string2 = this.getSelectedIndex() >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoice", new String[]{this.choices[this.getSelectedIndex()].getDisplayName()}) : LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoiceEmpty");
                int n2 = TTYDisplay.queryValue(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.confirmChoice"), 0, 0, 1, string2);
                bl = n2 == 0;
                continue;
            }
            bl = true;
        }
    }

    public Component createUI() {
        this.removeAll();
        this.setLayout(new ColumnLayout(5));
        FlowLabel flowLabel = new FlowLabel();
        flowLabel.setText(this.wizardServices.resolveString(this.getCaption()));
        this.add((Component)flowLabel, ColumnConstraints.createLeftAlign());
        ColumnConstraints columnConstraints = new ColumnConstraints(1, 3);
        if (this.choiceType == RADIO_BUTTON) {
            int n = this.getOptionCount();
            this.choiceButtons = new Checkbox[n];
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            int n2 = 0;
            while (n2 < n) {
                ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n2);
                this.choiceButtons[n2] = new Checkbox(this.wizardServices.resolveString(choiceItem.getDisplayName()));
                this.choiceButtons[n2].setCheckboxGroup(checkboxGroup);
                this.choiceButtons[n2].setState(choiceItem.isSelected());
                if (this.runtime) {
                    this.choiceButtons[n2].addItemListener(this);
                    if (choiceItem.isSelected()) {
                        this.setValue(new String[]{choiceItem.getValue()});
                    }
                }
                this.add((Component)this.choiceButtons[n2], columnConstraints);
                ++n2;
            }
        } else if (this.choiceType == SINGLE_SELECT_LIST) {
            Object object;
            this.list = new List();
            int n = 0;
            while (this.choiceList != null && n < this.choiceList.size()) {
                object = (ChoiceItem)this.choiceList.elementAt(n);
                this.list.add(this.wizardServices.resolveString(((ChoiceItem)object).getDisplayName()));
                if (this.runtime) {
                    this.list.addItemListener(this);
                    if (((ChoiceItem)object).isSelected()) {
                        this.setValue(new String[]{((ChoiceItem)object).getValue()});
                    }
                }
                ++n;
            }
            object = new ScrollPane();
            ((Container)object).add(this.list);
            this.add((Component)object, new ColumnConstraints(1, 2));
        } else if (this.choiceType == SCROLLABLE_LIST) {
            ScrollPane scrollPane = new ScrollPane();
            Panel panel = new Panel(new ColumnLayout());
            panel.setBackground(Color.white);
            int n = this.getOptionCount();
            this.checkBoxes = new Checkbox[n];
            int n3 = 0;
            while (n3 < n) {
                ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n3);
                this.checkBoxes[n3] = new Checkbox(this.wizardServices.resolveString(choiceItem.getDisplayName()));
                this.checkBoxes[n3].setState(choiceItem.isSelected());
                if (this.runtime) {
                    this.checkBoxes[n3].addItemListener(this);
                    this.updateMultiSelectValue(choiceItem);
                }
                panel.add((Component)this.checkBoxes[n3], new ColumnConstraints(1, 4));
                ++n3;
            }
            scrollPane.add(panel);
            this.add((Component)scrollPane, new ColumnConstraints(1, 4));
        } else if (this.choiceType == CHECK_BOX) {
            int n = this.getOptionCount();
            this.checkBoxes = new Checkbox[n];
            int n4 = 0;
            while (n4 < n) {
                ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n4);
                this.checkBoxes[n4] = new Checkbox(this.wizardServices.resolveString(choiceItem.getDisplayName()));
                this.checkBoxes[n4].setState(choiceItem.isSelected());
                if (this.runtime) {
                    this.checkBoxes[n4].addItemListener(this);
                    this.updateMultiSelectValue(choiceItem);
                }
                this.add((Component)this.checkBoxes[n4], columnConstraints);
                ++n4;
            }
        } else if (this.choiceType == DROP_DOWN) {
            this.choiceComp = new Choice();
            int n = this.getOptionCount();
            int n5 = 0;
            while (n5 < n) {
                ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n5);
                this.choiceComp.add(this.wizardServices.resolveString(choiceItem.getDisplayName()));
                if (choiceItem.isSelected()) {
                    this.choiceComp.select(n5);
                    this.setValue(new String[]{choiceItem.getValue()});
                }
                ++n5;
            }
            if (this.runtime) {
                this.choiceComp.addItemListener(this);
            }
            this.add((Component)this.choiceComp, ColumnConstraints.createLeftAlign());
        }
        return this;
    }

    public int getButtonIndex(Object object) {
        int n;
        block5: {
            block4: {
                n = -1;
                if (!(object instanceof Checkbox) || this.choiceType != RADIO_BUTTON) break block4;
                int n2 = 0;
                while (n2 < this.choiceButtons.length && n == -1) {
                    if (this.choiceButtons[n2].equals(object)) {
                        n = n2;
                    }
                    ++n2;
                }
                break block5;
            }
            if (!(object instanceof Checkbox) || this.choiceType != CHECK_BOX && this.choiceType != SCROLLABLE_LIST) break block5;
            int n3 = 0;
            while (n3 < this.checkBoxes.length && n == -1) {
                if (this.checkBoxes[n3].equals(object)) {
                    n = n3;
                }
                ++n3;
            }
        }
        return n;
    }

    public ChoiceItem getChoiceItem(int n) {
        ChoiceItem choiceItem = null;
        if (n < this.choiceList.size()) {
            choiceItem = (ChoiceItem)this.choiceList.elementAt(n);
        }
        return choiceItem;
    }

    public Vector getChoiceList() {
        return this.choiceList;
    }

    public int getChoiceType() {
        return this.choiceType;
    }

    public ChoiceItem[] getChoices() {
        this.choices = this.getChoicesFromList();
        return this.choices;
    }

    private ChoiceItem[] getChoicesFromList() {
        ChoiceItem[] choiceItemArray = new ChoiceItem[this.choiceList.size()];
        int n = 0;
        while (n < this.choiceList.size()) {
            choiceItemArray[n] = (ChoiceItem)this.choiceList.elementAt(n);
            ++n;
        }
        return choiceItemArray;
    }

    public String getDescription() {
        return String.valueOf(this.getName()) + " { ChoiceField }";
    }

    public int getOptionCount() {
        int n = 0;
        if (this.choiceList != null) {
            n = this.choiceList.size();
        }
        return n;
    }

    private int getSelectedIndex() {
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < this.choices.length) {
            if (this.choices[n2].isSelected()) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private Vector getTableData() {
        Vector vector = new Vector();
        Vector<String> vector2 = null;
        int n = 0;
        while (n < this.choices.length) {
            vector2 = new Vector<String>();
            boolean bl = this.choices[n].isSelected();
            vector2.addElement(bl ? "[X]" : "[ ]");
            vector2.addElement(String.valueOf(n + 1));
            vector2.addElement("-");
            vector2.addElement(this.wizardServices.resolveString(this.choices[n].getDisplayName()));
            vector.addElement(vector2);
            ++n;
        }
        return vector;
    }

    public String getValueAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        ChoiceItem[] choiceItemArray = this.getChoices();
        int n = 0;
        while (n < choiceItemArray.length) {
            if (choiceItemArray[n].isSelected()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(choiceItemArray[n].getValue());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void initialize() {
        int n = 0;
        while (this.choiceList != null && n < this.choiceList.size()) {
            ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n);
            if (choiceItem.isSelected()) {
                if (this.isMultiSelect()) {
                    this.updateMultiSelectValue(choiceItem);
                } else {
                    this.setValue(new String[]{choiceItem.getValue()});
                }
            }
            ++n;
        }
    }

    public boolean isMultiSelect() {
        return this.choiceType != RADIO_BUTTON && this.choiceType != SINGLE_SELECT_LIST && this.choiceType != DROP_DOWN;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = false;
        if (itemEvent.getStateChange() == 1) {
            bl = true;
        }
        Object object = itemEvent.getSource();
        int n = -1;
        if (this.choiceType == RADIO_BUTTON) {
            this.updateSingleSelectIndex(this.getButtonIndex(object));
        } else if (this.choiceType == CHECK_BOX || this.choiceType == SCROLLABLE_LIST) {
            n = this.getButtonIndex(object);
            if (n != -1) {
                ((ChoiceItem)this.choiceList.elementAt(n)).setSelected(bl);
            }
        } else if (this.choiceType == DROP_DOWN) {
            this.updateSingleSelectIndex(this.choiceComp.getSelectedIndex());
        } else if (this.choiceType == SINGLE_SELECT_LIST) {
            this.updateSingleSelectIndex(this.list.getSelectedIndex());
        }
    }

    private void removeMultiSelectValue(ChoiceItem choiceItem) {
        if (this.getValue() != null && ((String[])this.getValue()).length > 0) {
            int n = -1;
            String[] stringArray = (String[])this.getValue();
            int n2 = 0;
            while (n2 < stringArray.length && n == -1) {
                if (stringArray[n2].equals(choiceItem.getValue())) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1) {
                String[] stringArray2 = new String[stringArray.length - 1];
                if (n == stringArray.length - 1) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length - 1);
                } else {
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                    System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
                }
                this.setValue(stringArray2);
            }
        }
    }

    public void setChoiceList(Vector vector) {
        this.choiceList = vector;
    }

    public void setChoiceType(int n) {
        this.choiceType = n;
    }

    public void setChoices(ChoiceItem[] choiceItemArray) {
        this.choiceList.removeAllElements();
        int n = 0;
        while (n < choiceItemArray.length) {
            this.choiceList.addElement(choiceItemArray[n]);
            ++n;
        }
        this.choices = this.getChoicesFromList();
    }

    private void setMultiSelectValue(ChoiceItem choiceItem) {
        if (this.getValue() != null) {
            String[] stringArray = (String[])this.getValue();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = choiceItem.getValue();
            this.setValue(stringArray2);
        } else {
            String[] stringArray = new String[]{choiceItem.getValue()};
            this.setValue(stringArray);
        }
    }

    public void setValueAsText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toString(), ";");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashtable.put(stringTokenizer.nextToken(), "");
        }
        ChoiceItem[] choiceItemArray = this.getChoices();
        int n = 0;
        while (n < choiceItemArray.length) {
            choiceItemArray[n].setSelected(hashtable.containsKey(choiceItemArray[n].getValue()));
            ++n;
        }
    }

    public void updateData() {
        if (this.choiceType == RADIO_BUTTON || this.choiceType == SINGLE_SELECT_LIST || this.choiceType == DROP_DOWN) {
            int n = this.getOptionCount();
            int n2 = 0;
            while (n2 < n) {
                ChoiceItem choiceItem = (ChoiceItem)this.choiceList.elementAt(n2);
                if (choiceItem.isSelected()) {
                    this.setValue(new String[]{choiceItem.getValue()});
                }
                ++n2;
            }
        } else if (this.choiceType == SCROLLABLE_LIST || this.choiceType == CHECK_BOX) {
            Object object;
            int n = this.getOptionCount();
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            while (n3 < n) {
                object = (ChoiceItem)this.choiceList.elementAt(n3);
                if (((ChoiceItem)object).isSelected()) {
                    vector.addElement(((ChoiceItem)object).getValue());
                }
                ++n3;
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            this.setValue(object);
        }
    }

    private void updateMultiSelectValue(ChoiceItem choiceItem) {
        if (choiceItem.isSelected()) {
            this.setMultiSelectValue(choiceItem);
        } else {
            this.removeMultiSelectValue(choiceItem);
        }
    }

    private void updateSelectedIndex(int n) {
        if (n <= this.choices.length) {
            if (this.isMultiSelect()) {
                this.choices[n].setSelected(!this.choices[n].isSelected());
                this.updateMultiSelectValue(this.choices[n]);
            } else {
                int n2 = 0;
                while (n2 < this.choices.length) {
                    if (n2 == n) {
                        this.choices[n2].setSelected(true);
                    } else {
                        this.choices[n2].setSelected(false);
                    }
                    ++n2;
                }
                this.setValue(new String[]{this.choices[n].getValue()});
            }
        }
    }

    private void updateSingleSelectIndex(int n) {
        if (n != -1 && n <= this.choiceList.size() && !this.isMultiSelect()) {
            int n2 = 0;
            while (n2 < this.choiceList.size()) {
                ((ChoiceItem)this.choiceList.elementAt(n2)).setSelected(n2 == n);
                ++n2;
            }
        }
    }

    private boolean validateSelection(int n) {
        if (!this.isMultiSelect()) {
            return n - 1 <= this.choices.length;
        }
        return false;
    }

    class ScrollablePanel
    extends Panel {
        public ScrollablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            Rectangle rectangle = new Rectangle(this.getSize());
            graphics.setColor(Color.darkGray);
            graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color);
        }
    }
}

