/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.TTYDisplay;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardTreeIterator;
import com.installshield.wizard.awt.AWTWizardUI;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.console.ConsoleWizardBean;
import com.installshield.wizardx.panels.ExtendedWizardPanelAWTImpl;
import com.installshield.wizardx.panels.ExtendedWizardPanelConsoleImpl;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleContainer;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;

public class ExtendedWizardPanel
extends WizardPanel
implements ConsoleWizardBean {
    private TextDisplayComponent caption = null;
    private Wizard wizard = null;
    private boolean consoleInteraction = false;
    private ConsoleContainer consoleContainer = null;
    private boolean initialized = false;
    private ExtendedWizardPanelAWTImpl awtImpl = null;
    private ExtendedWizardPanelConsoleImpl consoleImpl = null;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$ExtendedWizardPanel;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$ExtendedWizardPanel != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanel : (class$com$installshield$wizardx$panels$ExtendedWizardPanel = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanel"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl : (class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanelAWTImpl"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl : (class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanelConsoleImpl"))).getName());
            wizardBuilderSupport.putResourceBundles("com.installshield.wizardx.i18n.WizardXResources", wizardBuilderSupport.getSelectedLocales());
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ui");
            wizardBuilderSupport.putPackage("com.installshield.wizard.awt");
            wizardBuilderSupport.putClass("com.installshield.wizard.console.ConsoleWizardBean");
            wizardBuilderSupport.putPackage("ice.htmlbrowser", true);
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    protected boolean canInteract(ConsoleUIComponent consoleUIComponent) {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void componentConsoleInteraction(Container container) {
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length && !this.getWizard().isFinished()) {
                Component component = componentArray[n];
                if (component instanceof Container && !(component instanceof ConsoleUIComponent)) {
                    this.componentConsoleInteraction((Container)component);
                } else if (component instanceof ConsoleUIComponent) {
                    if (this.canInteract((ConsoleUIComponent)((Object)component))) {
                        if (this.consoleImpl != null && component instanceof AbstractUIComponent) {
                            ((AbstractUIComponent)component).setTTYDisplay(this.consoleImpl.getTTY());
                        }
                        ((ConsoleUIComponent)((Object)component)).consoleInteraction();
                    }
                } else {
                    this.logEvent(this, "wrn", "Component is not of type ConsoleInteraction " + component);
                }
                ++n;
            }
        }
    }

    public void consoleInitialize(WizardBeanEvent wizardBeanEvent) {
        if (this.wizard == null) {
            this.wizard = wizardBeanEvent.getWizard();
        }
        this.consoleInteraction = true;
        this.initialize();
        this.initialized = true;
    }

    public void consoleInteraction(WizardBeanEvent wizardBeanEvent) {
        this.componentConsoleInteraction(this.getContentPane());
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        this.initialize();
        if (this.caption != null) {
            this.caption.createComponentUI();
            Container container = this.getContentPane();
            container.remove(this.caption);
            container.add((Component)this.caption, "North");
        }
    }

    public final Component getComponent() {
        if (!this.isComponentInitialized()) {
            throw new IllegalStateException("AWT interface not initialized");
        }
        return this.awtImpl;
    }

    public Container getContentPane() {
        if (this.isConsoleInteraction()) {
            return this.consoleContainer;
        }
        return this.awtImpl;
    }

    public Container getPane() {
        if (this.isConsoleInteraction()) {
            return new ConsoleContainer();
        }
        return new InsetsPanel();
    }

    public TTYDisplay getTTYDisplay() {
        return this.consoleImpl != null ? this.consoleImpl.getTTY() : null;
    }

    public Class getWizardPanelImpl(String string) {
        if (string.equals("awt")) {
            return class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl : (class$com$installshield$wizardx$panels$ExtendedWizardPanelAWTImpl = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanelAWTImpl"));
        }
        if (string.equals("console")) {
            return class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl : (class$com$installshield$wizardx$panels$ExtendedWizardPanelConsoleImpl = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanelConsoleImpl"));
        }
        return null;
    }

    protected void initialize() {
        this.consoleContainer = new ConsoleContainer();
        String string = this.resolveString(this.getDescription());
        if (string != null && string.length() > 0) {
            this.caption = new TextDisplayComponent(string, true);
            this.getContentPane().add(this.caption);
        }
    }

    public final void initializeComponent(WizardBeanEvent wizardBeanEvent) {
        if (this.awtImpl == null) {
            throw new IllegalStateException("AWT interface not instantiated");
        }
        this.awtImpl.initialize(wizardBeanEvent);
    }

    public boolean isComponentInitialized() {
        return this.awtImpl != null && this.awtImpl.isInitialized();
    }

    public boolean isConsoleInteraction() {
        return this.consoleInteraction;
    }

    public boolean isInitializedForConsole() {
        return this.initialized;
    }

    private boolean isLastIterativeBean() {
        WizardBean wizardBean;
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        return wizardTreeIterator.getNext(wizardBean = this.wizard.getCurrentBean()) == wizardTreeIterator.end();
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        if (wizardBeanEvent.getUserInterface() instanceof AWTWizardUI && this.caption != null) {
            this.caption.setText(this.resolveString(this.getDescription()));
        }
        return true;
    }

    public void resetComponentInitialized() {
        if (!this.isComponentInitialized()) {
            throw new Error("could not reset component -- AWT interface not initialized");
        }
        this.awtImpl.setInitialized(false);
    }

    void setAWTImpl(ExtendedWizardPanelAWTImpl extendedWizardPanelAWTImpl) {
        this.awtImpl = extendedWizardPanelAWTImpl;
    }

    void setConsoleImpl(ExtendedWizardPanelConsoleImpl extendedWizardPanelConsoleImpl) {
        this.consoleImpl = extendedWizardPanelConsoleImpl;
    }
}

