/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizardx.panels.GenericUserInputPanel;
import com.installshield.wizardx.panels.InputFieldValidator;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import java.awt.Component;
import java.awt.Panel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class GenericInputField
extends Panel
implements PropertyAccessible,
ConsoleUIComponent {
    protected String name = "";
    protected String caption = "";
    protected String validator = "";
    protected Object value = null;
    private String optionsFileDocumentation = "";
    protected WizardServices wizardServices = null;
    protected boolean runtime = false;
    protected GenericUserInputPanel gPanel = null;
    private static TTYDisplay ttyDisplay = null;
    private String defaultValue = "";
    static /* synthetic */ Class class$com$installshield$wizardx$panels$InputFieldValidator;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        if (this.isValidatorValid()) {
            try {
                if (this.validator.length() > 0) {
                    wizardBuilderSupport.putClass(this.validator);
                }
            }
            catch (IOException iOException) {
                wizardBuilderSupport.logEvent(this, "err", iOException.getMessage());
            }
        } else {
            wizardBuilderSupport.logEvent(this, "err", "Invalid validator class specified in " + this.getName() + " input field. " + "User input field validator class must implement " + (class$com$installshield$wizardx$panels$InputFieldValidator != null ? class$com$installshield$wizardx$panels$InputFieldValidator : (class$com$installshield$wizardx$panels$InputFieldValidator = GenericInputField.class$("com.installshield.wizardx.panels.InputFieldValidator"))).getName() + " interface");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract void consoleInteraction();

    protected abstract Component createUI();

    public String getCaption() {
        return this.caption;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getOptionsFileDocumentation() {
        return this.optionsFileDocumentation;
    }

    public TTYDisplay getTTYDisplay() {
        return ttyDisplay;
    }

    public String getValidator() {
        return this.validator;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsText() {
        if (this.value instanceof String[]) {
            if (((String[])this.value).length > 0) {
                return ((String[])this.value)[0];
            }
            return "";
        }
        return this.value != null ? this.value.toString() : this.getDefaultValue();
    }

    public void initialize() {
    }

    public static void initializeConsoleStream() {
        if (ttyDisplay == null) {
            ttyDisplay = new TTYDisplay();
        }
        TTYDisplay.initialize();
    }

    public static void initializeConsoleStream(InputStream inputStream, OutputStream outputStream) {
        if (ttyDisplay == null) {
            ttyDisplay = new TTYDisplay();
        }
        TTYDisplay.initialize(inputStream, outputStream, 60);
    }

    private boolean isValidatorValid() {
        boolean bl;
        block3: {
            bl = true;
            if (this.validator == null || this.validator.length() <= 0) break block3;
            try {
                Class<?> clazz = Class.forName(this.validator);
                Object obj = clazz.newInstance();
                if (!(obj instanceof InputFieldValidator)) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setFocus() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOptionsFileDocumentation(String string) {
        this.optionsFileDocumentation = string;
    }

    public void setRuntime(boolean bl) {
        this.runtime = bl;
    }

    public void setUserInputPanel(GenericUserInputPanel genericUserInputPanel) {
        this.gPanel = genericUserInputPanel;
    }

    public void setValidator(String string) {
        this.validator = string;
    }

    public void setValue(Object object) {
        this.value = object;
        if (this.gPanel != null) {
            this.gPanel.setFieldExtendedProperty(this.name, this.getValueAsText());
        }
    }

    public void setValueAsText(String string) {
        this.setValue(new String[]{string});
    }

    public void setWizardServices(WizardServices wizardServices) {
        this.wizardServices = wizardServices;
    }

    public void updateData() {
    }

    public boolean validateInputField() {
        if (this.validator != null && this.validator.length() > 0) {
            try {
                Class<?> clazz = Class.forName(this.validator);
                Object obj = clazz.newInstance();
                if (obj instanceof InputFieldValidator) {
                    return ((InputFieldValidator)obj).validate(this.value, this.name, this.gPanel);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

