/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MD5;
import com.installshield.util.MnemonicString;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import java.io.IOException;

public class PasswordPanel
extends WizardPanel
implements BuildListener {
    public static String PASSWORD = "Password";
    private String caption = "";
    private String password = "";
    private String passwordHash = "";
    private String invalidPasswordMessage = "$L(com.installshield.wizardx.i18n.WizardXResources, PasswordPanel.invalidPassword)";
    private String typedPasswordHash = null;
    private boolean building = false;
    private boolean isValidated = false;

    public PasswordPanel() {
        this.setDescription("$L(com.installshield.wizardx.i18n.WizardXResources, PasswordPanel.description)");
        this.setCaption("$L(com.installshield.wizardx.i18n.WizardXResources, PasswordPanel.label)");
        this.setTitle("$L(com.installshield.wizardx.i18n.WizardXResources, PasswordPanel.title)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.wizardx.i18n.WizardXResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
        wizardBuilderSupport.addBuildListener(this);
        this.building = true;
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.building = false;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    private static String createHash(String string) {
        MD5 mD5 = new MD5();
        mD5.write(string.getBytes());
        byte[] byArray = mD5.toHash();
        byte[] byArray2 = new byte[]{byArray[3], byArray[5], byArray[11], byArray[13]};
        return MD5.toHex(byArray2);
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        if (this.typedPasswordHash == null || !this.isPasswordValid()) {
            this.logEvent(this, "err", this.getWizard().getServices().resolveString(this.invalidPasswordMessage));
            this.getWizard().exit(1006);
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public String getInvalidPasswordMessage() {
        return this.invalidPasswordMessage;
    }

    public String getPassword() {
        return !this.building ? this.password : null;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    protected String getTypedPasswordHash() {
        return this.typedPasswordHash;
    }

    private boolean isPasswordValid() {
        if (!this.passwordHash.equals(PasswordPanel.createHash(""))) {
            return this.typedPasswordHash != null && this.typedPasswordHash.equals(PasswordPanel.createHash(this.passwordHash));
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("-hash") && stringArray.length == 1) {
            String string = MnemonicString.stripMn(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "PasswordPanel.label"));
            TTYDisplay tTYDisplay = new TTYDisplay();
            String string2 = tTYDisplay.prompt(string);
            System.out.println("");
            System.out.println(PasswordPanel.createHash(PasswordPanel.createHash(string2)));
            System.exit(0);
        }
        System.err.println("Usage: -hash");
        System.exit(-1);
    }

    protected final boolean passwordValidated() {
        return this.isValidated;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        return !this.isValidated && (this.typedPasswordHash == null || !this.isPasswordValid());
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        if (!this.isPasswordValid()) {
            wizardBeanEvent.getUserInterface().displayUserMessage(this.getWizard().getServices().resolveString(this.getTitle()), this.getWizard().getServices().resolveString(this.invalidPasswordMessage), 1);
            this.propertyChanged("passwordReset");
            return false;
        }
        this.isValidated = true;
        return true;
    }

    public void setCaption(String string) {
        this.caption = string;
        this.propertyChanged("caption");
    }

    public void setInvalidPasswordMessage(String string) {
        this.invalidPasswordMessage = string;
    }

    public void setPassword(String string) {
        this.password = string;
        this.passwordHash = PasswordPanel.createHash(string);
        this.isValidated = false;
    }

    public void setPasswordHash(String string) {
        this.passwordHash = string;
    }

    protected void setTypedPassword(String string) {
        this.setTypedPasswordHash(PasswordPanel.createHash(PasswordPanel.createHash(string)));
    }

    protected void setTypedPasswordHash(String string) {
        this.typedPasswordHash = string;
    }

    public void writeFinished(BuildEvent buildEvent) {
    }

    public void writeStarting(BuildEvent buildEvent) {
    }
}

