/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import com.installshield.wizardx.panels.PasswordPanel;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class PasswordPanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements DocumentListener {
    private JLabel caption = null;
    private JPasswordField password = null;

    public void changedUpdate(DocumentEvent documentEvent) {
        this.getPP().setTypedPassword(new String(this.password.getPassword()));
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        super.entering(wizardBeanEvent);
        this.password.requestFocus();
    }

    private PasswordPanel getPP() {
        return (PasswordPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getContentPane().setLayout(new ColumnLayout());
        MnemonicString mnemonicString = new MnemonicString(this.resolveString(this.getPP().getCaption()));
        this.caption = new JLabel(mnemonicString.toString());
        this.getContentPane().add((Component)this.caption, ColumnConstraints.createLeftAlign());
        this.getContentPane().add(Spacing.createVerticalSpacing(4));
        this.password = new JPasswordField(25);
        this.getContentPane().add((Component)this.password, ColumnConstraints.createLeftAlign());
        if (mnemonicString.isMnemonicSpecified()) {
            this.caption.setDisplayedMnemonic(mnemonicString.getMnemonicChar());
            this.caption.setLabelFor(this.password);
        }
        this.password.setEchoChar('*');
        this.password.getDocument().addDocumentListener(this);
        this.password.getAccessibleContext().setAccessibleName(this.resolveString(this.getPP().getDescription()));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.getPP().setTypedPassword(new String(this.password.getPassword()));
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        if (string.equals("caption")) {
            this.caption.setText(this.resolveString(this.getPP().getCaption()));
            this.caption.getParent().doLayout();
            this.caption.invalidate();
        } else if (string.equals("passwordReset")) {
            ((JTextComponent)this.password).setText("");
            this.password.requestFocus();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.getPP().setTypedPassword(new String(this.password.getPassword()));
    }
}

