/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizardx.panels.GenericInputField;
import java.awt.Component;
import java.awt.TextField;

public class TextInputField
extends GenericInputField
implements PropertyAccessible {
    private TextField textField = null;
    private String consoleText = new String();
    private transient String originalText = null;

    public TextInputField() {
        this.setCaption("$L(com.installshield.wizardx.i18n.WizardXResources, UserInputPanel.textInputFieldCaption)");
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        TTYDisplay.showNewline();
        if (this.originalText == null || this.originalText.equalsIgnoreCase(this.consoleText)) {
            this.consoleText = this.originalText = this.wizardServices.resolveString(this.getDefaultValue());
        }
        this.consoleText = TTYDisplay.queryValue(this.wizardServices.resolveString(this.getCaption()), this.consoleText, "");
        this.setValueAsText(this.consoleText);
    }

    protected Component createUI() {
        this.removeAll();
        this.setLayout(new ColumnLayout(5));
        FlowLabel flowLabel = new FlowLabel();
        flowLabel.setText(this.wizardServices.resolveString(this.getCaption()));
        this.add((Component)flowLabel, new ColumnConstraints(1, 2));
        this.textField = new TextField();
        this.originalText = this.wizardServices.resolveString(this.getDefaultValue());
        this.textField.setText(this.wizardServices.resolveString(this.originalText));
        this.add((Component)this.textField, new ColumnConstraints(1, 2));
        return this;
    }

    public String getDescription() {
        return String.valueOf(this.getName()) + " { TextField }";
    }

    public void initialize() {
        if (this.textField != null && this.originalText != null && this.textField.getText().equalsIgnoreCase(this.originalText)) {
            this.originalText = this.wizardServices.resolveString(this.getDefaultValue());
            this.textField.setText(this.originalText);
        }
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.requestFocus();
        }
    }

    public void setValueAsText(String string) {
        this.setValue(new String[]{string});
    }

    public void updateData() {
        if (this.textField != null) {
            this.setValueAsText(this.textField.getText());
        }
    }
}

