/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.awt.AWTText;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.DefaultAWTWizardPanelImpl;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputFieldChoice;
import com.installshield.wizardx.panels.UserInputPanel;
import com.installshield.wizardx.panels.UserInputPanelConstraints;
import com.installshield.wizardx.panels.UserInputPanelLayout;
import com.installshield.wizardx.ui.DirectoryBrowser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UserInputPanelAWTImpl
extends DefaultAWTWizardPanelImpl
implements TextListener,
ActionListener,
ItemListener {
    public static final int DEFAULT_CAPTION_SPACING = 0;
    public static final int DEFAULT_BROWSE_BUTTON_SPACING = 6;
    public static final int DEFAULT_LIST_ITEM_SPACING = 0;
    private ScrollPane scroll = null;
    private Container view = null;
    private Hashtable fieldsPerComponent = new Hashtable();
    private Hashtable componentsPerField = new Hashtable();
    static /* synthetic */ Class class$com$installshield$wizardx$panels$UserInputPanelLayout;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$UserInputPanelConstraints;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator;

    public void actionPerformed(ActionEvent actionEvent) {
        UserInputField userInputField = this.getFieldForComponent((Component)actionEvent.getSource());
        if (userInputField != null) {
            DirectoryBrowser directoryBrowser = new DirectoryBrowser(this.getParentFrame(), "", null, this.getUIP().getFileService(), "");
            try {
                directoryBrowser.setInitialDirectory(this.resolveString(userInputField.getValue()));
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
            directoryBrowser.setSelectionType(actionEvent.getActionCommand().equals("file") ? 2 : 1);
            directoryBrowser.run();
            if (directoryBrowser.dirName() != null) {
                userInputField.setValue(directoryBrowser.dirName());
                if (this.getComponentForField(userInputField) instanceof TextComponent) {
                    TextComponent textComponent = (TextComponent)this.getComponentForField(userInputField);
                    textComponent.setText(directoryBrowser.dirName());
                    textComponent.requestFocus();
                    textComponent.selectAll();
                }
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$UserInputPanelLayout != null ? class$com$installshield$wizardx$panels$UserInputPanelLayout : (class$com$installshield$wizardx$panels$UserInputPanelLayout = UserInputPanelAWTImpl.class$("com.installshield.wizardx.panels.UserInputPanelLayout"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$UserInputPanelConstraints != null ? class$com$installshield$wizardx$panels$UserInputPanelConstraints : (class$com$installshield$wizardx$panels$UserInputPanelConstraints = UserInputPanelAWTImpl.class$("com.installshield.wizardx.panels.UserInputPanelConstraints"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser != null ? class$com$installshield$wizardx$ui$DirectoryBrowser : (class$com$installshield$wizardx$ui$DirectoryBrowser = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser"))).getName());
            wizardBuilderSupport.putClass("com.installshield.wizardx.ui.DirectoryBrowser$1");
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconBase11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconListBox11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay : (class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$DirTextDisplay"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure : (class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$FileStructure"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator : (class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator = UserInputPanelAWTImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$Comparator"))).getName());
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected FlowLabel createCaption(String string, Component component) {
        return new FlowLabel(MnemonicString.stripMn(string));
    }

    protected Component createCheckList(UserInputField userInputField) {
        Panel panel = new Panel(new ColumnLayout(this.getListItemSpacing()));
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            Checkbox checkbox = new Checkbox(MnemonicString.stripMn(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())));
            panel.add((Component)checkbox, ColumnConstraints.createLeftAlign());
            checkbox.setState(userInputField.isChoiceSelected(n));
            checkbox.addItemListener(this);
            ++n;
        }
        this.setFieldPerComponent(userInputField, panel);
        this.setComponentPerField(panel, userInputField);
        return panel;
    }

    protected Component createDirectory(UserInputField userInputField) {
        Panel panel = new Panel(new ColumnLayout(this.getBrowseButtonSpacing()));
        TextField textField = new TextField(this.resolveString(userInputField.getValue()));
        panel.add((Component)textField, ColumnConstraints.createHorizontalFill());
        textField.addTextListener(this);
        Button button = new Button("  " + MnemonicString.stripMn(this.resolveString(userInputField.getBrowseLabel())) + "  ");
        panel.add((Component)button, ColumnConstraints.createRightAlign());
        button.addActionListener(this);
        button.setActionCommand("directory");
        this.setFieldPerComponent(userInputField, button);
        this.setFieldPerComponent(userInputField, textField);
        this.setComponentPerField(textField, userInputField);
        return panel;
    }

    protected Component createDropDown(UserInputField userInputField) {
        Choice choice = new Choice();
        choice.addItemListener(this);
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            choice.add(MnemonicString.stripMn(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())));
            if (userInputField.isChoiceSelected(n)) {
                choice.select(n);
            }
            ++n;
        }
        this.setFieldPerComponent(userInputField, choice);
        this.setComponentPerField(choice, userInputField);
        return choice;
    }

    protected Component createFieldUI(UserInputField userInputField) {
        switch (userInputField.getType()) {
            case 1: {
                return this.createLabel(userInputField);
            }
            case 2: {
                return this.createText(userInputField);
            }
            case 3: {
                return this.createPassword(userInputField);
            }
            case 4: {
                return this.createFile(userInputField);
            }
            case 5: {
                return this.createDirectory(userInputField);
            }
            case 6: {
                return this.createRadioList(userInputField);
            }
            case 7: {
                return this.createCheckList(userInputField);
            }
            case 8: {
                return this.createScrollableCheckList(userInputField);
            }
            case 9: {
                return this.createList(userInputField);
            }
            case 10: {
                return this.createDropDown(userInputField);
            }
        }
        return null;
    }

    protected Component createFile(UserInputField userInputField) {
        Panel panel = new Panel(new ColumnLayout(this.getBrowseButtonSpacing()));
        TextField textField = new TextField(this.resolveString(userInputField.getValue()));
        panel.add((Component)textField, ColumnConstraints.createHorizontalFill());
        textField.addTextListener(this);
        Button button = new Button("  " + MnemonicString.stripMn(this.resolveString(userInputField.getBrowseLabel())) + "  ");
        panel.add((Component)button, ColumnConstraints.createRightAlign());
        button.addActionListener(this);
        button.setActionCommand("file");
        this.setFieldPerComponent(userInputField, button);
        this.setFieldPerComponent(userInputField, textField);
        this.setComponentPerField(textField, userInputField);
        return panel;
    }

    protected Component createLabel(UserInputField userInputField) {
        InsetsPanel insetsPanel = new InsetsPanel(3, 0, 3, 0);
        insetsPanel.setLayout(new BorderLayout());
        insetsPanel.add((Component)new AWTText(this.resolveString(userInputField.getValue())), "Center");
        return insetsPanel;
    }

    protected Component createList(UserInputField userInputField) {
        List list = new List();
        list.setMultipleMode(false);
        list.addItemListener(this);
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            list.add(MnemonicString.stripMn(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())));
            if (userInputField.isChoiceSelected(n)) {
                list.select(n);
            }
            ++n;
        }
        this.setFieldPerComponent(userInputField, list);
        this.setComponentPerField(list, userInputField);
        return list;
    }

    protected Component createPassword(UserInputField userInputField) {
        TextField textField = new TextField(this.resolveString(userInputField.getValue()));
        textField.addTextListener(this);
        textField.setEchoChar('*');
        this.setFieldPerComponent(userInputField, textField);
        this.setComponentPerField(textField, userInputField);
        return textField;
    }

    protected Component createRadioList(UserInputField userInputField) {
        Panel panel = new Panel(new ColumnLayout(this.getListItemSpacing()));
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            Checkbox checkbox = new Checkbox(MnemonicString.stripMn(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())));
            panel.add((Component)checkbox, ColumnConstraints.createLeftAlign());
            checkbox.setCheckboxGroup(checkboxGroup);
            checkbox.setState(userInputField.isChoiceSelected(n));
            checkbox.addItemListener(this);
            ++n;
        }
        this.setFieldPerComponent(userInputField, panel);
        this.setComponentPerField(panel, userInputField);
        return panel;
    }

    protected Component createScrollableCheckList(UserInputField userInputField) {
        ScrollPane scrollPane = new ScrollPane();
        InsetsPanel insetsPanel = new InsetsPanel(6, 6, 6, 6);
        scrollPane.add(insetsPanel);
        insetsPanel.setLayout(new BorderLayout());
        insetsPanel.setBackground(new List().getBackground());
        Component component = this.createCheckList(userInputField);
        insetsPanel.add(component, "Center");
        component.setBackground(insetsPanel.getBackground());
        this.setFieldPerComponent(userInputField, component);
        this.setComponentPerField(component, userInputField);
        return scrollPane;
    }

    protected Component createText(UserInputField userInputField) {
        TextField textField = new TextField(this.resolveString(userInputField.getValue()));
        textField.addTextListener(this);
        this.setFieldPerComponent(userInputField, textField);
        this.setComponentPerField(textField, userInputField);
        return textField;
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        super.entering(wizardBeanEvent);
        this.view.removeAll();
        this.unregisterFocusListener(this, this.view);
        this.view.setLayout(new UserInputPanelLayout());
        this.fieldsPerComponent.clear();
        this.componentsPerField.clear();
        this.scroll.getHAdjustable().setValue(0);
        this.scroll.getVAdjustable().setValue(0);
        UserInputField[] userInputFieldArray = this.getUIP().getFields();
        int n = 0;
        int n2 = 0;
        while (n2 < userInputFieldArray.length) {
            Component component = this.createFieldUI(userInputFieldArray[n2]);
            if (component != null) {
                Insets insets = this.parseInsets(userInputFieldArray[n2].getInsets());
                String string = this.resolveString(userInputFieldArray[n2].getCaption());
                if (string.length() > 0) {
                    FlowLabel flowLabel = this.createCaption(string, component);
                    if (userInputFieldArray[n2].getCaptionLocation() == 1) {
                        this.view.add((Component)flowLabel, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, 0, insets.right), 1));
                        this.view.add(component, new UserInputPanelConstraints(new Insets(this.getCaptionSpacing(), insets.left, insets.bottom, insets.right), 2));
                    } else {
                        this.view.add((Component)flowLabel, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, 0, this.getCaptionSpacing()), 4));
                        this.view.add(component, new UserInputPanelConstraints(new Insets(insets.top + n, 0, insets.bottom, insets.right), 3));
                    }
                } else {
                    this.view.add(component, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, insets.bottom, insets.right), 2));
                }
                n = this.getUIP().getFieldSpacing();
            }
            ++n2;
        }
        this.registerFocusListener(this, this.view);
        this.validate();
    }

    protected int getBrowseButtonSpacing() {
        return 6;
    }

    protected int getCaptionSpacing() {
        return 0;
    }

    protected Component getComponentForField(UserInputField userInputField) {
        return (Component)this.componentsPerField.get(userInputField);
    }

    protected UserInputField getFieldForComponent(Component component) {
        return (UserInputField)this.fieldsPerComponent.get(component);
    }

    protected int getListItemSpacing() {
        return 0;
    }

    protected Frame getParentFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    private UserInputPanel getUIP() {
        return (UserInputPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll = new ScrollPane();
        this.getContentPane().add((Component)this.scroll, "Center");
        Panel panel = new Panel(new BorderLayout());
        this.scroll.add(panel);
        this.scroll.getVAdjustable().setUnitIncrement(15);
        this.view = new InsetsPanel(6, 6, 6, 6);
        panel.add((Component)this.view, "North");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block8: {
            Container container;
            UserInputField userInputField;
            block9: {
                block7: {
                    if (!(itemEvent.getSource() instanceof List)) break block7;
                    List list = (List)itemEvent.getSource();
                    UserInputField userInputField2 = this.getFieldForComponent(list);
                    if (userInputField2 == null) break block8;
                    UserInputFieldChoice[] userInputFieldChoiceArray = userInputField2.getChoices();
                    int n = 0;
                    while (n < list.getItemCount()) {
                        if (n < userInputFieldChoiceArray.length) {
                            userInputField2.setChoiceSelected(n, list.isIndexSelected(n));
                        }
                        ++n;
                    }
                    break block8;
                }
                if (!(itemEvent.getSource() instanceof Choice)) break block9;
                Choice choice = (Choice)itemEvent.getSource();
                UserInputField userInputField3 = this.getFieldForComponent(choice);
                if (userInputField3 == null) break block8;
                UserInputFieldChoice[] userInputFieldChoiceArray = userInputField3.getChoices();
                int n = 0;
                while (n < choice.getItemCount()) {
                    if (n < userInputFieldChoiceArray.length) {
                        userInputField3.setChoiceSelected(n, choice.getSelectedIndex() == n);
                    }
                    ++n;
                }
                break block8;
            }
            if (itemEvent.getSource() instanceof Component && (userInputField = this.getFieldForComponent(container = ((Component)itemEvent.getSource()).getParent())) != null) {
                UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
                int n = 0;
                while (n < container.getComponentCount()) {
                    if (container.getComponent(n) instanceof Checkbox && n < userInputFieldChoiceArray.length) {
                        userInputField.setChoiceSelected(n, ((Checkbox)container.getComponent(n)).getState());
                    }
                    ++n;
                }
            }
        }
    }

    private Insets parseInsets(String string) {
        Insets insets;
        block11: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            insets = new Insets(0, 0, 0, 0);
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.top = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.left = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.bottom = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!stringTokenizer.hasMoreTokens()) break block11;
            try {
                insets.right = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return insets;
    }

    public void selectField(UserInputField userInputField) {
        Component component = this.getComponentForField(userInputField);
        component.requestFocus();
        if (component instanceof TextField) {
            ((TextField)component).selectAll();
        }
        while (component != null && component.getParent() != this.view) {
            component = component.getParent();
        }
        if (component != null) {
            this.scroll.setScrollPosition(component.getLocation());
        }
    }

    protected void setComponentPerField(Component component, UserInputField userInputField) {
        this.componentsPerField.put(userInputField, component);
    }

    protected void setFieldPerComponent(UserInputField userInputField, Component component) {
        this.fieldsPerComponent.put(component, userInputField);
    }

    public void textValueChanged(TextEvent textEvent) {
        UserInputField userInputField;
        if (textEvent.getSource() instanceof TextComponent && (userInputField = this.getFieldForComponent((Component)textEvent.getSource())) != null) {
            userInputField.setValue(((TextComponent)textEvent.getSource()).getText());
        }
    }
}

