/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class ChoiceComponent
extends AbstractUIComponent
implements ConsoleUIComponent,
ItemListener {
    public static final int DROP_DOWN_TYPE = 1;
    public static final int CHECKBOX_TYPE = 2;
    public static final int RADIO_BUTTON_TYPE = 3;
    public static final int LIST_TYPE = 4;
    private boolean isMultipleSelection = false;
    private int componentType = 1;
    private String[] options;
    private int[] selectedIndexes = new int[0];
    private CheckboxGroup group = null;
    private Choice choiceComponent = new Choice();
    private Checkbox[] checkboxComponent;
    private List listComponent = new List();
    private Panel pane0;
    private boolean initialized = false;
    private Vector selectedIndexList = new Vector();
    private boolean canContinue = true;
    private int[] requiredIndices = new int[0];
    private boolean isConsole = false;
    private Vector listeners = new Vector();
    private int componentCount = 0;
    private String consoleCaption = null;

    public ChoiceComponent() {
        this(new String[0]);
    }

    public ChoiceComponent(String[] stringArray) {
        this(stringArray, false);
    }

    public ChoiceComponent(String[] stringArray, boolean bl) {
        this(stringArray, bl, 1);
    }

    public ChoiceComponent(String[] stringArray, boolean bl, int n) {
        this(stringArray, bl, n, new int[0]);
    }

    public ChoiceComponent(String[] stringArray, boolean bl, int n, int[] nArray) {
        this.options = stringArray;
        this.isMultipleSelection = bl;
        this.componentType = n;
        this.selectedIndexes = nArray;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!this.selectedIndexList.contains(new Integer(nArray[n2]))) {
                this.selectedIndexList.addElement(new Integer(nArray[n2]));
            }
            ++n2;
        }
    }

    public void addChoiceComponentListener(ChoiceComponentListener choiceComponentListener) {
        this.listeners.addElement(choiceComponentListener);
    }

    public boolean canContinue() {
        return this.canContinue;
    }

    private void clearComponentStates() {
        switch (this.getComponentType()) {
            case 2: 
            case 3: {
                int n = 0;
                while (n < this.checkboxComponent.length) {
                    this.checkboxComponent[n].setState(false);
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.listComponent.getItemCount()) {
                    this.listComponent.deselect(n);
                    ++n;
                }
                break;
            }
        }
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        boolean bl = false;
        this.isConsole = true;
        this.refreshSelectedIndexList();
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.caption");
        while (!bl) {
            TTYDisplay.showNewline();
            if (this.consoleCaption != null) {
                TTYDisplay.showText(this.consoleCaption);
            }
            TTYDisplay.showText("");
            Vector vector = this.getTableData();
            TTYDisplay.displayTable(vector);
            TTYDisplay.showNewline();
            int n = TTYDisplay.queryValue(string, 0, 0, vector.size(), "");
            if (n == 0) {
                bl = this.canContinue;
                continue;
            }
            if (this.isRequiredIndex(n - 1)) {
                TTYDisplay.showNewline();
                TTYDisplay.showText(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.couldNotUnselect"));
                continue;
            }
            this.updateSelectedIndex(n - 1);
            if (!this.isMultipleSelection() && TTYDisplay.accessbilityEnabled()) {
                String string2 = this.getSelectedIndex() >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoice", new String[]{this.options[this.getSelectedIndex()]}) : LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoiceEmpty");
                int n2 = TTYDisplay.queryValue(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.confirmChoice"), 0, 0, 1, string2);
                bl = n2 == 0;
                continue;
            }
            bl = false;
        }
    }

    public void createComponentUI() {
        this.setLayout(new BorderLayout());
        this.pane0 = new Panel();
        this.add((Component)this.pane0, "North");
        this.initialized = true;
        this.initializeComponents();
        this.refreshComponentsState(this.selectedIndexes);
    }

    public Component getCheckboxComponentAt(int n) {
        if (this.checkboxComponent != null && n >= 0 && n < this.checkboxComponent.length) {
            return this.checkboxComponent[n];
        }
        return null;
    }

    public int getCheckboxComponentCount() {
        if (this.checkboxComponent != null) {
            return this.checkboxComponent.length;
        }
        return 0;
    }

    public Component getComponent(int n) {
        switch (this.getComponentType()) {
            case 2: 
            case 3: {
                if (n >= this.checkboxComponent.length) break;
                return this.checkboxComponent[n];
            }
            case 4: {
                return this.listComponent;
            }
            case 1: {
                return this.choiceComponent;
            }
        }
        return null;
    }

    public Component getComponent(String string) {
        switch (this.getComponentType()) {
            case 2: 
            case 3: {
                int n = 0;
                while (n < this.checkboxComponent.length) {
                    Checkbox checkbox = this.checkboxComponent[n];
                    if (checkbox.getLabel().equals(string)) {
                        return checkbox;
                    }
                    ++n;
                }
            }
            case 4: {
                return this.listComponent;
            }
            case 1: {
                return this.choiceComponent;
            }
        }
        return null;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public String getConsoleCaption() {
        return this.consoleCaption;
    }

    private int getItemIndex(String string) {
        int n = 0;
        while (n < this.options.length) {
            if (string.equals(this.options[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int[] getRequiredIndexes() {
        return this.requiredIndices;
    }

    public int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length > 0) {
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        if (this.initialized && !this.isConsole) {
            this.selectedIndexes = this.getUISelectedIndexes();
        }
        return this.selectedIndexes;
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (this.options.length > 0 && n != -1) {
            return this.options[n];
        }
        return null;
    }

    public String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.options[nArray[n]];
            ++n;
        }
        return stringArray;
    }

    private Vector getTableData() {
        Vector vector = new Vector();
        Vector<String> vector2 = null;
        int n = 0;
        while (n < this.options.length) {
            vector2 = new Vector<String>();
            boolean bl = this.isSelectedIndex(n);
            vector2.addElement(bl ? "[X]" : "[ ]");
            vector2.addElement(String.valueOf(n + 1));
            vector2.addElement("-");
            vector2.addElement(this.options[n]);
            vector.addElement(vector2);
            ++n;
        }
        return vector;
    }

    public int[] getUISelectedIndexes() {
        switch (this.getComponentType()) {
            case 2: 
            case 3: {
                int n = this.checkboxComponent.length;
                Vector<Integer> vector = new Vector<Integer>();
                int n2 = 0;
                while (n2 < n) {
                    if (this.checkboxComponent[n2].getState()) {
                        vector.addElement(new Integer(n2));
                        if (!this.isMultipleSelection()) break;
                    }
                    ++n2;
                }
                int[] nArray = new int[vector.size()];
                int n3 = 0;
                while (n3 < vector.size()) {
                    nArray[n3] = (Integer)vector.elementAt(n3);
                    ++n3;
                }
                return nArray;
            }
            case 4: {
                if (this.isMultipleSelection()) {
                    return this.listComponent.getSelectedIndexes();
                }
                int[] nArray = new int[]{this.listComponent.getSelectedIndex()};
                return nArray;
            }
            case 1: {
                int[] nArray = new int[]{this.choiceComponent.getSelectedIndex()};
                return nArray;
            }
        }
        return this.selectedIndexes;
    }

    private void initializeCheckboxComponents(int n) {
        this.pane0.setLayout(new ColumnLayout());
        this.pane0.removeAll();
        this.group = new CheckboxGroup();
        String[] stringArray = this.getOptions();
        this.checkboxComponent = new Checkbox[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.checkboxComponent[n2] = n == 3 ? new Checkbox(stringArray[n2], this.group, false) : new Checkbox(stringArray[n2]);
            this.pane0.add((Component)this.checkboxComponent[n2], new ColumnConstraints(1, 1));
            ++n2;
        }
        this.refreshCheckboxListeners();
    }

    private void initializeComponents() {
        this.pane0.removeAll();
        int n = this.getOptions().length;
        String[] stringArray = this.getOptions();
        this.componentCount = n;
        switch (this.getComponentType()) {
            case 2: {
                this.initializeCheckboxComponents(2);
                break;
            }
            case 4: {
                this.pane0.setLayout(new BorderLayout());
                this.listComponent.removeAll();
                this.listComponent.setMultipleMode(this.isMultipleSelection());
                this.listComponent.addItemListener(this);
                int n2 = 0;
                while (n2 < n) {
                    this.listComponent.add(stringArray[n2]);
                    ++n2;
                }
                this.pane0.add((Component)this.listComponent, "Center");
                break;
            }
            case 1: {
                this.pane0.setLayout(new BorderLayout());
                this.choiceComponent.removeAll();
                int n3 = 0;
                while (n3 < n) {
                    this.choiceComponent.addItem(stringArray[n3]);
                    ++n3;
                }
                this.pane0.add((Component)this.choiceComponent, "Center");
                this.choiceComponent.addItemListener(this);
                break;
            }
            case 3: {
                this.initializeCheckboxComponents(3);
                break;
            }
        }
    }

    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    private boolean isRequiredIndex(int n) {
        int n2 = 0;
        while (n2 < this.requiredIndices.length) {
            if (this.requiredIndices[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSelectedIndex(int n) {
        if (this.isMultipleSelection()) {
            int[] nArray = this.getSelectedIndexes();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.getSelectedIndex() == n;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        boolean bl = itemEvent.getStateChange() == 1;
        Object object2 = null;
        if (itemEvent.getSource() == this.listComponent) {
            object = itemEvent.getItem();
            object2 = this.listComponent.getItem((Integer)object);
        } else {
            object2 = itemEvent.getItem();
        }
        object = new ChoiceComponentEvent(this, (String)object2, this.getItemIndex((String)object2), bl);
        int n = 0;
        while (n < this.listeners.size()) {
            ((ChoiceComponentListener)this.listeners.elementAt(n)).choiceComponentStateChanged((ChoiceComponentEvent)object);
            ++n;
        }
    }

    private void refreshCheckboxListeners() {
        int n = 0;
        while (n < this.checkboxComponent.length) {
            this.checkboxComponent[n].addItemListener(this);
            ++n;
        }
    }

    public void refreshComponentActiveState(int[] nArray) {
        this.refreshComponentsState(nArray);
    }

    private void refreshComponentsState(int[] nArray) {
        if (this.initialized && !this.isConsole) {
            this.clearComponentStates();
            switch (this.getComponentType()) {
                case 2: {
                    int n;
                    if (this.isMultipleSelection()) {
                        n = 0;
                        while (n < nArray.length) {
                            this.checkboxComponent[nArray[n]].setState(true);
                            ++n;
                        }
                    } else if (nArray.length > 0) {
                        this.checkboxComponent[nArray[0]].setState(true);
                    }
                    n = 0;
                    while (n < this.requiredIndices.length) {
                        this.checkboxComponent[this.requiredIndices[n]].setEnabled(this.isRequiredIndex(this.requiredIndices[n]) ^ true);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    if (nArray.length <= 0) break;
                    this.checkboxComponent[nArray[0]].setState(true);
                    break;
                }
                case 4: {
                    if (this.isMultipleSelection()) {
                        int n = 0;
                        while (n < nArray.length) {
                            this.listComponent.select(nArray[n]);
                            ++n;
                        }
                        break;
                    }
                    if (nArray.length <= 0) break;
                    this.listComponent.select(nArray[0]);
                    break;
                }
                case 1: {
                    if (nArray.length <= 0) break;
                    this.choiceComponent.select(nArray[0]);
                    break;
                }
            }
        }
    }

    private void refreshOptions(String[] stringArray) {
        if (this.initialized && !this.isConsole) {
            switch (this.getComponentType()) {
                case 2: 
                case 3: {
                    this.initializeCheckboxComponents(this.getComponentType());
                    break;
                }
                case 4: {
                    this.listComponent.removeAll();
                    this.listComponent.setMultipleMode(this.isMultipleSelection());
                    int n = 0;
                    while (n < this.componentCount) {
                        this.listComponent.add(stringArray[n]);
                        ++n;
                    }
                    break;
                }
                case 1: {
                    this.choiceComponent.removeAll();
                    int n = 0;
                    while (n < this.componentCount) {
                        this.choiceComponent.addItem(stringArray[n]);
                        ++n;
                    }
                    break;
                }
            }
            this.pane0.invalidate();
            this.pane0.validate();
        }
    }

    private void refreshSelectedIndexList() {
        String[] stringArray = this.getOptions();
        this.selectedIndexList.removeAllElements();
        if (this.isMultipleSelection()) {
            int[] nArray = this.getSelectedIndexes();
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 >= 0 || n2 < stringArray.length) {
                    this.selectedIndexList.addElement(new Integer(n2));
                }
                ++n;
            }
        } else {
            int n = this.getSelectedIndex();
            if (n < 0 && n >= stringArray.length) {
                return;
            }
            this.selectedIndexList.addElement(new Integer(n));
        }
    }

    public void removeChoiceComponentListener(ChoiceComponentListener choiceComponentListener) {
        this.listeners.removeElement(choiceComponentListener);
    }

    public void setComponentType(int n) {
        if (n < 3 && n > 4) {
            throw new IllegalArgumentException("Invalid component type " + n);
        }
        this.componentType = n;
    }

    public void setConsoleCaption(String string) {
        this.consoleCaption = string;
    }

    public void setContinue(boolean bl) {
        this.canContinue = bl;
    }

    public void setMultipleSelection(boolean bl) {
        this.isMultipleSelection = bl;
    }

    public void setOptions(String[] stringArray) {
        this.options = stringArray;
        this.componentCount = stringArray.length;
        this.refreshOptions(stringArray);
    }

    public void setRequiredIndexes(int[] nArray) {
        this.requiredIndices = nArray;
    }

    public void setSelectedIndex(int n) {
        this.setSelectedIndexes(new int[]{n});
    }

    public void setSelectedIndexes(int[] nArray) {
        this.selectedIndexes = nArray;
        this.selectedIndexList.removeAllElements();
        int n = 0;
        while (n < this.selectedIndexes.length) {
            if (!this.selectedIndexList.contains(new Integer(nArray[n]))) {
                this.selectedIndexList.addElement(new Integer(nArray[n]));
            }
            ++n;
        }
        this.refreshComponentsState(nArray);
    }

    private void updateSelectedIndex(int n) {
        this.refreshSelectedIndexList();
        boolean bl = this.selectedIndexList.contains(new Integer(n));
        if (bl) {
            if (this.isMultipleSelection()) {
                this.selectedIndexList.removeElement(new Integer(n));
            }
        } else {
            if (!this.isMultipleSelection()) {
                this.selectedIndexList.removeAllElements();
            }
            this.selectedIndexList.addElement(new Integer(n));
        }
        this.updateSelectedIndexes();
        ChoiceComponentEvent choiceComponentEvent = new ChoiceComponentEvent(this, this.options[n], n, this.isSelectedIndex(n));
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((ChoiceComponentListener)this.listeners.elementAt(n2)).choiceComponentStateChanged(choiceComponentEvent);
            ++n2;
        }
    }

    private void updateSelectedIndexes() {
        Enumeration enumeration = this.selectedIndexList.elements();
        int n = this.selectedIndexList.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            nArray[n2++] = n3;
        }
        this.setSelectedIndexes(nArray);
    }
}

