/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.ui.AWTUIComponent;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.installshield.wizardx.ui.DirectoryBrowser;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.Vector;

public abstract class PathInputComponent
extends AbstractUIComponent
implements AWTUIComponent,
ConsoleUIComponent,
ActionListener,
FocusListener {
    private String directoryName = "";
    private TextField directoryField;
    private Button browseButton;
    private DirectoryBrowser dirBrowser;
    private Frame parentFrame;
    private FileService fileService;
    private Vector actionListeners = new Vector();
    private Vector textListeners = new Vector();
    private boolean isInitialized = false;
    private String label = "";
    private int selectionType = 1;
    private String dialogTitle = "";
    private String consoleCaption = "";
    private boolean secondClick = false;
    private String pathDisplayText = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder");

    public PathInputComponent(String string, Frame frame, FileService fileService, int n) {
        this.directoryName = string;
        this.parentFrame = frame;
        this.fileService = fileService;
        this.selectionType = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.browseButton.equals(object) && !this.secondClick) {
            this.secondClick = true;
            this.browseForDirectory();
            this.secondClick = false;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.directoryField != null && actionListener != null) {
            this.directoryField.addActionListener(actionListener);
        }
        this.actionListeners.addElement(actionListener);
    }

    public void addTextListener(TextListener textListener) {
        if (this.directoryField != null && textListener != null) {
            this.directoryField.addTextListener(textListener);
        }
        this.textListeners.addElement(textListener);
    }

    private void browseForDirectory() {
        if (this.dirBrowser == null) {
            this.initDirBrowser();
        }
        try {
            String string = this.directoryField.getText();
            this.dirBrowser.setInitialDirectory(string);
            this.dirBrowser.run();
            if (this.dirBrowser.dirName() != null) {
                this.setPathName(this.dirBrowser.dirName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void consoleInteraction() {
        TTYDisplay.showNewline();
        String string = this.getPathName();
        if (string.trim().equals("")) {
            string = "/";
        }
        String string2 = TTYDisplay.queryValue(this.consoleCaption, string, "");
        this.setPathName(string2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, string2);
        TextEvent textEvent = new TextEvent(this, 900);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.textListeners.size()) {
            ((TextListener)this.textListeners.elementAt(n2)).textValueChanged(textEvent);
            ++n2;
        }
    }

    public void createComponentUI() {
        this.isInitialized = true;
        Panel panel = new Panel();
        panel.setLayout(new ColumnLayout(4));
        FlowLabel flowLabel = new FlowLabel(this.label);
        panel.add((Component)flowLabel, new ColumnConstraints(1, 1));
        this.directoryField = new TextField(0);
        this.directoryField.setText(this.directoryName);
        this.directoryField.requestFocus();
        panel.add((Component)this.directoryField, ColumnConstraints.createHorizontalFill());
        this.browseButton = new Button(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browse"));
        panel.add((Component)this.browseButton, new ColumnConstraints(3, 1));
        this.browseButton.addActionListener(this);
        this.directoryField.addActionListener(this);
        this.directoryField.addFocusListener(this);
        this.add((Component)panel, "Center");
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (this.directoryField.equals(object)) {
            this.directoryField.setText(this.removeTerminalSeparator(this.directoryField.getText()));
        }
    }

    public String getBrowserPathDisplayText() {
        return this.pathDisplayText;
    }

    public String getConsoleCaption() {
        return this.consoleCaption;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public TextField getInputComponent() {
        return this.directoryField;
    }

    public String getLabel() {
        return this.label;
    }

    public static Frame getParentFrame(Component component) {
        if (component == null) {
            String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "getParentFrameError");
            throw new IllegalArgumentException(string);
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return PathInputComponent.getParentFrame(container);
    }

    public String getPathName() {
        if (this.isInitialized && this.directoryField != null) {
            this.directoryName = this.removeTerminalSeparator(this.directoryField.getText());
        }
        return this.directoryName;
    }

    private void initDirBrowser() {
        Frame frame = PathInputComponent.getParentFrame(this.browseButton);
        try {
            this.dirBrowser = new DirectoryBrowser(frame, this.dialogTitle, null, this.fileService, this.pathDisplayText);
            this.dirBrowser.setSelectionType(this.selectionType);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners == null || this.actionListeners.size() <= 0) {
            return;
        }
        this.actionListeners.removeElement(actionListener);
    }

    private String removeTerminalSeparator(String string) {
        try {
            String string2 = new String(string);
            while (string2.endsWith("\\") || string2.endsWith("/") || string2.endsWith(File.separator)) {
                if (this.fileService.getParent(string2) == null) break;
                string2 = string2.substring(0, string2.length() - 1);
            }
            string = string2;
        }
        catch (ServiceException serviceException) {}
        return string;
    }

    public void removeTextListener(TextListener textListener) {
        if (this.textListeners == null || this.textListeners.size() <= 0) {
            return;
        }
        this.textListeners.removeElement(textListener);
    }

    public void setBrowserPathDisplayText(String string) {
        this.pathDisplayText = string;
    }

    public void setConsoleCaption(String string) {
        this.consoleCaption = string;
    }

    public void setDialogTitle(String string) {
        this.dialogTitle = string;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setPathName(String string) {
        this.directoryName = this.removeTerminalSeparator(string);
        if (this.isInitialized && this.directoryField != null) {
            this.directoryField.setText(this.directoryName);
        }
    }
}

