/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.HtmlToTextConverter;
import com.installshield.util.MD5;
import com.installshield.util.TTYDisplay;
import com.installshield.util.TextConverter;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class TextDisplayComponent
extends AbstractUIComponent
implements ConsoleUIComponent,
KeyListener {
    public static final int HTML_DISPLAY = 1;
    public static final int TEXT_DISPLAY = 2;
    private String text;
    private FlowLabel label = null;
    private boolean isLabelDisplay = true;
    private Browser browser = null;
    private TextArea textArea = null;
    private Color foreground = null;
    private Color background = null;
    private boolean showBorder = false;
    private TextConverter consoleTextConverter = null;
    private String currText = "";
    private int displayType = 2;
    private Container cContainer = null;

    public TextDisplayComponent() {
        this("");
    }

    public TextDisplayComponent(String string) {
        this(string, false);
    }

    public TextDisplayComponent(String string, boolean bl) {
        this.isLabelDisplay = bl;
        this.setLayout(new BorderLayout());
        if (string == null) {
            throw new IllegalArgumentException("Text value cannot be null ");
        }
        this.text = string;
    }

    public void addNotify() {
        super.addNotify();
        if (this.browser != null) {
            this.setBrowserText();
        }
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        TTYDisplay.showNewline();
        TextConverter textConverter = this.consoleTextConverter;
        if (textConverter == null) {
            textConverter = new HtmlToTextConverter();
        }
        TTYDisplay.pageText(textConverter.convertText(this.text));
    }

    public void createComponentUI() {
        if (this.isLabelDisplay()) {
            this.createDisplayLabel();
            this.browser = null;
            this.textArea = null;
        } else {
            this.createDisplayArea();
            this.label = null;
        }
    }

    private void createDisplayArea() {
        this.removeAll();
        if (this.getDisplayType() == 1) {
            this.browser = new Browser();
            Font font = this.findFont();
            if (font != null) {
                this.browser.setProportionalFont(font);
            }
            Panel panel = new Panel(new BorderLayout());
            panel.add((Component)this.browser, "Center");
            this.add((Component)panel, "Center");
        } else {
            this.textArea = new TextArea(this.getText());
            this.textArea.setEditable(false);
            this.textArea.addKeyListener(this);
            this.add((Component)this.textArea, "Center");
        }
    }

    private void createDisplayLabel() {
        this.removeAll();
        this.label = new FlowLabel(this.getText());
        this.add((Component)this.label, "Center");
    }

    private Color findBackground() {
        Color color = this.getBackground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getBackground();
            container = container.getParent();
        }
        if (color != null) {
            this.background = color;
        } else {
            color = this.background != null ? this.background : Color.white;
        }
        return color;
    }

    private Font findFont() {
        Font font = this.getFont();
        Container container = this.getParent();
        while (font == null && container != null) {
            font = container.getFont();
            container = container.getParent();
        }
        return font;
    }

    private Color findForeground() {
        Color color = this.getForeground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getForeground();
            container = container.getParent();
        }
        if (color != null) {
            this.foreground = color;
        } else {
            color = this.foreground != null ? this.foreground : Color.black;
        }
        return color;
    }

    private String format(Color color) {
        return "#" + MD5.toHex(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    private void getAllFocusableComponents(Container container, Vector vector) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null && componentArray.length > 0) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] != null) {
                    if (componentArray[n] instanceof Container) {
                        this.getAllFocusableComponents((Container)componentArray[n], vector);
                    } else if (componentArray[n].isFocusTraversable() || componentArray[n] == this) {
                        vector.addElement(componentArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    public TextConverter getConsoleTextConverter() {
        return this.consoleTextConverter;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public Insets getInsets() {
        if (this.showBorder) {
            return new Insets(2, 2, 2, 2);
        }
        return super.getInsets();
    }

    private Component getLastFocusComponent(Component component) {
        Object object = component;
        if (this.cContainer != null) {
            Vector vector = new Vector();
            this.getAllFocusableComponents(this.cContainer, vector);
            Object[] objectArray = new Component[vector.size()];
            vector.copyInto(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == component) {
                    if (n == 0) {
                        object = objectArray[objectArray.length - 1];
                        break;
                    }
                    object = objectArray[n - 1];
                    break;
                }
                ++n;
            }
        }
        return object;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLabelDisplay() {
        return this.isLabelDisplay;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.textArea && keyEvent.getKeyCode() == 9 && (keyEvent.getModifiers() & 2) == 0) {
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.getLastFocusComponent(this.textArea).requestFocus();
            } else {
                this.textArea.transferFocus();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.showBorder) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
            graphics.setColor(Color.white);
            graphics.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void setAWTWizardContainer(Container container) {
        this.cContainer = container;
    }

    private void setBrowserText() {
        if (!this.currText.equals(this.getText())) {
            this.currText = this.getText();
            this.browser.htmlClear();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body bgcolor=\"");
            stringBuffer.append(this.format(this.findBackground()));
            stringBuffer.append("\"><font color=\"");
            stringBuffer.append(this.format(this.findForeground()));
            stringBuffer.append("\">");
            stringBuffer.append(this.currText);
            stringBuffer.append("</font></body></html>");
            this.browser.htmlAppend(stringBuffer.toString());
        }
    }

    public void setConsoleTextConverter(TextConverter textConverter) {
        this.consoleTextConverter = textConverter;
    }

    public void setDisplayType(int n) {
        this.displayType = n;
    }

    public void setLabelDisplay(boolean bl) {
        this.isLabelDisplay = bl;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        this.text = string;
        if (this.label != null) {
            this.label.setText(string);
        }
        if (this.browser != null) {
            this.setBrowserText();
        }
        if (this.textArea != null) {
            this.textArea.setText(string);
        }
    }
}

