/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.util.Vector;

public class TextInputComponent
extends AbstractUIComponent
implements ConsoleUIComponent {
    private static final int BORDER_LAYOUT = 1;
    private static final int FLOW_LAYOUT = 2;
    private static final int COLUMN_LAYOUT = 3;
    private int rows;
    private int columns;
    private String text;
    private String caption = "";
    private boolean isPassword = false;
    private boolean isLineWrap = false;
    private int layout = 1;
    private TextComponent comp;
    private boolean canContinue = true;
    private Vector actionListeners;
    private Vector keyListeners;
    private Vector textListeners;
    private TextInputComponentKeyListener keyListener;
    private TextInputComponentTextListener textListener;
    private TextInputComponentActionListener actionListener;

    public TextInputComponent() {
        this("");
    }

    public TextInputComponent(int n, int n2) {
        this("", n, n2, false);
    }

    public TextInputComponent(int n, int n2, boolean bl) {
        this("", n, n2, bl);
    }

    public TextInputComponent(String string) {
        this(string, 0, 0, false);
    }

    public TextInputComponent(String string, int n, int n2, boolean bl) {
        this.text = string;
        this.rows = n;
        this.columns = n2;
        this.isLineWrap = bl;
    }

    public TextInputComponent(String string, boolean bl) {
        this(string, 0, 0, bl);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.addElement(actionListener);
    }

    private void addComponent(TextComponent textComponent) {
        if (this.comp != null) {
            this.remove(this.comp);
            this.removeListeners(this.comp);
        }
        this.comp = textComponent;
        if (this.layout == 1) {
            this.add((Component)this.comp, "North");
        } else if (this.layout == 2) {
            this.add(this.comp);
        } else {
            this.add((Component)this.comp, ColumnConstraints.createLeftAlign());
        }
        this.addListeners(this.comp);
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Vector();
        }
        this.keyListeners.addElement(keyListener);
    }

    private void addListeners(TextComponent textComponent) {
        if (this.keyListener == null) {
            this.keyListener = new TextInputComponentKeyListener();
        }
        textComponent.addKeyListener(this.keyListener);
        if (this.textListener == null) {
            this.textListener = new TextInputComponentTextListener();
        }
        textComponent.addTextListener(this.textListener);
        if (textComponent instanceof TextField) {
            if (this.actionListener == null) {
                this.actionListener = new TextInputComponentActionListener();
            }
            ((TextField)textComponent).addActionListener(this.actionListener);
        }
    }

    public void addTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            this.textListeners = new Vector();
        }
        this.textListeners.addElement(textListener);
    }

    public boolean canContinue() {
        return this.canContinue;
    }

    private void checkEchoCharacter(TextComponent textComponent) {
        if (textComponent instanceof TextField) {
            if (this.isPassword() && !((TextField)textComponent).echoCharIsSet()) {
                ((TextField)textComponent).setEchoChar('*');
            } else if (((TextField)textComponent).echoCharIsSet() && !this.isPassword()) {
                this.addComponent(new TextField(this.text, this.columns));
            }
        }
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        boolean bl = true;
        do {
            if (!bl && this.isPassword()) {
                TTYDisplay.showText(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "TextInputComponent.invalidTextEntered", new String[]{this.getText()}));
            }
            TTYDisplay.showNewline();
            this.text = !this.isPassword() || TTYDisplay.accessbilityEnabled() ? TTYDisplay.queryValue(this.getCaption(), this.isPassword() ? "" : this.getText(), "") : this.getPassword();
            this.setText(this.text);
            this.informActionListeners(new ActionEvent(this, 1001, this.text));
            bl = this.canContinue;
        } while (!this.canContinue);
    }

    public void createComponentUI() {
        if (this.comp == null) {
            TextComponent textComponent = null;
            this.validateLayout();
            if (this.rows > 1) {
                textComponent = this.createTextArea(this.text, this.rows, this.columns, this.isLineWrap);
            } else {
                textComponent = new TextField(this.text, this.columns);
                if (this.isPassword()) {
                    this.checkEchoCharacter(textComponent);
                }
            }
            this.addComponent(textComponent);
        }
    }

    private TextArea createTextArea(String string, int n, int n2, boolean bl) {
        if (bl) {
            return new TextArea(string, n, n2, 1);
        }
        return new TextArea(string, n, n2);
    }

    public String getCaption() {
        return this.caption;
    }

    public int getColumns() {
        return this.columns;
    }

    public String getPassword() {
        String string = "";
        PasswordThread passwordThread = new PasswordThread();
        passwordThread.start();
        block2: while (true) {
            try {
                while (true) {
                    char c = (char)System.in.read();
                    passwordThread.setStop();
                    if (c == '\n' || c == '\r') {
                        while (System.in.available() > 0) {
                            System.in.read();
                        }
                        break block2;
                    }
                    string = String.valueOf(string) + c;
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return string;
    }

    public int getRows() {
        return this.rows;
    }

    public String getText() {
        if (this.comp != null) {
            return this.comp.getText();
        }
        return this.text;
    }

    private void informActionListeners(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            int n = 0;
            while (n < this.actionListeners.size()) {
                ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public boolean isLineWrap() {
        return this.isLineWrap;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.removeElement(actionListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.keyListeners != null) {
            this.keyListeners.removeElement(keyListener);
        }
    }

    private void removeListeners(TextComponent textComponent) {
        if (this.keyListener != null) {
            textComponent.removeKeyListener(this.keyListener);
        }
        if (this.textListener != null) {
            textComponent.removeTextListener(this.textListener);
        }
        if (textComponent instanceof TextField && this.actionListener != null) {
            ((TextField)textComponent).removeActionListener(this.actionListener);
        }
    }

    public void removeTextListener(TextListener textListener) {
        if (this.textListeners != null) {
            this.textListeners.removeElement(textListener);
        }
    }

    public void requestFocus() {
        if (this.comp != null) {
            this.comp.requestFocus();
        }
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setColumns(int n) {
        this.columns = n;
        if (this.comp instanceof TextArea) {
            ((TextArea)this.comp).setColumns(n);
        } else {
            ((TextField)this.comp).setColumns(n);
        }
        this.validateLayout();
        this.checkEchoCharacter(this.comp);
    }

    public void setContinue(boolean bl) {
        this.canContinue = bl;
    }

    public void setLineWrap(boolean bl) {
        this.isLineWrap = bl;
        if (this.comp != null && this.comp instanceof TextArea) {
            this.addComponent(this.createTextArea(this.text, this.getRows(), this.getColumns(), bl));
        }
    }

    public void setPassword(boolean bl) {
        this.isPassword = bl;
        this.checkEchoCharacter(this.comp);
    }

    public void setRows(int n) {
        this.rows = n;
        if (this.comp != null) {
            if (n > 1) {
                if (this.comp instanceof TextArea) {
                    ((TextArea)this.comp).setRows(n);
                } else if (this.comp instanceof TextField) {
                    this.addComponent(this.createTextArea(this.text, n, this.columns, this.isLineWrap));
                }
            } else if (this.comp instanceof TextArea) {
                this.addComponent(new TextField(this.text, this.columns));
                this.validateLayout();
            }
            if (this.isPassword()) {
                this.checkEchoCharacter(this.comp);
            }
        }
    }

    public void setText(String string) {
        this.text = string;
        if (this.comp != null) {
            this.comp.setText(string);
        } else {
            TextEvent textEvent = new TextEvent(this, 900);
            int n = 0;
            while (this.textListeners != null && n < this.textListeners.size()) {
                ((TextListener)this.textListeners.elementAt(n)).textValueChanged(textEvent);
                ++n;
            }
        }
    }

    private void validateLayout() {
        if (this.getColumns() > 0 || this.getRows() > 0) {
            this.layout = 3;
            this.setLayout(new ColumnLayout());
        } else {
            this.layout = 1;
            this.setLayout(new BorderLayout());
        }
    }

    private class TextInputComponentActionListener
    implements ActionListener {
        TextInputComponentActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextInputComponent.this.informActionListeners(new ActionEvent(TextInputComponent.this, 1001, actionEvent.getActionCommand()));
        }
    }

    private class TextInputComponentKeyListener
    implements KeyListener {
        TextInputComponentKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (TextInputComponent.this.keyListeners != null) {
                KeyEvent keyEvent2 = new KeyEvent(TextInputComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                int n = 0;
                while (n < TextInputComponent.this.keyListeners.size()) {
                    ((KeyListener)TextInputComponent.this.keyListeners.elementAt(n)).keyPressed(keyEvent2);
                    ++n;
                }
                if (keyEvent2.isConsumed()) {
                    keyEvent.consume();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (TextInputComponent.this.keyListeners != null) {
                KeyEvent keyEvent2 = new KeyEvent(TextInputComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                int n = 0;
                while (n < TextInputComponent.this.keyListeners.size()) {
                    ((KeyListener)TextInputComponent.this.keyListeners.elementAt(n)).keyReleased(keyEvent2);
                    ++n;
                }
                if (keyEvent2.isConsumed()) {
                    keyEvent.consume();
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (TextInputComponent.this.keyListeners != null) {
                KeyEvent keyEvent2 = new KeyEvent(TextInputComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                int n = 0;
                while (n < TextInputComponent.this.keyListeners.size()) {
                    ((KeyListener)TextInputComponent.this.keyListeners.elementAt(n)).keyTyped(keyEvent2);
                    ++n;
                }
                if (keyEvent2.isConsumed()) {
                    keyEvent.consume();
                }
            }
        }
    }

    private class TextInputComponentTextListener
    implements TextListener {
        TextInputComponentTextListener() {
        }

        public void textValueChanged(TextEvent textEvent) {
            if (TextInputComponent.this.textListeners != null) {
                int n = 0;
                while (n < TextInputComponent.this.textListeners.size()) {
                    ((TextListener)TextInputComponent.this.textListeners.elementAt(n)).textValueChanged(new TextEvent(TextInputComponent.this, textEvent.getID()));
                    ++n;
                }
            }
        }
    }

    private class PasswordThread
    extends Thread {
        private boolean stop = false;

        PasswordThread() {
        }

        public synchronized boolean getStop() {
            return this.stop;
        }

        public void run() {
            String string = TextInputComponent.this.getCaption().trim().endsWith(":") ? TextInputComponent.this.getCaption().substring(0, TextInputComponent.this.getCaption().lastIndexOf(58)) : TextInputComponent.this.getCaption();
            String string2 = "\r" + string + ":\r" + string;
            while (!this.getStop()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.getStop()) {
                    System.out.print(string2);
                }
                System.out.flush();
            }
        }

        public synchronized void setStop() {
            this.stop = true;
        }
    }
}

