/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;

public class SybExpression {
    static final String SPACE = " ";
    static final String OPEN_BRACKET = "(";
    static final String CLOSE_BRACKET = ")";
    static final String EQUAL = "==";
    static final String NOT_EQUAL = "!=";
    static final String OR = "||";
    static final String AND = "&&";
    static final String GREATER = ">";
    static final String GREATER_EQUAL = ">=";
    static final String LESS = "<";
    static final String LESS_EQUAL = "<=";
    static final String DELIMITERS = " ()";
    static final String TRUE = "true";
    static final String FALSE = "false";

    private SybExpression() {
    }

    private static boolean isOperator(String string) {
        return string.equals(EQUAL) || string.equals(NOT_EQUAL) || string.equals(OR) || string.equals(AND) || string.equals(GREATER_EQUAL) || string.equals(GREATER) || string.equals(LESS_EQUAL) || string.equals(LESS);
    }

    private static boolean isBracket(String string) {
        return string.equals(OPEN_BRACKET) || string.equals(CLOSE_BRACKET);
    }

    private static int precedence(String string) {
        if (SybExpression.isBracket(string)) {
            return 4;
        }
        if (string.equals(GREATER) || string.equals(GREATER_EQUAL) || string.equals(LESS) || string.equals(LESS_EQUAL)) {
            return 3;
        }
        if (string.equals(EQUAL) || string.equals(NOT_EQUAL)) {
            return 2;
        }
        if (string.equals(AND)) {
            return 1;
        }
        if (string.equals(OR)) {
            return 0;
        }
        return -1;
    }

    public static boolean evaluate(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITERS, true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (string2.equals(SPACE)) continue;
            if (!SybExpression.isOperator(string2) && !SybExpression.isBracket(string2)) {
                arrayList.add(string2);
                continue;
            }
            if (string2.equals(OPEN_BRACKET)) {
                stack.push(string2);
                continue;
            }
            if (SybExpression.isOperator(string2)) {
                while (!stack.empty() && SybExpression.precedence(string2) > SybExpression.precedence(stack.peek().toString())) {
                    arrayList.add((String)stack.pop());
                }
                stack.push(string2);
                continue;
            }
            if (!string2.equals(CLOSE_BRACKET)) continue;
            while (!stack.empty() && !stack.peek().toString().equals(OPEN_BRACKET)) {
                arrayList.add((String)stack.pop());
            }
            try {
                stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                emptyStackException.printStackTrace();
                System.err.println("Malformed expression: Closing bracket found with no corresponding opening bracket.");
                System.err.println(string);
                System.err.println(stringBuffer.toString() + " <- offending bracket");
                return true;
            }
        }
        while (!stack.empty()) {
            if (stack.peek().toString().equals(OPEN_BRACKET)) {
                new Exception("Malformed expression: Opening bracket found with no corresponding closing bracket in expression: " + string).printStackTrace();
            }
            arrayList.add((String)stack.pop());
        }
        stack = new Stack();
        String string3 = TRUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = arrayList.get(i).toString();
            if (!SybExpression.isOperator(string2)) {
                stack.push(string2);
                continue;
            }
            String string4 = stack.pop().toString();
            String string5 = stack.pop().toString();
            if (string2.equals(EQUAL)) {
                string3 = string4.compareToIgnoreCase(string5) == 0 ? TRUE : FALSE;
            } else if (string2.equals(NOT_EQUAL)) {
                string3 = string4.compareToIgnoreCase(string5) != 0 ? TRUE : FALSE;
            } else if (string2.equals(OR)) {
                string3 = string4.equalsIgnoreCase(TRUE) || string5.equalsIgnoreCase(TRUE) ? TRUE : FALSE;
            } else if (string2.equals(AND)) {
                string3 = string4.equalsIgnoreCase(TRUE) && string5.equalsIgnoreCase(TRUE) ? TRUE : FALSE;
            } else if (string2.equals(GREATER)) {
                string3 = string4.compareToIgnoreCase(string5) > 0 ? TRUE : FALSE;
            } else if (string2.equals(GREATER_EQUAL)) {
                string3 = string4.compareToIgnoreCase(string5) >= 0 ? TRUE : FALSE;
            } else if (string2.equals(LESS)) {
                string3 = string4.compareToIgnoreCase(string5) < 0 ? TRUE : FALSE;
            } else if (string2.equals(LESS_EQUAL)) {
                string3 = string4.compareToIgnoreCase(string5) <= 0 ? TRUE : FALSE;
            }
            stack.push(string3);
        }
        string3 = stack.pop().toString();
        return string3.equalsIgnoreCase(TRUE);
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(SPACE + stringArray[i]);
        }
        String string = stringBuffer.toString();
        boolean bl = SybExpression.evaluate(string);
        System.out.println(string + " = " + new Boolean(bl).toString());
    }
}

