/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.service.ServiceException;
import com.sybase.ismp.ase.OSInfo;
import com.sybase.ismp.ase.OSUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class ConfiguratorEnvironmentFiles
extends ProductAction
implements OSInfo {
    public static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$productbean$ConfiguratorEnvironmentFiles == null ? (class$com$sybase$ismp$ase$productbean$ConfiguratorEnvironmentFiles = ConfiguratorEnvironmentFiles.class$("com.sybase.ismp.ase.productbean.ConfiguratorEnvironmentFiles")) : class$com$sybase$ismp$ase$productbean$ConfiguratorEnvironmentFiles).getName());
    public static final int SET = 0;
    public static final int UNSET = 1;
    public static final int ADD = 2;
    private static final int SH = 1;
    private static final int CSH = 2;
    private static final int DOS = 3;
    private static final char[] CSH_META = new char[]{' ', '\t', '\r', '*', '[', ']', '?', '~', '<', '>', '&', '|', ';', '(', ')', '\\', '\'', '\"', '`'};
    private static final String PRODUCT_URL = "/product.xml";
    private static String _path_separator = System.getProperty("path.separator");
    private static String _file_separator = System.getProperty("file.separator");
    private static String _line_separator = System.getProperty("line.separator");
    private int _type;
    private String _variableName = "";
    private String _variableValue = "";
    private int _operatingSystem = 8;
    protected String _version;
    protected String _componentId;
    protected String _title;
    protected String _rootInstallDirectory;
    private String _componentBeanID;
    protected String _componentDirectory;
    static /* synthetic */ Class class$com$sybase$ismp$ase$productbean$ConfiguratorEnvironmentFiles;

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        LOG.debug("Replacing now");
        this.install(productActionSupport);
    }

    public void install(ProductActionSupport productActionSupport) {
        this._componentBeanID = this.parentBeanId();
        this.retrieveBeanInformation();
        this._variableValue = this.resolveString(this._variableValue);
        if (!this._variableName.equals("")) {
            this.createShellFiles();
        }
        this.createEnvFile();
    }

    public void uninstall(ProductActionSupport productActionSupport) {
        this._componentBeanID = this.parentBeanId();
        this.retrieveBeanInformation();
        this.deleteCreatedFiles();
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        productBuilderSupport.putRequiredService("productService");
        try {
            productBuilderSupport.putClass("com.sybase.ismp.ase.OSInfo");
            productBuilderSupport.putClass("com.sybase.ismp.ase.OSUtil");
            productBuilderSupport.putPackage("org.apache.log4j", true);
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", exception);
        }
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public String getVariableName() {
        return this._variableName;
    }

    public void setVariableName(String string) {
        this._variableName = string;
    }

    public String getVariableValue() {
        return this._variableValue;
    }

    public void setVariableValue(String string) {
        this._variableValue = string;
    }

    public int getOperatingSystem() {
        return this._operatingSystem;
    }

    public void setOperatingSystem(int n) {
        this._operatingSystem = n;
    }

    protected void createShellFiles() {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                string = this._rootInstallDirectory + _file_separator + "SYBASE.bat";
                string2 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(3).replace('/', '\\'), "\\");
                if (this._type != 1 && !ConfiguratorEnvironmentFiles.isStringInFile(string, string2)) {
                    fileWriter = new FileWriter(string, true);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    LOG.debug("Writing to SYBASE.bat : " + string2);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else if (this._type == 1) {
                    string4 = ConfiguratorEnvironmentFiles.readFile(string);
                    LOG.debug("Removing command from SYBASE.bat : " + string2);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string4, string2);
                    this._type = 2;
                    string3 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(3).replace('/', '\\'), "\\");
                    this._type = 1;
                    LOG.debug("Removing command from SYBASE.bat : " + string3);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string2, string3);
                    fileWriter = new FileWriter(string);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else {
                    LOG.debug("Already exist in SYBASE.bat, skipping... : " + string2);
                }
            } else {
                String string5;
                File file;
                string = this._rootInstallDirectory + _file_separator + "SYBASE.sh";
                string2 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(1), "/");
                if (this._type != 1 && !ConfiguratorEnvironmentFiles.isStringInFile(string, string2)) {
                    file = new File(string);
                    string5 = "#" + _line_separator + "# Sybase Product Environment variables" + _line_separator + "#" + _line_separator;
                    if (file.exists() && file.length() != 0L) {
                        string5 = "";
                    }
                    fileWriter = new FileWriter(string, true);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string5, 0, string5.length());
                    LOG.debug("Writing to SYBASE.sh: " + string2);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else if (this._type == 1) {
                    string4 = ConfiguratorEnvironmentFiles.readFile(string);
                    LOG.debug("Removing command from SYBASE.sh : " + string2);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string4, string2);
                    this._type = 2;
                    string3 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(1), "/");
                    this._type = 1;
                    LOG.debug("Removing command from SYBASE.sh : " + string3);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string2, string3);
                    fileWriter = new FileWriter(string);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else {
                    LOG.debug("Already exist in SYBASE.sh, skipping... : " + string2);
                }
                string = this._rootInstallDirectory + _file_separator + "SYBASE.csh";
                string2 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(2), "/");
                if (this._type != 1 && !ConfiguratorEnvironmentFiles.isStringInFile(string, string2)) {
                    file = new File(string);
                    string5 = "#" + _line_separator + "# Sybase Product Environment variables" + _line_separator + "#" + _line_separator;
                    if (file.exists() && file.length() != 0L) {
                        string5 = "";
                    }
                    fileWriter = new FileWriter(string, true);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string5, 0, string5.length());
                    LOG.debug("Writing to SYBASE.csh: " + string2);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else if (this._type == 1) {
                    string4 = ConfiguratorEnvironmentFiles.readFile(string);
                    LOG.debug("Removing command from SYBASE.csh: " + string2);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string4, string2);
                    this._type = 2;
                    string3 = ConfiguratorEnvironmentFiles.replaceDoubleChar(this.generateShellCommand(2), "/");
                    this._type = 1;
                    LOG.debug("Removing command from SYBASE.csh: " + string2);
                    string2 = ConfiguratorEnvironmentFiles.removeSubstring(string2, string3);
                    fileWriter = new FileWriter(string);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    fileWriter.close();
                } else {
                    LOG.debug("Already exist in SYBASE.csh, skipping... : " + string2);
                }
            }
        }
        catch (IOException iOException) {
            LOG.error(iOException);
        }
    }

    protected void createEnvFile() {
        try {
            FileWriter fileWriter = new FileWriter(this._rootInstallDirectory + _file_separator + "SYBASE.env", true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string = "";
            if (!this._variableName.equals("")) {
                string = this.generateEnvLine();
                bufferedWriter.write(string, 0, string.length());
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void deleteCreatedFiles() {
        File file = new File(this._rootInstallDirectory + _file_separator + "SYBASE.sh");
        File file2 = new File(this._rootInstallDirectory + _file_separator + "SYBASE.csh");
        File file3 = new File(this._rootInstallDirectory + _file_separator + "SYBASE.bat");
        File file4 = new File(this._rootInstallDirectory + _file_separator + "SYBASE.env");
    }

    private void retrieveBeanInformation() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            String string = productService.getProductTreeRoot(PRODUCT_URL);
            this._rootInstallDirectory = (String)productService.getProductBeanProperty(PRODUCT_URL, string, "installLocation");
            this._title = (String)productService.getProductBeanProperty(PRODUCT_URL, this._componentBeanID, "description");
            SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)productService.getProductBeanProperty(PRODUCT_URL, this._componentBeanID, "key");
            this._version = softwareObjectKey.getVersion().getFormatted();
            this._componentDirectory = (String)productService.getProductBeanProperty(PRODUCT_URL, this._componentBeanID, "installLocation");
            this._componentId = (String)productService.getProductBeanProperty(PRODUCT_URL, this._componentBeanID, "name");
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
    }

    private String generateEnvLine() {
        String string = "";
        String string2 = "";
        string = System.getProperty("os.name").startsWith("Windows") ? "%" + this._variableName + "%" : "$" + this._variableName;
        if (0 == this._type) {
            string2 = this._variableName + "=" + this._variableValue + _line_separator;
        }
        if (2 == this._type) {
            string2 = this._variableName + "=" + this._variableValue + _path_separator + string + _line_separator;
        }
        string2 = OSUtil.isOperatingSystemOk(this._operatingSystem) ? this.doSubstitutions(string2) : "";
        return string2;
    }

    private String generateShellCommand(int n) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (n == 1) {
            string8 = this.quoteSHValue(this.doSubstitutions(this._variableValue));
            string4 = "$" + this._variableName;
            string2 = this._variableName + "=";
            string3 = "export " + this._variableName + _line_separator;
            string5 = "unset " + this._variableName + _line_separator;
        } else if (n == 2) {
            string8 = this.quoteCSHValue(this.doSubstitutions(this._variableValue));
            string4 = "$" + this._variableName;
            string = "setenv " + this._variableName;
            string2 = " ";
            string5 = "unsetenv " + this._variableName + _line_separator;
            string6 = "if ( $?" + this._variableName + " == \"0\" ) then" + _line_separator + "    " + string + " \"\"" + _line_separator + "endif" + _line_separator;
        } else if (n == 3) {
            string8 = this.quoteDOSValue(this.doSubstitutions(this._variableValue));
            string4 = "%" + this._variableName + "%";
            string = "set " + this._variableName;
            string2 = "=";
            string5 = "set " + this._variableName + "=" + _line_separator;
        }
        if (OSUtil.isOperatingSystemOk(this._operatingSystem)) {
            if (0 == this._type || 1 == this._type) {
                string7 = string + string2 + string8 + _line_separator + string3;
            }
            if (2 == this._type) {
                string7 = string6 + string + string2 + string8 + _path_separator + string4 + _line_separator + string3;
            }
        }
        return string7;
    }

    private String quoteSHValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, '\"');
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private String quoteCSHValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            for (int j = 0; j < CSH_META.length; ++j) {
                if (stringBuffer.charAt(i) != CSH_META[j]) continue;
                stringBuffer.insert(i, '\\');
                ++i;
            }
        }
        return stringBuffer.toString();
    }

    private String quoteDOSValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        char[] cArray = new char[]{'^', '&', '|', '\"', '<', '>'};
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '%') {
                stringBuffer.insert(i, '%');
                ++i;
            }
            for (int j = 0; j < cArray.length; ++j) {
                if (stringBuffer.charAt(i) != cArray[j]) continue;
                stringBuffer.insert(i, '^');
                ++i;
            }
        }
        return stringBuffer.toString();
    }

    private String doSubstitutions(String string) {
        String string2 = string;
        String string3 = "";
        String string4 = Locale.getDefault().toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMMMMM-yyyy, HH:mm:ss a");
        Date date = new Date();
        while (!string2.equals(string3)) {
            string3 = string2;
            int n = string2.indexOf("$(SYBASE)");
            if (n != -1) {
                string2 = string2.substring(0, n) + this._rootInstallDirectory + string2.substring(n + 9);
            }
            if ((n = string2.indexOf("$(LOCALE)")) != -1) {
                string2 = string2.substring(0, n) + string4 + string2.substring(n + 9);
            }
            if ((n = string2.indexOf("$(DATE)")) != -1) {
                string2 = string2.substring(0, n) + simpleDateFormat.format(date) + string2.substring(n + 7);
            }
            if ((n = string2.indexOf("$(COMPID)")) != -1) {
                string2 = string2.substring(0, n) + this._componentId + string2.substring(n + 9);
            }
            if ((n = string2.indexOf("$(COMPDIR)")) != -1) {
                string2 = string2.substring(0, n) + this._componentDirectory + string2.substring(n + 10);
            }
            if ((n = string2.indexOf("$(VERSION)")) != -1) {
                string2 = string2.substring(0, n) + this._version + string2.substring(n + 10);
            }
            if ((n = string2.indexOf("$(TITLE)")) == -1) continue;
            string2 = string2.substring(0, n) + this._title + string2.substring(n + 8);
        }
        return string3;
    }

    private String parentBeanId() {
        return this.getProductTree().getParent(this).getBeanId();
    }

    public static String replaceDoubleChar(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2) && stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(string2)) {
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(string3 + string4);
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            File file = new File(string);
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2 + _line_separator);
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            LOG.error(iOException);
        }
        return stringBuffer.toString();
    }

    private static boolean isStringInFile(String string, String string2) {
        String string3 = ConfiguratorEnvironmentFiles.readFile(string);
        return string3.indexOf(string2) != -1;
    }

    private static String removeSubstring(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string2.length();
        while ((n = stringBuffer.toString().indexOf(string2)) != -1) {
            int n3 = n + n2;
            stringBuffer.delete(n, n3);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

