/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.sybase.ismp.ase.productbean.ValueAction;
import com.sybase.ismp.ase.productbean.W32RegistryState;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class KeyInfo
implements Serializable {
    static final long serialVersionUID = -7903132322176176177L;
    private int root;
    private String subkey;
    private boolean created = false;
    private int seq;
    private Hashtable values = null;

    KeyInfo(int n, String string, int n2, boolean bl) {
        this.root = n;
        this.subkey = string;
        this.seq = n2;
        this.created = bl;
        this.values = new Hashtable(5);
        W32RegistryState.debug("KeyInfo created for: " + this.toString());
    }

    void addValue(String string, ValueAction valueAction) {
        Vector<ValueAction> vector = (Vector<ValueAction>)this.values.get(string);
        if (vector == null) {
            vector = new Vector<ValueAction>(5);
            this.values.put(string, vector);
            W32RegistryState.debug("Value name added: " + string);
        }
        vector.addElement(valueAction);
    }

    final void addValue(String string, String string2, int n, int n2) {
        this.addValue(string, new ValueAction(string2, n, n2));
    }

    void removeValueAt(String string, int n) {
        W32RegistryState.debug("remove value from " + string + " at:" + n);
        Vector vector = this.getValueActions(string);
        vector.removeElementAt(n);
        if (vector.size() == 0) {
            this.values.remove(string);
        }
    }

    final boolean valueNameExists(String string) {
        return this.values.containsKey(string);
    }

    final Enumeration names() {
        return this.values.keys();
    }

    final Vector getValueActions(String string) {
        Vector vector = (Vector)this.values.get(string);
        if (vector == null) {
            vector = new Vector(1);
        }
        return vector;
    }

    final boolean keyCreated() {
        return this.created;
    }

    final int getSequence() {
        return this.seq;
    }

    final int getRoot() {
        return this.root;
    }

    final String getKey() {
        return this.subkey;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(W32RegistryState.makeKeyName(this.root, this.subkey));
        stringBuffer.append("  seq: " + this.seq + ", created=" + this.created + ":\n");
        if (this.values.size() > 0) {
            Enumeration enumeration = this.names();
            if (enumeration == null) {
                return "Null value names list";
            }
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n    " + string + "=\n");
                Vector vector = (Vector)this.values.get(string);
                if (vector == null || vector.size() == 0) {
                    stringBuffer.append("        Null/empty values vector");
                    continue;
                }
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ValueAction valueAction = (ValueAction)vector.elementAt(i);
                    if (valueAction == null) {
                        stringBuffer.append("        Null value element");
                        continue;
                    }
                    stringBuffer.append("        " + valueAction.toString() + "\n");
                }
            }
        }
        return stringBuffer.toString();
    }
}

