/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.actions.EnvironmentVariableUpdate;
import com.installshield.product.service.product.ProductService;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.StringTokenizer;

public class SybaseEnvironmentVariableUpdate
extends EnvironmentVariableUpdate {
    static String path_separator = System.getProperty("path.separator");
    String saveEnv = null;
    String resolveName = null;
    String resolveValue = null;
    int level = 1;

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        SystemUtilService systemUtilService = null;
        if (this.getOperation() == 2 || this.getOperation() == 1) {
            try {
                this.resolveName = this.resolveString(this.getVariableName());
                this.resolveValue = this.resolveString(this.getVariableValue());
                this.logEvent(this, "dbg", "Attempt to remove : " + this.resolveName + "=" + this.resolveValue);
                systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                Win32RegistryService win32RegistryService = (Win32RegistryService)this.getService("win32RegistryService");
                String string = null;
                if (win32RegistryService.valueExists(4, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", this.resolveName)) {
                    string = win32RegistryService.getStringValue(4, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", this.resolveName, true);
                }
                if (string == null || string.trim().length() == 0) {
                    this.logEvent(this, "dbg", "... environment variable '" + this.resolveName + "' does not exist.");
                } else {
                    this.saveEnv = string;
                    String string2 = this.removeToken(string, this.resolveValue, path_separator);
                    systemUtilService.setEnvironmentVariable(this.resolveName, string2, this.level);
                    this.logEvent(this, "dbg", "... reset environment variable : " + this.resolveName + "=" + string2);
                }
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", "Failed to remove " + this.resolveName + "=" + this.resolveValue + " before prepend/append operation.");
                throw new ProductException(serviceException);
            }
        }
        try {
            super.install(productActionSupport);
        }
        catch (ProductException productException) {
            if ((this.getOperation() == 2 || this.getOperation() == 1) && this.saveEnv != null && this.resolveName != null && systemUtilService != null) {
                try {
                    systemUtilService.setEnvironmentVariable(this.resolveName, this.saveEnv, this.level);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                }
            }
            throw productException;
        }
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        try {
            ProductService productService = (ProductService)this.getServices().getService("productService");
            ProductTree productTree = productService.getSoftwareObjectTree("/product.xml");
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productTree.getRoot();
            int n = genericSoftwareObject.getInstallStatus();
            if (n == 2 && (this.getOperation() == 2 || this.getOperation() == 1) && this.saveEnv != null && this.resolveName != null) {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                systemUtilService.setEnvironmentVariable(this.resolveName, this.saveEnv, this.level);
            } else {
                super.uninstall(productActionSupport);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            super.build(productBuilderSupport);
            productBuilderSupport.putRequiredService("systemUtilService");
            productBuilderSupport.putRequiredService("productService");
            productBuilderSupport.putRequiredService("win32RegistryService");
            productBuilderSupport.putClass("com.installshield.product.actions.EnvironmentVariableUpdate");
            productBuilderSupport.putClass("com.installshield.product.actions.EnvironmentVariableUpdateExtra");
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", exception);
        }
    }

    private String removeToken(String string, String string2, String string3) {
        if (string.indexOf(string2) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string2)) continue;
            stringBuffer.append(string4 + string3);
        }
        int n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.deleteCharAt(n - 1);
        }
        return stringBuffer.toString();
    }
}

