/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.service.ServiceException;
import com.sybase.ismp.ase.lang.SISResourceGetter;
import com.sybase.ismp.ase.productbean.W32RegistryState;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;

public class W32RegistryAction
extends ProductAction {
    public static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$productbean$W32RegistryAction == null ? (class$com$sybase$ismp$ase$productbean$W32RegistryAction = W32RegistryAction.class$("com.sybase.ismp.ase.productbean.W32RegistryAction")) : class$com$sybase$ismp$ase$productbean$W32RegistryAction).getName());
    public static final int UNKNOWN = 0;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int BINARY = 3;
    public static final int UNDEF = 10;
    public static final int SET = 1;
    public static final int APPEND = 2;
    public static final int PREPEND = 3;
    public static final int DELETE_VALUE = 4;
    public static final int ADD_KEY = 5;
    public static final int DELETE_KEY = 6;
    public static final String DEFAULT_NAME = "(Default)";
    private static final int PATH_KEY_ROOT = 4;
    private static final String PATH_SUBKEY = "SOFTWARE\\SYBASE\\installer";
    private static final String PATH_VALUE_NAME = "RegistryStateFile";
    private int _keyRoot = 4;
    private String _key = "";
    private String _valueName = "(Default)";
    private String _value = "";
    private int _type = 1;
    private int _action = 1;
    private String _rslvdValueName;
    private String _rslvdValue;
    private String _rslvdKey;
    private boolean _installed = true;
    private static Win32RegistryService wrs;
    private W32RegistryState _state;
    private static final String PRODUCT_URL = "/product.xml";
    private static final char SLASH = '\\';
    private static final boolean ENABLED = true;
    static final String HEX = "0123456789ABCDEF";
    private static final String MAX_DWORD = "4294967295";
    static /* synthetic */ Class class$com$sybase$ismp$ase$productbean$W32RegistryAction;

    public W32RegistryAction() {
    }

    public W32RegistryAction(int n, String string, String string2, String string3, int n2, int n3) {
        this._keyRoot = n;
        this._key = string;
        this._valueName = string2;
        this._value = string3;
        this._type = n3;
        this._action = n2;
        this._rslvdKey = this._key;
        this._rslvdValueName = this._valueName.equals(DEFAULT_NAME) ? "" : this._valueName;
        this._rslvdValue = this._value;
    }

    public int getKeyRoot() {
        return this._keyRoot;
    }

    public void setKeyRoot(int n) {
        this._keyRoot = n;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String string) {
        this._key = string;
    }

    public String getValueName() {
        return this._valueName;
    }

    public void setValueName(String string) {
        this._valueName = string;
    }

    public int getAction() {
        return this._action;
    }

    public void setAction(int n) {
        this._action = n;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public boolean getInstalled() {
        return this._installed;
    }

    public boolean isInstalled() {
        return this.getInstalled();
    }

    public void setInstalled(boolean bl) {
        this._installed = bl;
    }

    public String getRslvdValueName() {
        String string = this._rslvdValueName == null || this._rslvdValueName.length() == 0 ? DEFAULT_NAME : this._rslvdValueName;
        return string;
    }

    public void setRslvdValueName(String string) {
    }

    public String getRslvdValue() {
        return this._rslvdValue;
    }

    public void setRslvdValue(String string) {
    }

    public String getRslvdKey() {
        return this._rslvdKey;
    }

    public void setRslvdKey(String string) {
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        productBuilderSupport.putRequiredService("win32RegistryService");
        productBuilderSupport.putRequiredService("logService");
        try {
            productBuilderSupport.putClass("com.sybase.ismp.ase.productbean.W32RegistryState");
            productBuilderSupport.putClass("com.sybase.ismp.ase.productbean.KeyInfo");
            productBuilderSupport.putClass("com.sybase.ismp.ase.productbean.ValueAction");
            productBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this, "err", SISResourceGetter.getString("reg_put_cls_fail") + ": " + iOException.getMessage());
        }
        this.resolveStrings();
        if (this._action != 4 && this._action != 6 && this._action != 5 && !W32RegistryAction.isValueValid(this._rslvdValue, this._type)) {
            productBuilderSupport.logEvent(this, "err", SISResourceGetter.getString("reg_bad_value") + ": " + this._rslvdValue);
        }
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        LOG.debug("Replacing now");
        this.install(productActionSupport);
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        LOG.debug("Registry Actions ENABLED: true");
        if (!this.getRegSvc()) {
            throw new ProductException(601, SISResourceGetter.getString("reg_no_reg_svc"));
        }
        this.resolveStrings();
        this._state = new W32RegistryState(this, this.getStatePath());
        LOG.debug("valueNameExists(" + this._rslvdKey + ", " + this._rslvdValueName + ")=" + W32RegistryAction.valueNameExists(wrs, this._keyRoot, this._rslvdKey, this._rslvdValueName));
        if ((this._action == 1 || this._action == 2 || this._action == 3) && W32RegistryAction.valueNameExists(wrs, this._keyRoot, this._rslvdKey, this._rslvdValueName)) {
            if (!this._state.keyExists(this._keyRoot, this._rslvdKey)) {
                LOG.debug("doing registry check");
                int n = this.getRegType();
                if (this._type != n && n != 10) {
                    this.actionError("reg_set_type_conflict", null);
                    LOG.debug("registry type: " + W32RegistryAction.typeToString(n));
                    return;
                }
            }
            this.logCurrentRegValue();
        } else {
            LOG.debug("NOT doing registry check");
        }
        this.checkKey();
        if (this._installed) {
            switch (this._action) {
                case 5: {
                    break;
                }
                case 6: {
                    this.processDeleteKey();
                    break;
                }
                case 1: {
                    this.processSetValue();
                    break;
                }
                case 4: {
                    this.processDeleteValue();
                    break;
                }
                case 2: 
                case 3: {
                    this.processConcatValue();
                }
            }
        }
    }

    private void checkKey() {
        try {
            this.traceKeyExists("checkKey full", this._keyRoot, this._rslvdKey);
            if (wrs.keyExists(this._keyRoot, this._rslvdKey) || this._action == 4 || this._action == 6) {
                this._state.installAction(this, null, false);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this._rslvdKey, "\\");
                String string = null;
                do {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = string == null ? string2 : string + '\\' + string2;
                    this.traceKeyExists("checkKey partial", this._keyRoot, string3);
                    if (!wrs.keyExists(this._keyRoot, string3)) {
                        wrs.createKey(this._keyRoot, string, string2);
                        LOG.debug("createKey(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + string + ", " + string2 + ")");
                        if (string3.equals(this._rslvdKey)) {
                            this._state.installAction(this, null, true);
                        } else {
                            this._state.installAction(this, string3, true);
                        }
                    }
                    string = string3;
                } while (stringTokenizer.hasMoreTokens());
            }
        }
        catch (ServiceException serviceException) {
            this.actionError("reg_create_key_fail", serviceException);
        }
    }

    public void processDeleteKey() {
        if (!this.getRegSvc()) {
            return;
        }
        try {
            if (wrs.keyExists(this._keyRoot, this._rslvdKey)) {
                String string;
                String string2;
                int n = this._rslvdKey.lastIndexOf(92);
                if (n > 0) {
                    string2 = this._rslvdKey.substring(0, n);
                    string = this._rslvdKey.substring(n + 1);
                } else {
                    string2 = null;
                    string = this._rslvdKey;
                }
                if (wrs.isKeyEmpty(this._keyRoot, this._rslvdKey)) {
                    wrs.deleteKey(this._keyRoot, string2, string, true);
                } else {
                    LOG.warn(this._rslvdKey + " still has values/sub-keys - so not deleted.");
                }
                LOG.debug("deleteKey(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + string2 + ", " + string + ", true)");
            }
        }
        catch (ServiceException serviceException) {
            this.actionError("reg_delete_key_fail", serviceException);
        }
    }

    private void processDeleteValue() {
        try {
            if (wrs.keyExists(this._keyRoot, this._rslvdKey) && W32RegistryAction.valueNameExists(wrs, this._keyRoot, this._rslvdKey, this._rslvdValueName)) {
                wrs.deleteValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, true);
                LOG.debug("deleteValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", true)");
            }
        }
        catch (ServiceException serviceException) {
            this.actionError("reg_delete_val_fail", serviceException);
        }
    }

    private void processSetValue() {
        try {
            switch (this._type) {
                case 1: {
                    wrs.setStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, this.isRegExpandSz(), this._rslvdValue);
                    LOG.debug("setStringValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + "," + this.isRegExpandSz() + "," + this._rslvdValue + ")");
                    break;
                }
                case 2: {
                    wrs.set32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, (int)W32RegistryAction.atol(this._rslvdValue));
                    LOG.debug("set32BitValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", " + this._rslvdValue + ")");
                    break;
                }
                case 3: {
                    byte[] byArray = W32RegistryAction.hexToBin(this._rslvdValue);
                    wrs.setBinaryValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, byArray);
                    LOG.debug("setBinaryValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", (" + W32RegistryAction.binToHex(byArray) + "))");
                }
            }
        }
        catch (ServiceException serviceException) {
            this.actionError("reg_set_val_fail", serviceException);
        }
    }

    private void processConcatValue() {
        block15: {
            boolean bl = this._action == 3;
            try {
                if (!W32RegistryAction.valueNameExists(wrs, this._keyRoot, this._rslvdKey, this._rslvdValueName)) {
                    this.processSetValue();
                    break block15;
                }
                switch (this._type) {
                    case 1: {
                        String string = wrs.getStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, true);
                        if (string.length() != 0 && string.indexOf(this._rslvdValue) != -1) break;
                        String string2 = bl ? this._rslvdValue + string : string + this._rslvdValue;
                        wrs.setStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, this.isRegExpandSz(), string2);
                        LOG.debug("setStringValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + "," + this.isRegExpandSz() + "," + string2 + ")");
                        break;
                    }
                    case 2: {
                        int n = wrs.get32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName);
                        wrs.set32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, n + (int)W32RegistryAction.atol(this._rslvdValue));
                        LOG.debug("set32BitValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", " + (n + (int)W32RegistryAction.atol(this._rslvdValue)) + ")");
                        break;
                    }
                    case 3: {
                        byte[] byArray = wrs.getBinaryValue(this._keyRoot, this._rslvdKey, this._rslvdValueName);
                        byte[] byArray2 = W32RegistryAction.hexToBin(this._rslvdValue);
                        byte[] byArray3 = new byte[byArray.length + byArray2.length];
                        int n = byArray.length;
                        int n2 = byArray2.length;
                        if (bl) {
                            int n3;
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray3[n3] = byArray2[n3];
                            }
                            for (int i = 0; i < n; ++i) {
                                byArray3[n3] = byArray[i];
                                ++n3;
                            }
                        } else {
                            int n4;
                            for (n4 = 0; n4 < n; ++n4) {
                                byArray3[n4] = byArray[n4];
                            }
                            for (int i = 0; i < n2; ++i) {
                                byArray3[n4] = byArray2[i];
                                ++n4;
                            }
                        }
                        wrs.setBinaryValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, byArray3);
                        LOG.debug("setBinaryValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", (" + W32RegistryAction.binToHex(byArray3) + "))");
                    }
                }
            }
            catch (ServiceException serviceException) {
                if (bl) {
                    this.actionError("reg_prepend_val_fail", serviceException);
                }
                this.actionError("reg_append_val_fail", serviceException);
            }
        }
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        LOG.debug("Registry Actions ENABLED: true");
        if (!this.getRegSvc()) {
            throw new ProductException(601, SISResourceGetter.getString("reg_no_reg_svc"));
        }
        this.resolveStrings();
        this._state = new W32RegistryState(this, this.getStatePath());
        this._state.uninstallAction(this);
    }

    public void processUninstall() {
        if (!this.getRegSvc()) {
            return;
        }
        switch (this._action) {
            case 1: 
            case 4: {
                this.processDeleteValue();
                break;
            }
            case 2: 
            case 3: {
                this.processUiConcatValue();
            }
        }
    }

    private void processUiConcatValue() {
        boolean bl = this._action == 3;
        try {
            if (wrs.keyExists(this._keyRoot, this._rslvdKey)) {
                switch (this._type) {
                    case 1: {
                        String string = wrs.getStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, true);
                        int n = string.indexOf(this._rslvdValue);
                        if (n < 0) break;
                        String string2 = string.substring(0, n) + string.substring(n + this._rslvdValue.length());
                        wrs.setStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, this.isRegExpandSz(), string2);
                        LOG.debug("setStringValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + "," + this.isRegExpandSz() + ", " + string2 + ")");
                        break;
                    }
                    case 2: {
                        int n = wrs.get32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName);
                        wrs.set32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, n - (int)W32RegistryAction.atol(this._rslvdValue));
                        LOG.debug("set32BitValue(" + W32RegistryAction.rootToString(this._keyRoot) + ", " + this._rslvdKey + ", " + this._rslvdValueName + ", " + (n - (int)W32RegistryAction.atol(this._rslvdValue)) + ")");
                        break;
                    }
                }
            }
        }
        catch (ServiceException serviceException) {
            if (bl) {
                this.actionError("reg_prepend_val_fail", serviceException);
            }
            this.actionError("reg_append_val_fail", serviceException);
        }
    }

    public static long atol(String string) {
        int n;
        if ((string = string.toUpperCase().trim()).startsWith("0X")) {
            try {
                return Integer.parseInt(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        if (n3 == 0) {
            return 0L;
        }
        if (string.charAt(n2) == '+') {
            n4 = 1;
            bl = true;
        } else if (string.charAt(n2) == '-') {
            n4 = 1;
            bl = false;
        }
        for (n = n4; n < n3 && Character.isDigit(string.charAt(n)); ++n) {
        }
        long l = 0L;
        try {
            l = Long.parseLong(string.substring(n4, n));
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        if (!bl) {
            l = -l;
        }
        return l;
    }

    public static byte[] hexToBin(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase());
        int n2 = stringTokenizer.countTokens();
        Vector<String> vector = new Vector<String>(10);
        for (n = 0; n < n2; ++n) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("0X")) {
                string2 = string2.substring(2);
            }
            while (string2.length() > 0) {
                int n3 = string2.length() % 2 != 0 ? 1 : 2;
                vector.addElement(string2.substring(0, n3));
                string2 = string2.substring(n3);
            }
        }
        n2 = vector.size();
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            char c;
            int n4;
            string = (String)vector.elementAt(n);
            if (string.length() == 1) {
                n4 = 48;
                c = string.charAt(0);
            } else {
                n4 = string.charAt(0);
                c = string.charAt(1);
            }
            byArray[n] = 0;
            byArray[n] = (byte)((HEX.indexOf(n4) << 4 | HEX.indexOf(c)) & 0xFF);
        }
        return byArray;
    }

    public static String binToHex(byte[] byArray) {
        int n = byArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            string = string + " " + HEX.charAt(n2 >> 4 & 0xF) + HEX.charAt(n2 & 0xF);
        }
        return string;
    }

    public static boolean isValidHex(String string) {
        if ((string = string.toUpperCase().trim()).startsWith("0X")) {
            string = string.substring(2);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (HEX.indexOf(string.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValueValid(String string, int n) {
        if ((string = string.toUpperCase().trim()).length() == 0) {
            return false;
        }
        if (n == 2) {
            if (string.charAt(0) == '-') {
                return false;
            }
            if (string.length() <= 10 && W32RegistryAction.isValidHex(string)) {
                return true;
            }
            while (string.length() > 1 && string.charAt(0) == '0') {
                string = string.substring(1);
            }
            if (string.length() > MAX_DWORD.length()) {
                return false;
            }
            if (string.compareTo(MAX_DWORD) > 0) {
                return false;
            }
        } else if (n == 3) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = stringTokenizer.countTokens();
            for (int i = 0; i < n2; ++i) {
                if (W32RegistryAction.isValidHex(stringTokenizer.nextToken())) continue;
                return false;
            }
        }
        return true;
    }

    public void actionError(String string, Exception exception) {
        String string2 = string == null || string.length() == 0 ? "" : SISResourceGetter.getString(string);
        string2 = string2 + "\n" + this.propsToString();
        if (exception != null) {
            string2 = string2 + "\n\n\t" + exception.getMessage();
        }
        LOG.error(string2);
    }

    public void Error(String string, Exception exception) {
        String string2 = string == null || string.length() == 0 ? "" : string + "\n\t" + "\n\n\t" + exception.getMessage();
        LOG.error(string2);
    }

    public void propTrace(String string) {
        LOG.info((string == null || string.length() == 0 ? "" : string) + "\n" + this.propsToString());
    }

    private void traceKeyExists(String string, int n, String string2) {
        boolean bl;
        string = string == null ? "" : "(" + string + ")";
        try {
            bl = wrs.keyExists(n, string2);
        }
        catch (ServiceException serviceException) {
            LOG.error("reg_key_exists_fail");
            bl = false;
        }
        LOG.debug(string + "wrs.keyExists(" + W32RegistryAction.rootToString(n) + ", " + string2 + ") = " + bl);
    }

    public static String rootToString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "HKEY_CLASSES_ROOT";
                break;
            }
            case 3: {
                string = "HKEY_CURRENT_USER";
                break;
            }
            case 4: {
                string = "HKEY_LOCAL_MACHINE";
                break;
            }
            case 5: {
                string = "HKEY_USERS";
                break;
            }
            case 2: {
                string = "HKEY_CURRENT_CONFIG";
            }
        }
        return string;
    }

    public static int stringToRoot(String string) {
        if (string.compareTo("HKEY_CLASSES_ROOT") == 0) {
            return 1;
        }
        if (string.compareTo("HKEY_CURRENT_USER") == 0) {
            return 3;
        }
        if (string.compareTo("HKEY_LOCAL_MACHINE") == 0) {
            return 4;
        }
        if (string.compareTo("HKEY_USERS") == 0) {
            return 5;
        }
        if (string.compareTo("HKEY_CURRENT_CONFIG") == 0) {
            return 2;
        }
        return 0;
    }

    private String propsToString() {
        String string = this._rslvdValueName == null || this._rslvdValueName.length() == 0 ? DEFAULT_NAME : this._rslvdValueName;
        String string2 = "\t  " + SISResourceGetter.getString("reg_lbl_keyroot") + ": " + W32RegistryAction.rootToString(this._keyRoot) + "\n\t" + "\t       " + SISResourceGetter.getString("reg_lbl_key") + ": " + this._rslvdKey + "\n\t" + "\t" + SISResourceGetter.getString("reg_lbl_val_name") + ": " + string + "\n\t" + "\t     " + SISResourceGetter.getString("reg_lbl_val") + ": " + this._rslvdValue + "\n\t" + "\t      " + SISResourceGetter.getString("reg_lbl_type") + ": " + W32RegistryAction.typeToString(this._type) + "\n\t" + "\t    " + SISResourceGetter.getString("reg_lbl_action") + ": " + W32RegistryAction.actionToString(this._action);
        return string2;
    }

    public static String actionToString(int n) {
        switch (n) {
            case 5: {
                return SISResourceGetter.getString("reg_action_add_key");
            }
            case 6: {
                return SISResourceGetter.getString("reg_action_del_key");
            }
            case 4: {
                return SISResourceGetter.getString("reg_action_del_val");
            }
            case 1: {
                return SISResourceGetter.getString("reg_action_set_val");
            }
            case 3: {
                return SISResourceGetter.getString("reg_action_prep_val");
            }
            case 2: {
                return SISResourceGetter.getString("reg_action_app_val");
            }
        }
        return "?";
    }

    public static String typeToString(int n) {
        switch (n) {
            case 1: {
                return SISResourceGetter.getString("reg_type_string");
            }
            case 2: {
                return SISResourceGetter.getString("reg_type_int");
            }
            case 3: {
                return SISResourceGetter.getString("reg_type_bin");
            }
        }
        return "?";
    }

    private void resolveStrings() {
        this._rslvdValueName = this.resolveString(this._valueName);
        if (this._rslvdValueName != null && this._rslvdValueName.equalsIgnoreCase(DEFAULT_NAME)) {
            this._rslvdValueName = "";
        }
        this._rslvdValue = this.resolveString(this._value);
        this._rslvdKey = this.resolveString(this._key).replace('/', '\\');
    }

    public final String rslvString(String string) {
        return this.resolveString(string);
    }

    public static boolean valueNameExists(Win32RegistryService win32RegistryService, int n, String string, String string2) {
        boolean bl = true;
        try {
            bl = win32RegistryService.valueExists(n, string, string2);
        }
        catch (ServiceException serviceException) {
            bl = false;
        }
        return bl;
    }

    public int getRegType() {
        int n = 0;
        try {
            switch (wrs.getValueType(this._keyRoot, this._rslvdKey, this._rslvdValueName)) {
                case 1: 
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 2;
                }
            }
        }
        catch (ServiceException serviceException) {
            n = 10;
            LOG.debug("Registry get data type failed: \n" + serviceException.getMessage());
        }
        LOG.debug("getRegType = " + n);
        return n;
    }

    public boolean isRegExpandSz() {
        try {
            if (wrs.getValueType(this._keyRoot, this._rslvdKey, this._rslvdValueName) == 2) {
                return true;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return false;
    }

    private void logCurrentRegValue() {
        try {
            switch (this._type) {
                case 1: {
                    String string = wrs.getStringValue(this._keyRoot, this._rslvdKey, this._rslvdValueName, true);
                    LOG.info("existing registry value\n       Key root: " + W32RegistryAction.rootToString(this._keyRoot) + "\n            Key: " + this._rslvdKey + "\n     Value Name: " + this._rslvdValueName + "\n  Current value: " + string);
                    break;
                }
                case 2: {
                    int n = wrs.get32BitValue(this._keyRoot, this._rslvdKey, this._rslvdValueName);
                    LOG.info("existing registry value\n       Key root: " + W32RegistryAction.rootToString(this._keyRoot) + "\n            Key: " + this._rslvdKey + "\n     Value Name: " + this._rslvdValueName + "\n  Current value: " + n);
                    break;
                }
                case 3: {
                    byte[] byArray = wrs.getBinaryValue(this._keyRoot, this._rslvdKey, this._rslvdValueName);
                    String string = W32RegistryAction.binToHex(byArray);
                    String string2 = W32RegistryAction.binToHex(W32RegistryAction.hexToBin(this._rslvdValue));
                    LOG.info("existing registry value\n       Key root: " + W32RegistryAction.rootToString(this._keyRoot) + "\n            Key: " + this._rslvdKey + "\n     Value Name: " + this._rslvdValueName + "\n  Current value: " + string);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.actionError("reg_compare_value_fail", serviceException);
        }
    }

    public boolean equals(W32RegistryAction w32RegistryAction) {
        if (!this.keyEquals(w32RegistryAction)) {
            return false;
        }
        if (this._action != w32RegistryAction.getAction()) {
            return false;
        }
        if (this._type != w32RegistryAction.getType()) {
            return false;
        }
        if (!this._rslvdValueName.equals(w32RegistryAction.getValueName())) {
            return false;
        }
        return this._rslvdValue.equals(w32RegistryAction.getValue());
    }

    public boolean keyEquals(W32RegistryAction w32RegistryAction) {
        if (this._keyRoot != w32RegistryAction.getKeyRoot()) {
            return false;
        }
        return this._rslvdKey.equals(w32RegistryAction.getKey());
    }

    private boolean getRegSvc() {
        if (wrs == null) {
            try {
                wrs = (Win32RegistryService)this.getService("win32RegistryService");
            }
            catch (ServiceException serviceException) {
                this.actionError("reg_no_reg_svc", serviceException);
                return false;
            }
        }
        return true;
    }

    private String getStatePath() {
        String string = "";
        string = this.resolveString("$D(os_main)");
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

