/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.sybase.ismp.ase.lang.SISResourceGetter;
import com.sybase.ismp.ase.productbean.KeyInfo;
import com.sybase.ismp.ase.productbean.ValueAction;
import com.sybase.ismp.ase.productbean.W32RegistryAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;

public class W32RegistryState {
    private Hashtable _actions = null;
    private static Category _log = Category.getInstance("W32RegistryState");
    private static final String REGSTATEFILE = "W32RegistryState.dat";
    private W32RegistryAction _regAction;
    private int _maxSeqNbr = 0;
    private static final String SEQNBRKEY = "HighestSequenceNumber";
    private String _fileDir;
    private boolean _install;

    public W32RegistryState(W32RegistryAction w32RegistryAction, String string) {
        this._regAction = w32RegistryAction;
        _log.debug("State file in: " + string);
        this._fileDir = string;
    }

    private void loadState() {
        File file = new File(this._fileDir, REGSTATEFILE);
        String string = SISResourceGetter.getString("reg_state_load_tag");
        if (this._actions != null) {
            return;
        }
        if (file.exists()) {
            Integer n;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this._actions = (Hashtable)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._regAction.Error(string, classNotFoundException);
            }
            catch (InvalidClassException invalidClassException) {
                this._regAction.Error(string, invalidClassException);
            }
            catch (StreamCorruptedException streamCorruptedException) {
                this._regAction.Error(string, streamCorruptedException);
            }
            catch (OptionalDataException optionalDataException) {
                this._regAction.Error(string, optionalDataException);
            }
            catch (IOException iOException) {
                this._regAction.Error(string, iOException);
            }
            if (this._actions == null) {
                _log.debug("Variable '_actions' is null after reading : " + file.getAbsolutePath());
                this._actions = new Hashtable();
            }
            if ((n = (Integer)this._actions.get(SEQNBRKEY)) != null) {
                this._maxSeqNbr = n;
                this._actions.remove(SEQNBRKEY);
            }
        } else {
            this._actions = new Hashtable(20);
        }
        this.dump("Loaded State");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        if (!this._install) {
            this.processRegistryDeletes();
        }
        try {
            this.saveState();
        }
        finally {
            super.finalize();
        }
    }

    private void saveState() {
        String string = SISResourceGetter.getString("reg_state_save_tag");
        if (this._actions != null) {
            File file = new File(this._fileDir);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            File file2 = new File(this._fileDir, REGSTATEFILE);
            this.dump("Saved State");
            this._actions.put(SEQNBRKEY, new Integer(this._maxSeqNbr));
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this._actions);
                objectOutputStream.close();
                fileOutputStream.close();
                this._actions = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._regAction.Error(string, fileNotFoundException);
            }
            catch (InvalidClassException invalidClassException) {
                this._regAction.Error(string, invalidClassException);
            }
            catch (NotSerializableException notSerializableException) {
                this._regAction.Error(string, notSerializableException);
            }
            catch (IOException iOException) {
                this._regAction.Error(string, iOException);
            }
            this._actions = null;
        }
    }

    public void installAction(W32RegistryAction w32RegistryAction, String string, boolean bl) {
        int n = w32RegistryAction.getKeyRoot();
        String string2 = string == null ? w32RegistryAction.getRslvdKey() : string;
        String string3 = w32RegistryAction.getRslvdValueName();
        String string4 = W32RegistryState.makeKeyName(n, string2);
        int n2 = w32RegistryAction.getAction();
        int n3 = w32RegistryAction.getType();
        String string5 = w32RegistryAction.getRslvdValue();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.loadState();
        w32RegistryAction.propTrace("installAction on:");
        this._install = true;
        if (n2 == 6) {
            if (this._actions.containsKey(string4)) {
                this._actions.remove(string4);
                this.saveState();
                return;
            }
            _log.debug("Key not present, not removed");
        }
        if (n2 == 5) {
            if (!this._actions.containsKey(string4)) {
                this._actions.put(string4, new KeyInfo(n, string2, this._maxSeqNbr++, true));
                this.saveState();
                return;
            }
            _log.debug("state: key already defined, can't add");
        }
        if (this.keyNameExists(n, string2, string3)) {
            this.sanitize(w32RegistryAction);
        } else {
            KeyInfo keyInfo = (KeyInfo)this._actions.get(string4);
            if (keyInfo == null) {
                keyInfo = new KeyInfo(n, string2, this._maxSeqNbr++, bl);
                this._actions.put(string4, keyInfo);
            }
            if (string == null) {
                keyInfo.addValue(string3, string5, n2, n3);
            }
        }
        this.saveState();
    }

    public void uninstallAction(W32RegistryAction w32RegistryAction) {
        int n = w32RegistryAction.getKeyRoot();
        String string = w32RegistryAction.getRslvdKey();
        String string2 = w32RegistryAction.getRslvdValue();
        String string3 = w32RegistryAction.getRslvdValueName();
        int n2 = w32RegistryAction.getAction();
        String string4 = W32RegistryState.makeKeyName(n, string);
        w32RegistryAction.propTrace("uninstallAction on:");
        if (string == null || string.length() == 0) {
            _log.warn("Root key cannot be removed, exiting\n" + W32RegistryAction.rootToString(n));
            return;
        }
        if (!w32RegistryAction.isInstalled()) {
            w32RegistryAction.propTrace("Action not installed, exiting");
            return;
        }
        this.loadState();
        KeyInfo keyInfo = (KeyInfo)this._actions.get(string4);
        if (keyInfo == null) {
            w32RegistryAction.actionError("reg_state_not_in_state", null);
            return;
        }
        this._install = false;
        Vector vector = keyInfo.getValueActions(string3);
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            ValueAction valueAction = (ValueAction)vector.elementAt(i);
            if (!string2.equals(valueAction.getValue())) continue;
            if (n2 == 1) {
                valueAction.decCount();
            }
            if (n2 != 2 && n2 != 3) continue;
            valueAction.setCount(0);
        }
        this.processRegistryDeletes();
        this.saveState();
    }

    public final boolean keyNameExists(int n, String string, String string2) {
        boolean bl = this.getKeyNameValues(n, string, string2) != null;
        _log.debug("keyNameExists: " + bl);
        return bl;
    }

    public final boolean keyExists(int n, String string) {
        this.loadState();
        String string2 = W32RegistryState.makeKeyName(n, string);
        boolean bl = this._actions.containsKey(string2);
        _log.debug("_state.keyExists(" + string2 + ")=" + bl);
        return bl;
    }

    public Vector getKeyNameValues(int n, String string, String string2) {
        this.loadState();
        String string3 = W32RegistryState.makeKeyName(n, string);
        KeyInfo keyInfo = (KeyInfo)this._actions.get(string3);
        if (keyInfo != null && keyInfo.valueNameExists(string2)) {
            return keyInfo.getValueActions(string2);
        }
        return null;
    }

    protected static final String makeKeyName(int n, String string) {
        return "\\" + W32RegistryAction.rootToString(n) + "\\" + string;
    }

    public void dump(String string) {
        if (_log.isDebugEnabled()) {
            if (string != null && string.length() > 0) {
                _log.debug(string);
                _log.debug("_maxSeqNbr = " + this._maxSeqNbr);
            }
            if (this._actions == null || this._actions.size() == 0) {
                _log.debug("Hashtable is empty");
            } else {
                Enumeration enumeration = this._actions.elements();
                while (enumeration.hasMoreElements()) {
                    KeyInfo keyInfo = (KeyInfo)enumeration.nextElement();
                    _log.debug(keyInfo.toString());
                }
            }
        }
    }

    private void processRegistryDeletes() {
        String string;
        int n;
        W32RegistryAction w32RegistryAction;
        int n2;
        Vector vector = new Vector(this._actions.size());
        Vector<W32RegistryAction> vector2 = new Vector<W32RegistryAction>(5);
        Vector<W32RegistryAction> vector3 = new Vector<W32RegistryAction>(5);
        Enumeration enumeration = this._actions.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            KeyInfo keyInfo = (KeyInfo)this._actions.get(string2);
            n2 = string2.indexOf(92, 1);
            int n3 = W32RegistryAction.stringToRoot(string2.substring(1, n2));
            String string3 = string2.substring(n2 + 1);
            Enumeration enumeration2 = keyInfo.names();
            if (keyInfo.keyCreated()) {
                _log.debug("Add '" + string2 + "' to creates");
                this.insertCreate(vector, keyInfo);
            }
            if (!enumeration2.hasMoreElements() && keyInfo.keyCreated() && !vector2.contains(w32RegistryAction = new W32RegistryAction(n3, string3, "", "", 6, 0))) {
                vector2.add(w32RegistryAction);
                _log.debug("Added '" + string2 + "' to psbleDeletes");
                continue;
            }
            while (enumeration2.hasMoreElements()) {
                String string4 = (String)enumeration2.nextElement();
                Vector vector4 = keyInfo.getValueActions(string4);
                n = vector4.size();
                if (n == 0) {
                    w32RegistryAction = new W32RegistryAction(n3, string3, string4, "", 4, 0);
                    w32RegistryAction.processUninstall();
                    if (vector2.contains(w32RegistryAction) || !keyInfo.keyCreated()) continue;
                    vector2.add(w32RegistryAction);
                    _log.debug("Added '" + string2 + ":" + string4 + "' to psbleDeletes");
                    continue;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    int n4;
                    ValueAction valueAction = (ValueAction)vector4.elementAt(n2);
                    w32RegistryAction = new W32RegistryAction(n3, string3, string4, valueAction.getValue(), valueAction.getAction(), valueAction.getType());
                    if (valueAction.getCount() == 0) {
                        w32RegistryAction.processUninstall();
                        keyInfo.removeValueAt(string4, n2);
                        n = vector4.size();
                        if (vector2.contains(w32RegistryAction) || !keyInfo.keyCreated()) continue;
                        vector2.add(w32RegistryAction);
                        _log.debug("Added '" + w32RegistryAction.getKey() + "' to psbleDeletes");
                        continue;
                    }
                    boolean bl = false;
                    for (n4 = 0; n4 < vector2.size(); ++n4) {
                        W32RegistryAction w32RegistryAction2 = (W32RegistryAction)vector2.elementAt(n4);
                        if (!w32RegistryAction.keyEquals(w32RegistryAction2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        vector2.removeElementAt(n4);
                    }
                    if (vector3.contains(w32RegistryAction)) continue;
                    vector3.add(w32RegistryAction);
                    _log.debug("Added '" + w32RegistryAction.getKey() + "' to keep list");
                }
            }
        }
        n = vector.size();
        if (_log.isDebugEnabled()) {
            string = "Create table dump:";
            for (n2 = 0; n2 < n; ++n2) {
                int n5 = ((KeyInfo)vector.elementAt(n2)).getSequence();
                string = string + " " + n5;
            }
            _log.debug(string);
        }
        if (vector2.size() > 0) {
            boolean bl;
            Vector<KeyInfo> vector5 = new Vector<KeyInfo>(5);
            Vector<KeyInfo> vector6 = new Vector<KeyInfo>(5);
            n = vector.size();
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                KeyInfo keyInfo = (KeyInfo)vector.elementAt(n2);
                String string5 = W32RegistryState.makeKeyName(keyInfo.getRoot(), keyInfo.getKey());
                bl = false;
                if (this.startsWith(vector2, string5)) {
                    bl = true;
                }
                if (this.startsWith(vector3, string5)) {
                    bl = false;
                }
                if (bl) {
                    vector5.addElement(keyInfo);
                    _log.debug("Added to finalDeletes: " + keyInfo.getKey());
                    continue;
                }
                vector6.addElement(keyInfo);
                _log.debug("Added to finalKeeps: " + keyInfo.getKey());
            }
            for (n2 = vector5.size() - 1; n2 >= 0; --n2) {
                bl = true;
                KeyInfo keyInfo = (KeyInfo)vector5.elementAt(n2);
                string = W32RegistryState.makeKeyName(keyInfo.getRoot(), keyInfo.getKey());
                if (this.startsWith(vector6, string)) {
                    bl = false;
                    break;
                }
                if (!bl) continue;
                w32RegistryAction = new W32RegistryAction(keyInfo.getRoot(), keyInfo.getKey(), "", "", 6, 0);
                w32RegistryAction.processDeleteKey();
                String string6 = W32RegistryState.makeKeyName(keyInfo.getRoot(), keyInfo.getKey());
                this._actions.remove(string6);
            }
        }
    }

    private void insertCreate(Vector vector, KeyInfo keyInfo) {
        if (vector.contains(keyInfo)) {
            return;
        }
        int n = keyInfo.getSequence();
        int n2 = 0;
        int n3 = vector.size();
        vector.addElement(keyInfo);
        if (n3 > 0) {
            for (int i = n3; i >= 0; --i) {
                KeyInfo keyInfo2 = (KeyInfo)vector.elementAt(i);
                if (n >= keyInfo2.getSequence()) {
                    n2 = i;
                    break;
                }
                vector.setElementAt(keyInfo2, i + 1);
            }
            vector.setElementAt(keyInfo, n2);
        }
    }

    private boolean startsWith(Vector vector, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            String string2;
            Object e = vector.elementAt(i);
            if (e instanceof KeyInfo) {
                KeyInfo keyInfo = (KeyInfo)vector.elementAt(i);
                string2 = W32RegistryState.makeKeyName(keyInfo.getRoot(), keyInfo.getKey());
            } else {
                W32RegistryAction w32RegistryAction = (W32RegistryAction)vector.elementAt(i);
                string2 = W32RegistryState.makeKeyName(w32RegistryAction.getKeyRoot(), w32RegistryAction.getKey());
            }
            if (string2.length() == 0 || !string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void sanitize(W32RegistryAction w32RegistryAction) {
        int n = w32RegistryAction.getKeyRoot();
        String string = w32RegistryAction.getRslvdKey();
        String string2 = w32RegistryAction.getRslvdValueName();
        int n2 = w32RegistryAction.getAction();
        String string3 = w32RegistryAction.getRslvdValue();
        int n3 = w32RegistryAction.getType();
        Vector vector = this.getKeyNameValues(n, string, string2);
        int n4 = vector.size();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n4; ++i) {
            ValueAction valueAction = (ValueAction)vector.elementAt(i);
            int n5 = valueAction.getAction();
            int n6 = valueAction.getType();
            if (n3 != n6) {
                w32RegistryAction.actionError("reg_state_type_conflict", null);
                _log.error("state type: " + W32RegistryAction.typeToString(n6));
                w32RegistryAction.setInstalled(false);
                return;
            }
            int n7 = w32RegistryAction.getRegType();
            if (n7 != n3 && n7 != 10) {
                w32RegistryAction.actionError("reg_state_type_conflict", null);
                _log.error("registry type: " + W32RegistryAction.typeToString(n7));
                w32RegistryAction.setInstalled(false);
                return;
            }
            if (n5 == 1) {
                bl2 = true;
            } else if (n5 == 4) {
                bl3 = true;
            }
            if (n2 == 4 || !valueAction.getValue().equals(string3)) continue;
            bl = true;
            if (n2 == n5 || n2 == 2 && n5 == 3 || n2 == 3 && n5 == 2) {
                valueAction.incCount();
                break;
            }
            w32RegistryAction.actionError("reg_state_action_conflict", null);
            _log.error("htAction: " + W32RegistryAction.actionToString(n5));
            w32RegistryAction.setInstalled(false);
            return;
        }
        if (!bl) {
            if (n2 == 1 && bl3 || n2 == 4 && bl2) {
                w32RegistryAction.actionError("reg_state_value_conflict", null);
                _log.debug("haveSet: " + bl2 + "   haveDel: " + bl3);
                w32RegistryAction.setInstalled(false);
                return;
            }
            String string4 = W32RegistryState.makeKeyName(n, string);
            KeyInfo keyInfo = (KeyInfo)this._actions.get(string4);
            keyInfo.addValue(string2, string3, n2, n3);
            _log.debug("new value: " + string2 + "/" + string3 + "/" + n2 + "/" + n3);
        }
    }

    static final void debug(String string) {
        _log.debug(string);
    }

    public static void main(String[] stringArray) {
        Integer n;
        if (stringArray.length != 1) {
            System.out.println("Need directory for state file");
            return;
        }
        File file = new File(stringArray[0], REGSTATEFILE);
        int n2 = 0;
        Hashtable hashtable = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("State file load failure\n\t" + exception.getMessage());
        }
        if (hashtable == null) {
            _log.debug("_actions is null after reading : " + file.getAbsolutePath());
            hashtable = new Hashtable();
        }
        if ((n = (Integer)hashtable.get(SEQNBRKEY)) != null) {
            n2 = n;
            hashtable.remove(SEQNBRKEY);
        }
        System.out.println("");
        System.out.println("<------------------------------------>");
        System.out.println("State file dump");
        System.out.println("_maxSeqNbr = " + n2);
        System.out.println("");
        if (hashtable == null || hashtable.size() == 0) {
            System.out.println("Hashtable is empty");
        } else {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                KeyInfo keyInfo = (KeyInfo)enumeration.nextElement();
                System.out.println(keyInfo.toString());
                System.out.println("");
            }
        }
        System.out.println(">------------------------------------<");
        System.out.println("");
    }
}

