/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.StringTokenizer;

public class WindowUnsetEnvironmentVariable
extends ProductAction {
    String name = "";
    String value = "";
    static String path_separator = System.getProperty("path.separator");

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (this.name.length() != 0 && this.value.length() != 0) {
            try {
                String string = this.resolveString(this.getVariableName());
                String string2 = this.resolveString(this.getVariableValue());
                this.logEvent(this, "dbg", "Attempt to unset : " + string + "=" + string2);
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                String string3 = systemUtilService.getEnvironmentVariable(string);
                if (string3 == null || string3.trim().length() == 0) {
                    this.logEvent(this, "dbg", "... environment variable '" + string + "' does not exist.");
                    return;
                }
                if (string3.equals(string2)) {
                    this.logEvent(this, "dbg", "... delete environment variable : " + string + "=" + string2);
                    systemUtilService.deleteEnvironmentVariable(string, 1);
                } else {
                    String string4 = this.removeToken(string3, string2, path_separator);
                    this.logEvent(this, "dbg", "... reset environment variable : " + string + "=" + string4);
                    systemUtilService.setEnvironmentVariable(string, string4, 1);
                }
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.name.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Variable Name field can not be null");
            productBuilderSupport.setBuildCanceled(true);
        }
        if (this.value.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Variable Value can not be null");
            productBuilderSupport.setBuildCanceled(true);
        }
        productBuilderSupport.putRequiredService("systemUtilService");
    }

    private String removeToken(String string, String string2, String string3) {
        if (string.indexOf(string2) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string2)) continue;
            stringBuffer.append(string4 + string3);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void setVariableName(String string) {
        this.name = string;
    }

    public String getVariableName() {
        return this.name;
    }

    public void setVariableValue(String string) {
        this.value = string;
    }

    public String getVariableValue() {
        return this.value;
    }
}

