/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.productbean.condition;

import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.util.FileUtils;
import com.installshield.util.StringResolverUtil;
import com.sybase.ismp.ase.OSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class FileCheckSumCondition
extends ProductBeanCondition {
    String file = "";
    String[] templateFiles = new String[0];
    boolean returnStatusFileNotExist = false;
    long[] fileCRC = new long[0];

    public boolean evaluateTrueCondition() {
        boolean bl = false;
        try {
            int n;
            if (this.fileCRC.length == 0) {
                this.logEvent(this, "dbg", "templateFiles property is empty -  return true");
                return true;
            }
            String string = this.getProductBean().getServices().resolveString(this.file);
            File file = new File(string);
            if (!file.exists()) {
                this.logEvent(this, "dbg", string + " not exist - return " + String.valueOf(this.returnStatusFileNotExist));
                return this.returnStatusFileNotExist;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = FileUtils.readFully(fileInputStream);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            long l = cRC32.getValue();
            for (n = 0; n < this.fileCRC.length; ++n) {
                if (this.fileCRC[n] != l) continue;
                bl = true;
                break;
            }
            if (OSUtil.isOperatingSystemOk(0)) {
                n = 13;
                byte by = 10;
                int n2 = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != n || byArray[i + 1] != by) continue;
                    ++n2;
                }
                byte[] byArray2 = new byte[byArray.length - n2];
                int n3 = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray2[n3++] = byArray[i] == n && byArray[i + 1] == by ? byArray[++i] : byArray[i];
                }
                CRC32 cRC322 = new CRC32();
                cRC322.update(byArray2);
                long l2 = cRC322.getValue();
                for (int i = 0; i < this.fileCRC.length; ++i) {
                    if (this.fileCRC[i] != l2) continue;
                    bl = true;
                    break;
                }
            }
            this.logEvent(this, "dbg", this.getProductBean().getBeanId() + " condition bean return = " + String.valueOf(bl));
            fileInputStream.close();
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
        return bl;
    }

    public String defaultName() {
        return "File Check Sum Condition";
    }

    public String describe() {
        String string = this.getEvaluate() == 1 ? this.file + " must match one of the checksum." : this.file + " doesn't match any of the checksum.";
        return string;
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            if (this.templateFiles.length == 0) {
                productBuilderSupport.logEvent(this, "wrn", "templateFiles property is empty. Bean ID '" + this.getProductBean().getBeanId() + "' will always return true");
                return;
            }
            productBuilderSupport.putClass("com.installshield.product.conditions.FileExistsProductBeanCondition");
            this.fileCRC = new long[this.templateFiles.length];
            for (int i = 0; i < this.templateFiles.length; ++i) {
                String string = StringResolverUtil.resolveString(this.templateFiles[i], "templateFiles", productBuilderSupport, this, this.getProductBean().getServices());
                if (string == null) {
                    productBuilderSupport.logEvent(this, "err", "Can't calculate CRC, failed to resolve file '" + this.templateFiles[i] + "'.");
                    productBuilderSupport.setBuildCanceled(true);
                    return;
                }
                File file = new File(string);
                if (!file.exists()) {
                    productBuilderSupport.logEvent(this, "err", "Can't calculate CRC, file " + string + " not exist.");
                    productBuilderSupport.setBuildCanceled(true);
                    return;
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = FileUtils.readFully(fileInputStream);
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                productBuilderSupport.logEvent(this, "msg1", "CRC : " + string + " = " + String.valueOf(cRC32.getValue()));
                this.fileCRC[i] = cRC32.getValue();
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this, "err", iOException);
            productBuilderSupport.setBuildCanceled(true);
        }
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setReturnStatusFileNotExist(boolean bl) {
        this.returnStatusFileNotExist = bl;
    }

    public boolean getReturnStatusFileNotExist() {
        return this.returnStatusFileNotExist;
    }

    public void setTemplateFiles(String[] stringArray) {
        this.templateFiles = stringArray;
    }

    public String[] getTemplateFiles() {
        return this.templateFiles;
    }

    public void setFileCrc(long[] lArray) {
        this.fileCRC = lArray;
    }

    public long[] getFileCrc() {
        return this.fileCRC;
    }
}

