/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.service.product.ProductService;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.WizardTreeIterator;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.SybaseDestinationPanel;

public class CheckInstalledProduct
extends WizardAction {
    public static String NEW_LINE = System.getProperty("line.separator");
    public static final int EQUAL = 0;
    public static final int NEWER = 1;
    public static final int NEWER_EQUAL = 2;
    String name = "";
    SoftwareObjectKey sok = new SoftwareObjectKey();
    int operator = 0;
    boolean override = false;
    boolean isSilent = false;

    public CheckInstalledProduct() {
        this.sok.setUID("");
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        if (this.override) {
            return;
        }
        try {
            Object object;
            Object[] objectArray;
            this.isSilent = wizardBeanEvent.getUserInterface() == null;
            String string = "";
            String string2 = this.resolveString("$P(installLocation)");
            RegistryService registryService = (RegistryService)this.getService("registryService");
            ProductService productService = (ProductService)this.getServices().getService("productService");
            ProductTree productTree = productService.getSoftwareObjectTree("/product.xml");
            String string3 = productTree.getRoot().getDisplayName();
            SoftwareObject softwareObject = registryService.getSoftwareObject(this.sok.getUID(), string2);
            if (softwareObject != null) {
                objectArray = this.sok.getVersion();
                if (objectArray.getMajor().length() == 0 && objectArray.getMinor().length() == 0 && objectArray.getMaintenance().length() == 0 && objectArray.getUpdate().length() == 0) {
                    return;
                }
                object = softwareObject.getKey();
                SoftwareVersion softwareVersion = ((SoftwareObjectKey)object).getVersion();
                this.logEvent(this, "dbg", string2 + " has version " + softwareVersion.getMajor() + "." + softwareVersion.getMinor() + "." + softwareVersion.getMaintenance() + "." + softwareVersion.getUpdate() + " " + this.name);
                int n = ((SoftwareObjectKey)object).compareTo(this.sok);
                Object[] objectArray2 = new Object[]{this.sok.getVersion().getFormatted(), this.name, string2, string3};
                if (this.operator == 0) {
                    if (n != 0) {
                        this.logEvent(this, "err", "Installed product doesn't have same version");
                        string = ASEResourceGetter.getAltFormatted("found_no_equal_product", objectArray2);
                    }
                } else if (this.operator == 1) {
                    if (n <= 0) {
                        this.logEvent(this, "err", "Installed product has older version");
                        string = ASEResourceGetter.getAltFormatted("found_no_newer_product", objectArray2);
                    }
                } else if (this.operator == 2 && n < 0) {
                    this.logEvent(this, "err", "Installed product has older version");
                    string = ASEResourceGetter.getAltFormatted("found_no_newer_equal_product", objectArray2);
                }
            } else {
                this.logEvent(this, "err", "Installed product not found.");
                objectArray = new Object[]{this.name, string2, string3};
                string = ASEResourceGetter.getAltFormatted("found_no_match_product", objectArray);
            }
            if (string.length() != 0) {
                if (this.isSilent) {
                    objectArray = new Object[]{"-W " + this.getBeanId() + ".continueWithoutProduct=True", string3, this.name};
                    object = ASEResourceGetter.getAltFormatted("override_silent_install", objectArray);
                    string = string + NEW_LINE + NEW_LINE + (String)object;
                    System.err.println(string);
                    this.getWizard().exit(-1);
                } else if (!this.prompt(string = string + NEW_LINE + NEW_LINE + ASEResourceGetter.getString("cont_install"))) {
                    this.gotoPreviousBean(wizardBeanEvent);
                } else {
                    this.logEvent(this, "msg1", "Overrided.  Continue installation to " + string2 + "...");
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putRequiredService("registryService");
            wizardBuilderSupport.putRequiredService("productService");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.CheckInstalledProduct");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.CheckInstalledProductBeanInfo");
            wizardBuilderSupport.putClass("com.installshield.beans.editors.EnumerationPropertyEditor");
            wizardBuilderSupport.putClass("com.installshield.isje.product.editors.SoftwareObjectKeyEditor");
            if (this.sok.getUID().length() == 0) {
                wizardBuilderSupport.logEvent(this, "err", "You must specify an UID value in CheckInstalledProduct.key property.");
                wizardBuilderSupport.setBuildCanceled(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    private boolean prompt(String string) {
        Object[] objectArray = new String[]{this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, yes)"), this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, no)")};
        UserInputRequest userInputRequest = new UserInputRequest(this.resolveString(this.getWizard().getTitle()), string, 4, objectArray, objectArray[1]);
        UserInputResponse userInputResponse = this.getWizard().getUI().userInputRequested(userInputRequest);
        return userInputResponse.getResponse().toString().equals(objectArray[0]);
    }

    private void gotoPreviousBean(WizardBeanEvent wizardBeanEvent) {
        Wizard wizard = wizardBeanEvent.getWizard();
        WizardTree wizardTree = wizard.getWizardTree();
        WizardTreeIterator wizardTreeIterator = wizardBeanEvent.getWizard().getIterator();
        WizardBean wizardBean = this;
        while (!((wizardBean = wizardTreeIterator.getPrevious(wizardBean)) instanceof SybaseDestinationPanel)) {
        }
        wizard.setCurrentBean(wizardTreeIterator.getPrevious(wizardBean));
    }

    public void setProductName(String string) {
        this.name = string;
    }

    public String getProductName() {
        return this.name;
    }

    public void setKey(SoftwareObjectKey softwareObjectKey) {
        this.sok = softwareObjectKey;
    }

    public SoftwareObjectKey getKey() {
        return this.sok;
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setContinueWithoutProduct(boolean bl) {
        this.override = bl;
    }

    public boolean getContinueWithoutProduct() {
        return this.override;
    }
}

