/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.WizardUI;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ConfigASEPanel;
import com.sybase.ismp.ase.wizardbean.ConfigBackupPanel;
import com.sybase.ismp.ase.wizardbean.ConfigCustomServerInputPanel;
import com.sybase.ismp.ase.wizardbean.ConfigEJBPanel;
import com.sybase.ismp.ase.wizardbean.ConfigMonitorPanel;
import com.sybase.ismp.ase.wizardbean.ConfigServerInputPanel;
import com.sybase.ismp.ase.wizardbean.ConfigTextPanel;
import com.sybase.ismp.ase.wizardbean.ConfigWSPanel;
import com.sybase.ismp.ase.wizardbean.ConfigXPPanel;
import java.util.Enumeration;

public class ConfigASESummaryPanel
extends WizardPanel {
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private ConfigASEPanel _asePanel = null;
    private ConfigBackupPanel _bsPanel = null;
    private ConfigMonitorPanel _msPanel = null;
    private ConfigXPPanel _xpPanel = null;
    private ConfigTextPanel _eftsPanel = null;
    private ConfigEJBPanel _ejbPanel = null;
    private ConfigWSPanel _wsPanel = null;
    private ConfigServerInputPanel _configInputPanel = null;
    private ConfigCustomServerInputPanel _configCustomInputPanel = null;
    private String origTitle = "";
    public static final String ASE = ASEResourceGetter.getString("ase");
    public static final String BS = ASEResourceGetter.getString("bs");
    public static final String MS = ASEResourceGetter.getString("ms");
    public static final String XP = ASEResourceGetter.getString("xp");
    public static final String WS = ASEResourceGetter.getString("ws");
    public static final String TXT = ASEResourceGetter.getString("txt");
    public static final String EJB = ASEResourceGetter.getString("ejb");

    public ConfigASESummaryPanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, configure_new_ase_summary_description)");
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        WizardUI wizardUI = wizardBeanEvent.getUserInterface();
        if (wizardUI != null) {
            wizardUI.setBusy();
        }
        this.findWizardBeans(this.getWizardTree().getRoot());
        this.initBeans();
        if (wizardUI != null) {
            wizardUI.clearBusy();
        }
        return true;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        super.execute(wizardBeanEvent);
        this.queryEnter(wizardBeanEvent);
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        if (super.entered(wizardBeanEvent)) {
            if (this.origTitle.length() == 0) {
                this.origTitle = this.getWizard().getTitle();
            }
            this.getWizard().setTitle(this.origTitle + " - " + ASEResourceGetter.getString("configure_new_ase_summary_title"));
            return true;
        }
        return false;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        super.exited(wizardBeanEvent);
        this.getWizard().setTitle(this.origTitle);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean.ui");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.PropertyInspector");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.TypedKeyInfo");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean");
            wizardBuilderSupport.putPackage("com.installshield.wizard.i18n");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary$1");
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ui");
            wizardBuilderSupport.putPackage("com.installshield.beans.editors");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    public String[][] getAttributes(String string) {
        if (this._configInputPanel == null) {
            this.logEvent(this, "dbg", "ConfigServerInputPanel bean is null.");
            return null;
        }
        if (string.equals(ASE) && this._configInputPanel.getConfigureAse()) {
            if (this._asePanel == null) {
                this.logEvent(this, "dbg", "ConfigASEPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("ase_server_name"), this._asePanel.getServerName()}, {ASEResourceGetter.getString("port_number"), this._asePanel.getPortNumber()}, {ASEResourceGetter.getString("ase_page_size"), this._asePanel.getPageSize()}, {ASEResourceGetter.getString("error_log"), this._asePanel.getErrorLog()}, {ASEResourceGetter.getString("ase_master_dev"), this._asePanel.getMasterDevice()}, {ASEResourceGetter.getString("ase_master_dev_size"), this._asePanel.getMasterDeviceSize()}, {ASEResourceGetter.getString("ase_master_db_size"), this._asePanel.getMasterDatabaseSize()}, {ASEResourceGetter.getString("ase_sysproc_dev"), this._asePanel.getSystemProcedureDevice()}, {ASEResourceGetter.getString("ase_sysproc_dev_size"), this._asePanel.getSystemProcedureDeviceSize()}, {ASEResourceGetter.getString("ase_sysproc_db_size"), this._asePanel.getSystemProcedureDatabaseSize()}, {ASEResourceGetter.getString("ase_system_dev"), this._asePanel.getSystemDevice()}, {ASEResourceGetter.getString("ase_system_dev_size"), this._asePanel.getSystemDeviceSize()}, {ASEResourceGetter.getString("ase_system_db_size"), this._asePanel.getSystemDatabaseSize()}};
        }
        if (string.equals(BS) && this._configInputPanel.getConfigureBackup()) {
            if (this._bsPanel == null) {
                this.logEvent(this, "dbg", "ConfigBackupPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("bs_server_name"), this._bsPanel.getServerName()}, {ASEResourceGetter.getString("port_number"), this._bsPanel.getPortNumber()}, {ASEResourceGetter.getString("error_log"), this._bsPanel.getErrorLog()}};
        }
        if (string.equals(MS) && this._configInputPanel.getConfigureMonitor()) {
            if (this._msPanel == null) {
                this.logEvent(this, "dbg", "ConfigMonitorPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("ms_server_name"), this._msPanel.getServerName()}, {ASEResourceGetter.getString("port_number"), this._msPanel.getPortNumber()}, {ASEResourceGetter.getString("error_log"), this._msPanel.getErrorLog()}};
        }
        if (string.equals(XP) && this._configInputPanel.getConfigureXp()) {
            if (this._xpPanel == null) {
                this.logEvent(this, "dbg", "ConfigXPPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("xp_server_name"), this._xpPanel.getServerName()}, {ASEResourceGetter.getString("port_number"), this._xpPanel.getPortNumber()}, {ASEResourceGetter.getString("error_log"), this._xpPanel.getErrorLog()}};
        }
        if (string.equals(WS) && this._configInputPanel.getConfigureWebServices()) {
            if (this._wsPanel == null) {
                this.logEvent(this, "dbg", "ConfigWSPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("ws_producer_http_number"), this._wsPanel.getProducerHttpPortNumber()}, {ASEResourceGetter.getString("ws_producer_https_number"), this._wsPanel.getProducerHttpsPortNumber()}, {ASEResourceGetter.getString("ws_producer_hostname"), this._wsPanel.getProducerHostName()}, {ASEResourceGetter.getString("ws_cert_password"), "******"}, {ASEResourceGetter.getString("ws_keystore_password"), "******"}, {ASEResourceGetter.getString("ws_producer_log_file"), this._wsPanel.getProducerLogFile()}, {ASEResourceGetter.getString("ws_consumer_port_number"), this._wsPanel.getConsumerPortNumber()}, {ASEResourceGetter.getString("ws_consumer_log_file"), this._wsPanel.getConsumerLogFile()}};
        }
        if (string.equals(TXT) && this._configInputPanel.getConfigureTextServer() && !this._isWindows) {
            if (this._eftsPanel == null) {
                this.logEvent(this, "dbg", "ConfigTextPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("text_server_name"), this._eftsPanel.getServerName()}, {ASEResourceGetter.getString("port_number"), this._eftsPanel.getPortNumber()}, {ASEResourceGetter.getString("error_log"), this._eftsPanel.getErrorLog()}, {ASEResourceGetter.getString("text_collection_dir"), this._eftsPanel.getTextCollectionDirectory()}, {ASEResourceGetter.getString("text_default_db"), this._eftsPanel.getTextDefaultDatabase()}, {ASEResourceGetter.getString("text_min_session"), this._eftsPanel.getTextMinimumSession()}, {ASEResourceGetter.getString("text_max_session"), this._eftsPanel.getTextMaximumSession()}};
        }
        if (string.equals(EJB) && this._configInputPanel.getConfigureEjbServer()) {
            if (this._ejbPanel == null) {
                this.logEvent(this, "dbg", "ConfigEJBPanel bean is null.");
                return null;
            }
            return new String[][]{{ASEResourceGetter.getString("port_number"), this._ejbPanel.getPortNumber()}};
        }
        return null;
    }

    private void findWizardBeans(WizardBean wizardBean) {
        WizardTree wizardTree = this.getWizardTree();
        Enumeration enumeration = wizardTree.children(wizardBean);
        while (enumeration.hasMoreElements()) {
            wizardBean = (WizardBean)enumeration.nextElement();
            if (wizardTree.getChildCount(wizardBean) > 0) {
                this.findWizardBeans(wizardBean);
            }
            if (wizardBean instanceof ConfigASEPanel) {
                this._asePanel = (ConfigASEPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigBackupPanel) {
                this._bsPanel = (ConfigBackupPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigMonitorPanel) {
                this._msPanel = (ConfigMonitorPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigXPPanel) {
                this._xpPanel = (ConfigXPPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigTextPanel) {
                this._eftsPanel = (ConfigTextPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigEJBPanel) {
                this._ejbPanel = (ConfigEJBPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigWSPanel) {
                this._wsPanel = (ConfigWSPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigServerInputPanel) {
                this._configInputPanel = (ConfigServerInputPanel)wizardBean;
                continue;
            }
            if (!(wizardBean instanceof ConfigCustomServerInputPanel)) continue;
            this._configCustomInputPanel = (ConfigCustomServerInputPanel)wizardBean;
        }
    }

    private void initBeans() {
        if (this._configCustomInputPanel != null) {
            if (!this._configCustomInputPanel.getCustomConfigureAse() && this._asePanel != null) {
                this._asePanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureBackup() && this._bsPanel != null) {
                this._bsPanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureMonitor() && this._msPanel != null) {
                this._msPanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureXp() && this._xpPanel != null) {
                this._xpPanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureTextServer() && this._eftsPanel != null) {
                this._eftsPanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureEjbServer() && this._ejbPanel != null) {
                this._ejbPanel.initProperties();
            }
            if (!this._configCustomInputPanel.getCustomConfigureWebServices() && this._wsPanel != null) {
                this._wsPanel.initProperties();
            }
        }
    }
}

