/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.sybase.ismp.ase.OSUtil;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ConfigASEPanel;
import com.sybase.ismp.ase.wizardbean.ConfigBackupPanel;
import com.sybase.ismp.ase.wizardbean.ConfigCustomServerInputPanel;
import com.sybase.ismp.ase.wizardbean.ConfigEJBPanel;
import com.sybase.ismp.ase.wizardbean.ConfigMonitorPanel;
import com.sybase.ismp.ase.wizardbean.ConfigTextPanel;
import com.sybase.ismp.ase.wizardbean.ConfigWSPanel;
import com.sybase.ismp.ase.wizardbean.ConfigXPPanel;
import com.sybase.ismp.ase.wizardbean.ServerPort;
import java.io.File;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Category;

public class ConfigPanel
extends WizardPanel {
    private static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$wizardbean$ConfigPanel == null ? (class$com$sybase$ismp$ase$wizardbean$ConfigPanel = ConfigPanel.class$("com.sybase.ismp.ase.wizardbean.ConfigPanel")) : class$com$sybase$ismp$ase$wizardbean$ConfigPanel).getName());
    private static Hashtable reservedSpaceInPartition = new Hashtable();
    protected String _releaseDir = "/opt/sybase";
    protected String _aseDir = "ASE-12_5";
    protected String _ocsDir = "OCS-12_5";
    protected String _hostName = "localhost";
    protected String _serverName = "SYBASE";
    protected String _portNumber = "5000";
    protected String _errorLog = this._releaseDir + File.separator + this._aseDir + File.separator + "install" + File.separator + this._serverName + ".log";
    protected String origTitle = "";
    protected FileService fs = null;
    private boolean isSGI = OSUtil.isOperatingSystemOk(11);
    private boolean isLinux = OSUtil.isOperatingSystemOk(10);
    private ServerPort serverPort = null;
    static /* synthetic */ Class class$com$sybase$ismp$ase$wizardbean$ConfigPanel;

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        this.initProperties();
        return true;
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        if (super.entered(wizardBeanEvent)) {
            if (this.origTitle.length() == 0) {
                this.origTitle = this.getWizard().getTitle();
            }
            String string = this.origTitle;
            if (this instanceof ConfigASEPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_ase_title");
            } else if (this instanceof ConfigBackupPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_backup_title");
            } else if (this instanceof ConfigMonitorPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_monitor_title");
            } else if (this instanceof ConfigXPPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_xp_title");
            } else if (this instanceof ConfigTextPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_text_title");
            } else if (this instanceof ConfigEJBPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_ejb_title");
            } else if (this instanceof ConfigWSPanel) {
                string = this.origTitle + " - " + ASEResourceGetter.getString("configure_new_ws_title");
            }
            this.getWizard().setTitle(string);
            return true;
        }
        return false;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent, String string, String string2) {
        boolean bl = true;
        String[] stringArray = new String[]{this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, ok)")};
        Object[] objectArray = new Object[2];
        String string3 = this.getServerName();
        objectArray[0] = ASEResourceGetter.getString(string);
        objectArray[1] = string3;
        if (!this.isValidServerName(string3)) {
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("invalid_server_name", objectArray), 4);
            bl = false;
        }
        if (this.serverPort.isServerNameUsed(string3)) {
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("server_name_is_used", objectArray), 4);
            bl = false;
        }
        try {
            this.serverPort = ServerPort.getInstanceServerPort(this._releaseDir, this._ocsDir);
            this.serverPort.unReservePort(ASEResourceGetter.getString(string2));
            this.serverPort.isPortUsed(Integer.parseInt(this.getPortNumber()));
            this.serverPort.reservePort(ASEResourceGetter.getString(string2), this.getPortNumber());
        }
        catch (Exception exception) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("port_number"), exception.getMessage(), 4);
            bl = false;
        }
        return bl;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        super.exited(wizardBeanEvent);
        this.getWizard().setTitle(this.origTitle);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean.ui");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.PropertyInspector");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.TypedKeyInfo");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ChoiceComponentListenerAdapter");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean");
            wizardBuilderSupport.putPackage("com.installshield.wizard.i18n");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary$1");
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ui");
            wizardBuilderSupport.putPackage("com.installshield.beans.editors");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    protected void initProperties() {
        Object object;
        this._releaseDir = this.resolveString("$P(installLocation)");
        this.serverPort = ServerPort.getInstanceServerPort(this._releaseDir, this._ocsDir);
        String string = this.getHostName();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() && stringBuffer.length() <= 26; ++i) {
            if (string.charAt(i) == '-' || !Character.isLetterOrDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        this._serverName = stringBuffer.toString().toUpperCase();
        this._serverName = this.serverPort.getUnusedServerName(this._serverName);
        try {
            this.fs = (FileService)this.getService("fileService");
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
        }
        if (!(this instanceof ConfigASEPanel)) {
            ConfigASEPanel configASEPanel = (ConfigASEPanel)this.getConfigASEPanel(this.getWizardTree().getRoot());
            object = (ConfigCustomServerInputPanel)this.getConfigCustomServerInputPanel(this.getWizardTree().getRoot());
            String string2 = this._serverName;
            if (configASEPanel != null && object != null && ((ConfigCustomServerInputPanel)object).getCustomConfigureAse()) {
                string2 = configASEPanel.getServerName();
            }
            if (this instanceof ConfigBackupPanel) {
                string2 = string2 + "_BS";
                this.setServerName(this.serverPort.getUnusedServerName(string2));
            } else if (this instanceof ConfigMonitorPanel) {
                string2 = string2 + "_MS";
                this.setServerName(this.serverPort.getUnusedServerName(string2));
            } else if (this instanceof ConfigXPPanel) {
                string2 = string2 + "_XP";
                this.setServerName(this.serverPort.getUnusedServerName(string2));
            } else if (this instanceof ConfigTextPanel) {
                string2 = string2 + "_TEXT";
                this.setServerName(this.serverPort.getUnusedServerName(string2));
            }
        }
        this._errorLog = this._releaseDir + File.separator + this._aseDir + File.separator + "install" + File.separator + this._serverName + ".log";
        int n = Integer.parseInt(this._portNumber);
        this._portNumber = String.valueOf(this.serverPort.getNextOpenPort(n));
        object = "";
        if (this instanceof ConfigASEPanel) {
            object = "ase";
        } else if (this instanceof ConfigBackupPanel) {
            object = "bs";
        } else if (this instanceof ConfigMonitorPanel) {
            object = "ms";
        } else if (this instanceof ConfigXPPanel) {
            object = "xp";
        } else if (this instanceof ConfigTextPanel) {
            object = "txt";
        } else if (this instanceof ConfigEJBPanel) {
            object = "ejb";
        } else if (this instanceof ConfigWSPanel) {
            object = "ws";
        }
        this.serverPort.reservePort(ASEResourceGetter.getString((String)object), this._portNumber);
    }

    protected WizardBean getConfigCustomServerInputPanel(WizardBean wizardBean) {
        WizardTree wizardTree = this.getWizardTree();
        Enumeration enumeration = wizardTree.children(wizardBean);
        while (enumeration.hasMoreElements()) {
            wizardBean = (WizardBean)enumeration.nextElement();
            if (wizardTree.getChildCount(wizardBean) > 0) {
                wizardBean = this.getConfigCustomServerInputPanel(wizardBean);
            }
            if (!(wizardBean instanceof ConfigCustomServerInputPanel)) continue;
            return wizardBean;
        }
        return null;
    }

    protected WizardBean getConfigASEPanel(WizardBean wizardBean) {
        WizardTree wizardTree = this.getWizardTree();
        Enumeration enumeration = wizardTree.children(wizardBean);
        while (enumeration.hasMoreElements()) {
            wizardBean = (WizardBean)enumeration.nextElement();
            if (wizardTree.getChildCount(wizardBean) > 0) {
                wizardBean = this.getConfigASEPanel(wizardBean);
            }
            if (!(wizardBean instanceof ConfigASEPanel)) continue;
            return wizardBean;
        }
        return null;
    }

    protected boolean isValidServerName(String string) {
        if (string.length() > 30) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    private String getPartition(String string) {
        try {
            return this.fs.getPartitionName(string, this.fs.getPartitionNames());
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
            return "";
        }
    }

    public long getFreeSpace(String string) {
        if (this.isSGI || this.isLinux) {
            return Integer.MAX_VALUE;
        }
        try {
            long l = Integer.MAX_VALUE;
            if (this.isRawFile(string)) {
                l = Integer.MAX_VALUE;
            } else {
                this.logEvent(this, "dbg", "getPartition(" + string + ") = " + this.getPartition(string));
                l = this.fs.getPartitionFreeSpace(this.getPartition(string)) / 0x100000L;
                this.logEvent(this, "dbg", "getPartitionFreeSpace(" + this.getPartition(string) + ") = " + String.valueOf(l));
            }
            return l;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return 0L;
        }
    }

    public long reserveSpace(String string, long l) {
        if (this.isSGI || this.isLinux) {
            return l;
        }
        long l2 = 0L;
        String string2 = string;
        if (!this.isRawFile(string)) {
            string2 = this.getPartition(string);
        }
        Long l3 = null;
        l3 = (Long)reservedSpaceInPartition.get(string2);
        l2 = l3 != null ? l3.longValue() : this.getFreeSpace(string);
        if (l2 >= l) {
            Long l4 = new Long(l2 - l);
            reservedSpaceInPartition.put(string2, l4);
            return l;
        }
        return l2;
    }

    public void unReserveSpace(String string, long l) {
        Long l2;
        if (this.isSGI || this.isLinux) {
            return;
        }
        String string2 = string;
        if (!this.isRawFile(string)) {
            string2 = this.getPartition(string);
        }
        if ((l2 = (Long)reservedSpaceInPartition.get(string2)) != null) {
            long l3 = l2;
            long l4 = l3 - l;
            if (l4 <= 0L) {
                reservedSpaceInPartition.remove(string2);
            } else {
                reservedSpaceInPartition.put(string2, new Long(l4));
            }
        }
    }

    public long getAvailableSpace(String string) {
        Long l;
        if (this.isSGI || this.isLinux) {
            return Integer.MAX_VALUE;
        }
        String string2 = string;
        if (!this.isRawFile(string)) {
            string2 = this.getPartition(string);
        }
        if ((l = (Long)reservedSpaceInPartition.get(string2)) != null) {
            return l;
        }
        return this.getFreeSpace(string);
    }

    public boolean isRawFile(String string) {
        if (this.isSGI || this.isLinux) {
            return false;
        }
        try {
            return this.fs.fileExists(string) && !this.fs.isDirectory(string) && !this.fs.isFile(string);
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
            return false;
        }
    }

    public void setSybaseAse(String string) {
        this._aseDir = string;
    }

    public String getSybaseAse() {
        return this._aseDir;
    }

    public void setSybaseOcs(String string) {
        this._ocsDir = string;
    }

    public String getSybaseOcs() {
        return this._ocsDir;
    }

    public void setServerName(String string) {
        this._serverName = string;
        this.propertyChanged(ASEResourceGetter.getString("ase_server_name"));
        this.propertyChanged(ASEResourceGetter.getString("bs_server_name"));
        this.propertyChanged(ASEResourceGetter.getString("ms_server_name"));
        this.propertyChanged(ASEResourceGetter.getString("xp_server_name"));
        this.propertyChanged(ASEResourceGetter.getString("text_server_name"));
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setPortNumber(String string) {
        this._portNumber = string;
        this.propertyChanged(ASEResourceGetter.getString("port_number"));
    }

    public String getPortNumber() {
        return this._portNumber;
    }

    public void setErrorLog(String string) {
        this._errorLog = string;
        this.propertyChanged(ASEResourceGetter.getString("error_log"));
    }

    public String getErrorLog() {
        return this._errorLog;
    }

    public void setHostName(String string) {
        this._hostName = string;
        this.propertyChanged(ASEResourceGetter.getString("host_name"));
    }

    public String getHostName() {
        try {
            this._hostName = InetAddress.getLocalHost().getHostName();
            if (this._hostName.indexOf(46) != -1) {
                this._hostName = this._hostName.substring(0, this._hostName.indexOf(46));
            }
        }
        catch (Exception exception) {
            this._hostName = "localhost";
        }
        return this._hostName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

