/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardPanel;
import com.sybase.ismp.ase.OSUtil;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class ConfigSecureModulePanel
extends WizardPanel {
    public static final String[] ANONYMOUS_PROPERTY_NAMES = new String[]{"provider", "controlFlag", "options.moduleName", "options.roles"};
    public static final String[] SIMPLE_PROPERTY_NAMES = new String[]{"provider", "controlFlag", "options.moduleName", "options.username", "options.password", "options.encrypted", "options.roles"};
    public static final String[] NT_PROPERTY_NAMES = new String[]{"provider", "controlFlag", "options.moduleName", "options.debug"};
    public static final String[] UNIX_PROPERTY_NAMES = new String[]{"provider", "controlFlag", "options.moduleName", "options.debug"};
    public static final String[] ASE_PROPERTY_NAMES = new String[]{"provider", "controlFlag", " options.moduleName"};
    public static final String[] ANONYMOUS_DEFAULT_VALUES = new String[]{"com.sybase.ua.services.security.anonymous.AnonymousLoginModule", "sufficient", "Anonymous Login Module", "uaAnonymous"};
    public static final String[] SIMPLE_DEFAULT_VALUES = new String[]{"com.sybase.ua.services.security.simple.SimpleLoginModule", "sufficient", "Simple Login Module", "uafadmin", "Sybase4me", "false", "uaAgentAdmin,uaPluginAdmin"};
    public static final String[] NT_DEFAULT_VALUES = new String[]{"com.sybase.ua.services.security.os.NTProxyLoginModule", "sufficient", "NT Proxy Login Module", "true"};
    public static final String[] UNIX_DEFAULT_VALUES = new String[]{"com.sybase.ua.services.security.os.UnixProxyLoginModule", "sufficient", "Unix Proxy Login Module", "true"};
    public static final String[] ASE_DEFAULT_VALUES = new String[]{"com.sybase.ua.services.security.ase.ASELoginModule", "sufficient", "ASE Login Module"};
    public static final String csi_file = "$P(installLocation)/ua/conf/csi.properties";
    public boolean isWindows = OSUtil.isOperatingSystemOk(0);
    public String NEWLINE = System.getProperty("line.separator");
    private Properties loadProp;
    private LoginModule default_anonymous;
    private LoginModule default_simple;
    private LoginModule default_nt;
    private LoginModule default_unix;
    private LoginModule default_ase;
    private ArrayList moduleList;

    public ConfigSecureModulePanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, config_secure_module_description_gui)");
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        boolean bl = super.queryEnter(wizardBeanEvent);
        this.initProperties();
        this.loadCSI();
        this.appendDefaultLoginModules();
        return bl;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        super.execute(wizardBeanEvent);
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        boolean bl = super.queryExit(wizardBeanEvent);
        boolean bl2 = false;
        for (int i = 0; i < this.moduleList.size(); ++i) {
            LoginModule loginModule = (LoginModule)this.moduleList.get(i);
            if (!loginModule.getActive()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("module_name"), ASEResourceGetter.getString("select_one_login_module"), 4);
            return false;
        }
        this.writeCSI();
        return bl;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        String string = this.resolveString("$P(displayName)");
        String string2 = ASEResourceGetter.getString("config_secure_module_title");
        String string3 = ASEResourceGetter.getString("config_secure_module_description");
        String string4 = this.getBeanId();
        StringBuffer stringBuffer = new StringBuffer();
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string2, string3, stringBuffer.toString())};
    }

    private void loadCSI() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.resolveString(csi_file));
            this.loadProp = new Properties();
            this.loadProp.load(fileInputStream);
            fileInputStream.close();
            Object[] objectArray = this.getProviderProperties(this.loadProp);
            this.moduleList = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString().substring(16);
                String string2 = string.substring(0, string.indexOf(46));
                String string3 = "CSI.loginModule." + string2 + ".";
                Properties properties = this.getLikeProperties(this.loadProp, string3);
                if (properties == null) continue;
                LoginModule loginModule = new LoginModule();
                Properties properties2 = new Properties();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string4 = enumeration.nextElement().toString();
                    String string5 = properties.getProperty(string4);
                    if ((string4 = string4.substring(string3.length())).equals("provider")) {
                        loginModule.setProvider(string5);
                        continue;
                    }
                    if (string4.equals("controlFlag")) {
                        loginModule.setControlFlag(string5);
                        continue;
                    }
                    if (string4.equals("options.moduleName")) {
                        loginModule.setName(string5);
                        continue;
                    }
                    properties2.setProperty(string4, string5);
                }
                loginModule.setOtherProperties(properties2);
                loginModule.setActive(true);
                this.logEvent(this, "dbg", "Loaded login module..." + this.NEWLINE + loginModule.getData());
                this.moduleList.add(loginModule);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logEvent(this, "err", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    private void writeCSI() {
        try {
            String string;
            Object object;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.resolveString(csi_file)));
            int n = this.moduleList.size();
            bufferedWriter.write("###########################################" + this.NEWLINE);
            bufferedWriter.write("#           Login Modules                 #" + this.NEWLINE);
            bufferedWriter.write("###########################################" + this.NEWLINE);
            for (int i = 0; i < n; ++i) {
                object = (LoginModule)this.moduleList.get(i);
                string = "#";
                if (((LoginModule)object).getActive()) {
                    string = "";
                    this.logEvent(this, "dbg", "Writing login module..." + this.NEWLINE + ((LoginModule)object).getData());
                }
                String string2 = "CSI.loginModule." + String.valueOf(i);
                bufferedWriter.write("# " + ((LoginModule)object).getName() + this.NEWLINE);
                bufferedWriter.write(string + string2 + ".provider=" + ((LoginModule)object).getProvider() + this.NEWLINE);
                bufferedWriter.write(string + string2 + ".controlFlag=" + ((LoginModule)object).getControlFlag() + this.NEWLINE);
                bufferedWriter.write(string + string2 + ".options.moduleName=" + ((LoginModule)object).getName() + this.NEWLINE);
                Enumeration<?> enumeration = ((LoginModule)object).getOtherProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = enumeration.nextElement().toString();
                    String string4 = ((LoginModule)object).getOtherProperties().getProperty(string3);
                    bufferedWriter.write(string + string2 + "." + string3 + "=" + string4 + this.NEWLINE);
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            Enumeration<?> enumeration = this.loadProp.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement().toString();
                if (((String)object).startsWith("CSI.loginModule.")) continue;
                string = this.loadProp.getProperty((String)object);
                bufferedWriter.write((String)object + "=" + string + this.NEWLINE);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    private void appendDefaultLoginModules() {
        LoginModule loginModule = this.getLoginModuleByProvider(ANONYMOUS_DEFAULT_VALUES[0]);
        if (loginModule == null) {
            this.moduleList.add(this.default_anonymous.makeSelfCopy());
        }
        if ((loginModule = this.getLoginModuleByProvider(SIMPLE_DEFAULT_VALUES[0])) == null) {
            this.moduleList.add(this.default_simple.makeSelfCopy());
        }
        if (this.isWindows) {
            loginModule = this.getLoginModuleByProvider(NT_DEFAULT_VALUES[0]);
            if (loginModule == null) {
                this.moduleList.add(this.default_nt.makeSelfCopy());
            }
        } else {
            loginModule = this.getLoginModuleByProvider(UNIX_DEFAULT_VALUES[0]);
            if (loginModule == null) {
                this.moduleList.add(this.default_unix.makeSelfCopy());
            }
        }
        if ((loginModule = this.getLoginModuleByProvider(ASE_DEFAULT_VALUES[0])) == null) {
            this.moduleList.add(this.default_ase.makeSelfCopy());
        }
    }

    private Object[] getProviderProperties(Properties properties) {
        Object object;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            if (!object.startsWith("CSI.loginModule.") || !object.endsWith(".provider")) continue;
            arrayList.add((Object[])object);
        }
        object = arrayList.toArray();
        Arrays.sort(object);
        return object;
    }

    private Properties getLikeProperties(Properties properties, String string) {
        Properties properties2 = new Properties();
        boolean bl = false;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (!string2.startsWith(string)) continue;
            properties2.setProperty(string2, properties.getProperty(string2));
            bl = true;
        }
        if (bl) {
            return properties2;
        }
        return null;
    }

    private void initProperties() {
        this.default_anonymous = new LoginModule(ANONYMOUS_DEFAULT_VALUES[0], ANONYMOUS_DEFAULT_VALUES[1], ANONYMOUS_DEFAULT_VALUES[2]);
        this.default_simple = new LoginModule(SIMPLE_DEFAULT_VALUES[0], SIMPLE_DEFAULT_VALUES[1], SIMPLE_DEFAULT_VALUES[2]);
        this.default_nt = new LoginModule(NT_DEFAULT_VALUES[0], NT_DEFAULT_VALUES[1], NT_DEFAULT_VALUES[2]);
        this.default_unix = new LoginModule(UNIX_DEFAULT_VALUES[0], UNIX_DEFAULT_VALUES[1], UNIX_DEFAULT_VALUES[2]);
        this.default_ase = new LoginModule(ASE_DEFAULT_VALUES[0], ASE_DEFAULT_VALUES[1], ASE_DEFAULT_VALUES[2]);
        Properties properties = new Properties();
        properties.setProperty(ANONYMOUS_PROPERTY_NAMES[3], ANONYMOUS_DEFAULT_VALUES[3]);
        this.default_anonymous.setOtherProperties(properties);
        properties = new Properties();
        for (int i = 3; i < SIMPLE_PROPERTY_NAMES.length; ++i) {
            properties.setProperty(SIMPLE_PROPERTY_NAMES[i], SIMPLE_DEFAULT_VALUES[i]);
        }
        this.default_simple.setOtherProperties(properties);
        properties = new Properties();
        properties.setProperty(NT_PROPERTY_NAMES[3], NT_DEFAULT_VALUES[3]);
        this.default_nt.setOtherProperties(properties);
        properties = new Properties();
        properties.setProperty(UNIX_PROPERTY_NAMES[3], UNIX_DEFAULT_VALUES[3]);
        this.default_unix.setOtherProperties(properties);
    }

    public boolean isProviderActive(String string) {
        int n = this.moduleList.size();
        for (int i = 0; i < n; ++i) {
            LoginModule loginModule = (LoginModule)this.moduleList.get(i);
            if (!loginModule.getProvider().equals(string)) continue;
            return loginModule.getActive();
        }
        return false;
    }

    public boolean isNameActive(String string) {
        int n = this.moduleList.size();
        for (int i = 0; i < n; ++i) {
            LoginModule loginModule = (LoginModule)this.moduleList.get(i);
            if (!loginModule.getName().equals(string)) continue;
            return loginModule.getActive();
        }
        return false;
    }

    public LoginModule getLoginModuleByProvider(String string) {
        int n = this.moduleList.size();
        for (int i = 0; i < n; ++i) {
            LoginModule loginModule = (LoginModule)this.moduleList.get(i);
            if (!loginModule.getProvider().equals(string)) continue;
            return loginModule;
        }
        return null;
    }

    public LoginModule getLoginModuleByName(String string) {
        int n = this.moduleList.size();
        for (int i = 0; i < n; ++i) {
            LoginModule loginModule = (LoginModule)this.moduleList.get(i);
            if (!loginModule.getName().equals(string)) continue;
            return loginModule;
        }
        return null;
    }

    public String[] getNameList() {
        int n = this.moduleList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((LoginModule)this.moduleList.get(i)).getName();
        }
        return stringArray;
    }

    public void setLoginModuleList(ArrayList arrayList) {
        this.moduleList = arrayList;
    }

    public ArrayList getLoginModuleList() {
        return this.moduleList;
    }

    protected class LoginModule {
        boolean active = false;
        String provider = "";
        String control = "";
        String name = "";
        Properties other = new Properties();

        public LoginModule() {
        }

        public LoginModule(String string) {
            this.provider = string;
        }

        public LoginModule(String string, String string2) {
            this.provider = string;
            this.control = string2;
        }

        public LoginModule(String string, String string2, String string3) {
            this.provider = string;
            this.control = string2;
            this.name = string3;
        }

        public void setProvider(String string) {
            this.provider = string;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setControlFlag(String string) {
            this.control = string;
        }

        public String getControlFlag() {
            return this.control;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setOtherProperties(Properties properties) {
            this.other = properties;
        }

        public Properties getOtherProperties() {
            return this.other;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public boolean getActive() {
            return this.active;
        }

        public LoginModule makeSelfCopy() {
            LoginModule loginModule = new LoginModule(this.provider, this.control, this.name);
            loginModule.setOtherProperties(this.other);
            loginModule.setActive(this.active);
            return loginModule;
        }

        public String getData() {
            StringBuffer stringBuffer = new StringBuffer("---------------" + ConfigSecureModulePanel.this.NEWLINE);
            stringBuffer.append("provider=" + this.provider + ConfigSecureModulePanel.this.NEWLINE);
            stringBuffer.append("controlFlag=" + this.control + ConfigSecureModulePanel.this.NEWLINE);
            stringBuffer.append("options.moduleName=" + this.name + ConfigSecureModulePanel.this.NEWLINE);
            stringBuffer.append("*active*=" + String.valueOf(this.active) + ConfigSecureModulePanel.this.NEWLINE);
            Enumeration<?> enumeration = this.other.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                String string2 = this.other.getProperty(string);
                stringBuffer.append(string + "=" + string2 + ConfigSecureModulePanel.this.NEWLINE);
            }
            stringBuffer.append("---------------" + ConfigSecureModulePanel.this.NEWLINE);
            return stringBuffer.toString();
        }

        public String toString() {
            return this.name;
        }
    }
}

