/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardPanel;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ServerPort;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigSelfDiscoveryServicePanel
extends WizardPanel {
    public static final String JINI_ADAPTOR = "com.sybase.ua.services.discovery.SelfDiscoveryServiceJiniAdaptor";
    public static final String UDP_ADAPTOR = "com.sybase.ua.services.discovery.SelfDiscoveryServiceUDPAdaptor";
    public static final String[] SERVICES = new String[]{"com.sybase.ua.services.discovery.SelfDiscoveryServiceJiniAdaptor", "com.sybase.ua.services.discovery.SelfDiscoveryServiceUDPAdaptor"};
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "4160";
    public static final String DEFAULT_HEARTBEAT = "900";
    protected String adaptor = "com.sybase.ua.services.discovery.SelfDiscoveryServiceJiniAdaptor";
    protected String host = "localhost";
    protected int port = 4160;
    protected int heartbeat = 900;
    private String xmlFile = "$P(installLocation)/ua/conf/agent-config.xml";
    private ServerPort serverPort = null;
    private Document doc = null;
    private Node dsNode = null;

    public ConfigSelfDiscoveryServicePanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, config_self_ds_description)");
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        boolean bl = super.queryEnter(wizardBeanEvent);
        if (this.openDocument() && !this.findSelfDiscoveryServiceNode()) {
            this.createDefaultSelfDiscoveryServiceNode();
        }
        this.readPropertiesFromXML();
        return bl;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        super.execute(wizardBeanEvent);
        if (this.openDocument() && !this.findSelfDiscoveryServiceNode()) {
            this.createDefaultSelfDiscoveryServiceNode();
        }
        this.saveDocument();
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        boolean bl = super.queryExit(wizardBeanEvent);
        try {
            String string = this.resolveString("$P(installLocation)");
            this.serverPort = ServerPort.getInstanceServerPort(string, "OCS-15_0");
            this.serverPort.unReservePort(ASEResourceGetter.getString("uaf"));
            this.serverPort.isPortUsed(this.port);
            this.serverPort.reservePort(ASEResourceGetter.getString("uaf"), String.valueOf(this.port));
        }
        catch (Exception exception) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("port_number"), exception.getMessage(), 4);
            return false;
        }
        this.saveDocument();
        return bl;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        String string = this.resolveString("$P(displayName)");
        String string2 = ASEResourceGetter.getString("config_self_ds_title");
        String string3 = ASEResourceGetter.getString("config_self_ds_description");
        String string4 = this.getBeanId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-W " + string4 + ".selfDiscoveryService=" + this.getAdaptor());
        stringBuffer.append(System.getProperty("line.separator"));
        if (n == 1) {
            stringBuffer.append("### -W " + string4 + ".hostName=localhost");
        } else {
            stringBuffer.append("-W " + string4 + ".hostName=" + this.getHostName());
        }
        stringBuffer.append(System.getProperty("line.separator"));
        if (n == 1) {
            stringBuffer.append("### -W " + string4 + ".portNumber=" + this.getPortNumber());
        } else {
            stringBuffer.append("-W " + string4 + ".portNumber=" + this.getPortNumber());
        }
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string2, string3, stringBuffer.toString())};
    }

    private boolean openDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(new File(this.resolveString(this.xmlFile)));
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return false;
    }

    private boolean saveDocument() {
        if (this.getAdaptor().equals(UDP_ADAPTOR)) {
            this.setAttribute("adaptor", UDP_ADAPTOR);
            this.deleteAttribute("host");
            this.deleteAttribute("port");
            this.deleteAttribute("heartbeat.period");
        } else {
            this.setAttribute("adaptor", JINI_ADAPTOR);
            this.setAttribute("host", this.getHostName());
            this.setAttribute("port", String.valueOf(this.getPortNumber()));
            this.setAttribute("heartbeat.period", String.valueOf(this.getHeartBeatPeriod()));
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.doc);
            StreamResult streamResult = new StreamResult(new File(this.resolveString(this.xmlFile)));
            transformer.transform(dOMSource, streamResult);
            return true;
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException);
            return false;
        }
    }

    private boolean findSelfDiscoveryServiceNode() {
        NodeList nodeList = this.doc.getElementsByTagName("service");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node2 = namedNodeMap.item(j);
                if (node2 == null || !node2.getNodeName().trim().equals("name") || !node2.getNodeValue().trim().equals("Self Discovery Service")) continue;
                this.dsNode = node;
                return true;
            }
        }
        return false;
    }

    public String readAttribute(String string) {
        if (this.dsNode != null) {
            for (Node node = this.dsNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap == null) continue;
                String string2 = "";
                String string3 = "";
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (node2.getNodeName().trim().equals("property")) {
                        string2 = node2.getNodeValue().trim();
                        continue;
                    }
                    if (!node2.getNodeName().trim().equals("value")) continue;
                    string3 = node2.getNodeValue().trim();
                }
                if (!string2.equals(string)) continue;
                return string3;
            }
        }
        return null;
    }

    public boolean setAttribute(String string, String string2) {
        if (this.dsNode != null) {
            this.deleteAttribute(string);
            Element element = this.doc.createElement("set-property");
            element.setAttribute("property", string);
            element.setAttribute("value", string2);
            this.dsNode.appendChild(element);
            return true;
        }
        return false;
    }

    public boolean deleteAttribute(String string) {
        if (this.dsNode != null) {
            for (Node node = this.dsNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap == null) continue;
                String string2 = "";
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (!node2.getNodeName().trim().equals("property")) continue;
                    string2 = node2.getNodeValue().trim();
                }
                if (!string2.equals(string)) continue;
                this.dsNode.removeChild(node);
                return true;
            }
        }
        return false;
    }

    public void readPropertiesFromXML() {
        String string = this.readAttribute("adaptor");
        if (string != null) {
            this.setAdaptor(string);
        }
        if ((string = this.readAttribute("host")) != null) {
            this.setHostName(string);
        }
        if ((string = this.readAttribute("port")) != null) {
            this.setPortNumber(Integer.parseInt(string));
        }
        if ((string = this.readAttribute("heartbeat.period")) != null) {
            this.setHeartBeatPeriod(Integer.parseInt(string));
        }
    }

    public boolean createDefaultSelfDiscoveryServiceNode() {
        Element element = this.doc.createElement("service");
        element.setAttribute("name", "Self Discovery Service");
        element.setAttribute("class", "com.sybase.ua.services.discovery.SelfDiscoveryService");
        element.setAttribute("mbean-type", "Model MBean");
        element.setAttribute("mbean-descriptor", "services/Discovery/mbean-descriptor.xml");
        element.setAttribute("arl-config", "services/Discovery/arl.xml");
        Element element2 = this.doc.createElement("set-property");
        element2.setAttribute("property", "adaptor");
        element2.setAttribute("value", JINI_ADAPTOR);
        element.appendChild(element2);
        element2 = this.doc.createElement("set-property");
        element2.setAttribute("property", "host");
        element2.setAttribute("value", DEFAULT_HOST);
        element.appendChild(element2);
        element2 = this.doc.createElement("set-property");
        element2.setAttribute("property", "port");
        element2.setAttribute("value", DEFAULT_PORT);
        element.appendChild(element2);
        element2 = this.doc.createElement("set-property");
        element2.setAttribute("property", "heartbeat.period");
        element2.setAttribute("value", DEFAULT_HEARTBEAT);
        element.appendChild(element2);
        NodeList nodeList = this.doc.getElementsByTagName("agent-services");
        if (nodeList != null && nodeList.getLength() > 0) {
            nodeList.item(0).appendChild(element);
            this.dsNode = element;
            return true;
        }
        return false;
    }

    public void setAdaptor(String string) {
        this.adaptor = string;
    }

    public String getAdaptor() {
        return this.adaptor;
    }

    public void setHostName(String string) {
        this.host = string;
    }

    public String getHostName() {
        return this.host;
    }

    public void setPortNumber(int n) {
        this.port = n;
    }

    public int getPortNumber() {
        return this.port;
    }

    public void setHeartBeatPeriod(int n) {
        this.heartbeat = n;
    }

    public int getHeartBeatPeriod() {
        return this.heartbeat;
    }
}

