/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardUI;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ConfigCustomServerInputPanel;
import com.sybase.ismp.ase.wizardbean.ConfigPanel;
import com.sybase.ismp.ase.wizardbean.ServerPort;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ConfigWSPanel
extends ConfigPanel {
    public static final int PRODUCER_HTTP_IND = 0;
    public static final int PRODUCER_HTTPS_IND = 1;
    public static final int PRODUCER_HOSTNAME_IND = 2;
    public static final int CERT_PASSWORD_IND = 3;
    public static final int CERT_RETRY_PASSWORD_IND = 4;
    public static final int KEYSTORE_PASSWORD_IND = 5;
    public static final int KEYSTORE_RETRY_PASSWORD_IND = 6;
    public static final int PRODUCER_LOG_FILE_IND = 7;
    public static final int CONSUMER_PORT_NUMBER_IND = 8;
    public static final int CONSUMER_LOG_FILE_IND = 9;
    private String pathSep = System.getProperty("file.separator");
    private String _wsDir = "WS-12_5";
    private String pHTTP = "8181";
    private String pHTTPs = "8182";
    private String pHostName = "localhost";
    private String pLog = this._releaseDir + this.pathSep + this._wsDir + this.pathSep + "logs" + this.pathSep + "producer.log";
    private String certPassword = "sybase";
    private String certRetryPassword = "sybase";
    private String keystorePassword = "sybase";
    private String keystoreRetryPassword = "sybase";
    private String cPortNumber = "8183";
    private String cLog = this._releaseDir + this.pathSep + this._wsDir + this.pathSep + "logs" + this.pathSep + "consumer.log";

    public ConfigWSPanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, configure_new_ws_description)");
    }

    protected void initProperties() {
        Object object;
        super.initProperties();
        String string = this.resolveString("$P(installLocation)");
        ServerPort serverPort = ServerPort.getInstanceServerPort(this._releaseDir, this._ocsDir);
        serverPort.unReservePort("ws");
        int n = Integer.parseInt(this.pHTTP);
        this.pHTTP = String.valueOf(serverPort.getNextOpenPort(n));
        serverPort.reservePort(ASEResourceGetter.getString("ws_producer_http_number"), this.pHTTP);
        n = Integer.parseInt(this.pHTTPs);
        this.pHTTPs = String.valueOf(serverPort.getNextOpenPort(n));
        serverPort.reservePort(ASEResourceGetter.getString("ws_producer_https_number"), this.pHTTPs);
        this.setProducerHostName(this.getHostName());
        this.pLog = string + this.pathSep + this._wsDir + this.pathSep + "logs" + this.pathSep + "producer.log";
        n = Integer.parseInt(this.cPortNumber);
        this.cPortNumber = String.valueOf(serverPort.getNextOpenPort(n));
        serverPort.reservePort(ASEResourceGetter.getString("ws_consumer_port_number"), this.cPortNumber);
        this.cLog = string + this.pathSep + this._wsDir + this.pathSep + "logs" + this.pathSep + "consumer.log";
        String string2 = this._releaseDir + this.pathSep + this._wsDir + this.pathSep + "props" + this.pathSep + "ws.properties";
        ResourceBundle resourceBundle = null;
        try {
            object = new File(string2);
            if (((File)object).exists() && ((File)object).isFile() && ((File)object).canRead()) {
                resourceBundle = new PropertyResourceBundle(new BufferedInputStream(new FileInputStream((File)object)));
            } else {
                this.logEvent(this, "dbg", string2 + " doesn't exists, and/or can't read, and/or not file.");
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
        object = "";
        String string3 = "";
        if (resourceBundle != null) {
            try {
                string3 = "com.sybase.ase.ws.producer.httpport";
                object = resourceBundle.getString(string3);
                if (object != null && ((String)object).length() != 0) {
                    this.pHTTP = object;
                    serverPort.reservePort(ASEResourceGetter.getString("ws_producer_http_number"), this.pHTTP);
                    this.logEvent(this, "dbg", "Read " + string2 + " : " + string3 + "=" + (String)object);
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "dbg", "Can't read property '" + string3 + "' from " + string2);
            }
            try {
                string3 = "com.sybase.ase.ws.producer.ssl.httpsport";
                object = resourceBundle.getString(string3);
                if (object != null && ((String)object).length() != 0) {
                    this.pHTTPs = object;
                    serverPort.reservePort(ASEResourceGetter.getString("ws_producer_https_number"), this.pHTTPs);
                    this.logEvent(this, "dbg", "Read " + string2 + " : " + string3 + "=" + (String)object);
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "dbg", "Can't read property '" + string3 + "' from " + string2);
            }
            try {
                string3 = "com.sybase.ase.ws.producer.logfilename";
                object = resourceBundle.getString(string3);
                if (object != null && ((String)object).length() != 0) {
                    this.pLog = object;
                    this.logEvent(this, "dbg", "Read " + string2 + " : " + string3 + "=" + (String)object);
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "dbg", "Can't read property '" + string3 + "' from " + string2);
            }
            try {
                string3 = "com.sybase.ase.ws.consumer.httpport";
                object = resourceBundle.getString(string3);
                if (object != null && ((String)object).length() != 0) {
                    this.cPortNumber = object;
                    serverPort.reservePort(ASEResourceGetter.getString("ws_consumer_port_number"), this.cPortNumber);
                    this.logEvent(this, "dbg", "Read " + string2 + " : " + string3 + "=" + (String)object);
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "dbg", "Can't read property '" + string3 + "' from " + string2);
            }
            try {
                string3 = "com.sybase.ase.ws.consumer.logfilename";
                object = resourceBundle.getString(string3);
                if (object != null && ((String)object).length() != 0) {
                    this.cLog = object;
                    this.logEvent(this, "dbg", "Read " + string2 + " : " + string3 + "=" + (String)object);
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "dbg", "Can't read property '" + string3 + "' from " + string2);
            }
        }
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        WizardUI wizardUI = wizardBeanEvent.getUserInterface();
        if (wizardUI != null) {
            wizardUI.setBusy();
        }
        boolean bl = super.queryEnter(wizardBeanEvent);
        if (wizardUI != null) {
            wizardUI.clearBusy();
        }
        return bl;
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        return super.entered(wizardBeanEvent);
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        super.execute(wizardBeanEvent);
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        Object[] objectArray;
        String string = "";
        boolean bl = true;
        ServerPort serverPort = ServerPort.getInstanceServerPort(this._releaseDir, this._ocsDir);
        try {
            string = "ws_producer_http_number";
            serverPort.unReservePort(ASEResourceGetter.getString(string));
            serverPort.isPortUsed(Integer.parseInt(this.getProducerHttpPortNumber()));
            serverPort.reservePort(ASEResourceGetter.getString(string), this.getProducerHttpPortNumber());
        }
        catch (Exception exception) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("ws_producer_http_number"), exception.getMessage(), 4);
            bl = false;
        }
        try {
            string = "ws_producer_https_number";
            serverPort.unReservePort(ASEResourceGetter.getString(string));
            serverPort.isPortUsed(Integer.parseInt(this.getProducerHttpsPortNumber()));
            serverPort.reservePort(ASEResourceGetter.getString(string), this.getProducerHttpsPortNumber());
        }
        catch (Exception exception) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("ws_producer_https_number"), exception.getMessage(), 4);
            bl = false;
        }
        try {
            InetAddress.getAllByName(this.pHostName);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[]{this.pHostName};
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("ws_producer_hostname"), ASEResourceGetter.getAltFormatted("ws_producer_unknown_hostname", objectArray2), 4);
            bl = false;
        }
        if (!this.certPassword.equals(this.certRetryPassword)) {
            objectArray = new Object[]{ASEResourceGetter.getString("ws_cert_password")};
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("ws_password_not_match", objectArray), 4);
            bl = false;
        }
        if (this.certPassword.length() < 6) {
            objectArray = new Object[]{ASEResourceGetter.getString("ws_cert_password")};
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("ws_password_too_short", objectArray), 4);
            bl = false;
        }
        if (!this.keystorePassword.equals(this.keystoreRetryPassword)) {
            objectArray = new Object[]{ASEResourceGetter.getString("ws_keystore_password")};
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("ws_password_not_match", objectArray), 4);
            bl = false;
        }
        if (this.keystorePassword.length() < 6) {
            objectArray = new Object[]{ASEResourceGetter.getString("ws_keystore_password")};
            this.getWizard().getUI().displayUserMessage((String)objectArray[0], ASEResourceGetter.getAltFormatted("ws_password_too_short", objectArray), 4);
            bl = false;
        }
        try {
            string = "ws_consumer_port_number";
            serverPort.unReservePort(ASEResourceGetter.getString(string));
            serverPort.isPortUsed(Integer.parseInt(this.getConsumerPortNumber()));
            serverPort.reservePort(ASEResourceGetter.getString(string), this.getConsumerPortNumber());
        }
        catch (Exception exception) {
            this.getWizard().getUI().displayUserMessage(ASEResourceGetter.getString("ws_consumer_port_number"), exception.getMessage(), 4);
            bl = false;
        }
        return bl;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        WizardBean wizardBean = this.getConfigCustomServerInputPanel(this.getWizardTree().getRoot());
        String string = "";
        boolean bl = false;
        if (wizardBean != null) {
            string = wizardBean.getBeanId();
            bl = ((ConfigCustomServerInputPanel)wizardBean).getCustomConfigureWebServices();
        }
        if (n == 2 && !bl) {
            return null;
        }
        String string2 = this.resolveString("$P(displayName)");
        String string3 = ASEResourceGetter.getString("configure_new_ws_title");
        StringBuffer stringBuffer = new StringBuffer(ASEResourceGetter.getString("server_options"));
        stringBuffer.append("<enum>");
        String string4 = ASEResourceGetter.getString("custom_configure_new_servers_title");
        Object[] objectArray = new Object[]{string4, string};
        stringBuffer.append("<value>" + ASEResourceGetter.getAltFormatted("new_server_response_must_true", objectArray) + "</value>");
        stringBuffer.append("</enum>");
        String string5 = this.getBeanId();
        String string6 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".producerHttpPortNumber=" + this.getProducerHttpPortNumber());
        } else {
            stringBuffer2.append("-W " + string5 + ".producerHttpPortNumber=" + this.getProducerHttpPortNumber());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".producerHttpsPortNumber=" + this.getProducerHttpsPortNumber());
        } else {
            stringBuffer2.append("-W " + string5 + ".producerHttpsPortNumber=" + this.getProducerHttpsPortNumber());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".producerHostName=" + this.getProducerHostName());
        } else {
            stringBuffer2.append("-W " + string5 + ".producerHostName=" + this.getProducerHostName());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".producerLogFile=" + this.getProducerLogFile());
        } else {
            stringBuffer2.append("-W " + string5 + ".producerLogFile=" + this.getProducerLogFile());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".certificatePassword =" + this.getCertificatePassword());
        } else {
            stringBuffer2.append("-W " + string5 + ".certificatePassword=" + this.getCertificatePassword());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".keystorePassword =" + this.getKeystorePassword());
        } else {
            stringBuffer2.append("-W " + string5 + ".keystorePassword =" + this.getKeystorePassword());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".consumerPortNumber=" + this.getConsumerPortNumber());
        } else {
            stringBuffer2.append("-W " + string5 + ".consumerPortNumber=" + this.getConsumerPortNumber());
        }
        stringBuffer2.append(string6);
        if (n == 1) {
            stringBuffer2.append("### -W " + string5 + ".consumerLogFile=" + this.getConsumerLogFile());
        } else {
            stringBuffer2.append("-W " + string5 + ".consumerLogFile=" + this.getConsumerLogFile());
        }
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string3, stringBuffer.toString(), stringBuffer2.toString())};
    }

    public void setSybaseWs(String string) {
        this._wsDir = string;
    }

    public String getSybaseWs() {
        return this._wsDir;
    }

    public void setProducerHttpPortNumber(String string) {
        this.pHTTP = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_producer_http_number"));
    }

    public String getProducerHttpPortNumber() {
        return this.pHTTP;
    }

    public void setProducerHttpsPortNumber(String string) {
        this.pHTTPs = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_producer_https_number"));
    }

    public String getProducerHttpsPortNumber() {
        return this.pHTTPs;
    }

    public void setProducerHostName(String string) {
        this.pHostName = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_producer_hostname"));
    }

    public String getProducerHostName() {
        return this.pHostName;
    }

    public void setProducerLogFile(String string) {
        this.pLog = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_producer_log_file"));
    }

    public String getProducerLogFile() {
        return this.pLog;
    }

    public void setCertificatePassword(String string) {
        this.certPassword = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_cert_password"));
    }

    public String getCertificatePassword() {
        return this.certPassword;
    }

    public void setCertificateRetryPassword(String string) {
        this.certRetryPassword = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_cert_retry_password"));
    }

    public String getCertificateRetryPassword() {
        return this.certRetryPassword;
    }

    public void setKeystorePassword(String string) {
        this.keystorePassword = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_keystore_password"));
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystoreRetryPassword(String string) {
        this.keystoreRetryPassword = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_keystore_retry_password"));
    }

    public String getKeystoreRetryPassword() {
        return this.keystoreRetryPassword;
    }

    public void setConsumerPortNumber(String string) {
        this.cPortNumber = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_consumer_port_number"));
    }

    public String getConsumerPortNumber() {
        return this.cPortNumber;
    }

    public void setConsumerLogFile(String string) {
        this.cLog = string;
        this.propertyChanged(ASEResourceGetter.getString("ws_consumer_log_file"));
    }

    public String getConsumerLogFile() {
        return this.cLog;
    }
}

