/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizardx.panels.TextDisplayPanel;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import java.io.File;
import java.util.Vector;

public class DeleteFilesPanel
extends TextDisplayPanel {
    protected String[] fileDescriptors = new String[0];
    private FileInfo[] fiArray = new FileInfo[0];

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.createFileInfoArray();
        int n = this.fiArray.length;
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            object = this.fiArray[i];
            stringBuffer.append("<li>" + ((FileInfo)object).description + ": " + ((FileInfo)object).name + "</li> ");
        }
        Object[] objectArray = new Object[]{stringBuffer};
        object = this.getText();
        this.setText(ASEResourceGetter.getAltFormatted("device_exists_text", objectArray));
        return super.queryEnter(wizardBeanEvent);
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        if (wizardBeanEvent.getUserInterface() != null) {
            return;
        }
        this.createFileInfoArray();
        int n = this.fiArray.length;
        for (int i = 0; i < n; ++i) {
            FileInfo fileInfo = this.fiArray[i];
            try {
                if (fileInfo.file.delete()) {
                    this.logEvent(this, "dbg", "Deleted '" + fileInfo.name + "'");
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logEvent(this, "err", "Failed to delete " + fileInfo.description + " '" + fileInfo.name + "'");
        }
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        boolean bl = true;
        super.queryExit(wizardBeanEvent);
        int n = this.fiArray.length;
        for (int i = 0; i < n; ++i) {
            FileInfo fileInfo = this.fiArray[i];
            try {
                if (fileInfo.file.delete()) {
                    this.logEvent(this, "dbg", "Deleted '" + fileInfo.name + "'");
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = false;
            this.logEvent(this, "err", "Failed to delete " + fileInfo.description + " '" + fileInfo.name + "'");
            Object[] objectArray = new Object[]{fileInfo.name};
            this.getWizard().getUI().displayUserMessage(fileInfo.description, ASEResourceGetter.getAltFormatted("cannot_delete_file", objectArray), 4);
        }
        return bl;
    }

    public void setFileDescriptors(String[] stringArray) {
        this.fileDescriptors = stringArray;
    }

    public String[] getFileDescriptors() {
        return this.fileDescriptors;
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putClass("com.installshield.wizardx.panels.TextDisplayPanel");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.DeleteFilesPanel$FileInfo");
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent(this, "err", exception);
        }
    }

    private void createFileInfoArray() {
        int n = this.fileDescriptors.length;
        Vector<FileInfo> vector = new Vector<FileInfo>(n);
        for (int i = 0; i < n; ++i) {
            FileInfo fileInfo = new FileInfo(this.fileDescriptors[i]);
            if (fileInfo.file == null) continue;
            vector.add(fileInfo);
        }
        this.fiArray = vector.toArray(new FileInfo[0]);
    }

    protected String resolveString(String string) {
        return super.resolveString(string);
    }

    protected class FileInfo {
        protected File file = null;
        protected String description = null;
        protected String name = null;

        private FileInfo() {
        }

        protected FileInfo(String string) {
            int n = string.indexOf(61);
            if (n == -1) {
                new Exception("Coding error: Missing '=' in fileDescriptor '" + string + "'").printStackTrace();
            }
            String string2 = ASEResourceGetter.getString(string.substring(0, n));
            String string3 = DeleteFilesPanel.this.resolveString(string.substring(n + 1, string.length()));
            if (string3 != null && string3.length() > 0) {
                try {
                    File file = new File(string3);
                    if (file.isFile() && file.exists()) {
                        this.file = file;
                        this.description = string2;
                        this.name = string3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

