/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.util.Progress;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.JFlowLabel;
import com.installshield.wizard.swing.SwingProgressRendererImpl;
import com.sybase.ismp.ase.wizardbean.ExecCommandProgressRenderer;
import com.sybase.ismp.ase.wizardbean.ui.UIConstants;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExecCommandProgressRendererSwingImpl
extends SwingProgressRendererImpl {
    private JFlowLabel _title = null;
    private String _curStatusDetail = "";
    private String _curLastMessage = "";
    private JTextArea _outputArea = null;
    private JProgressBar _progressBar = null;
    private boolean _progressBarVisible = false;

    public void initialize() {
        ExecCommandProgressRenderer execCommandProgressRenderer = (ExecCommandProgressRenderer)this.getProgressRenderer();
        this._progressBarVisible = execCommandProgressRenderer.isProgressBarVisible();
        this._curStatusDetail = "";
        this._curLastMessage = "";
        this.setVisible(false);
        this.setLayout(new ColumnLayout(UIConstants.SYB_COLUMN_LAYOUT_SPACING));
        this.setBackground(UIConstants.SYB_BACKGROUND_COLOR);
        this._title = new JFlowLabel(" ");
        this.add((Component)this._title, ColumnConstraints.createHorizontalFill());
        this._outputArea = new JTextArea("");
        this._outputArea.setFont(UIConstants.SYB_STANDARD_FONT);
        this._outputArea.setBackground(UIConstants.SYB_BACKGROUND_COLOR);
        this._outputArea.setEditable(false);
        this._outputArea.setLineWrap(execCommandProgressRenderer.getWrapDetail());
        this._outputArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this._outputArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setBackground(UIConstants.SYB_BACKGROUND_COLOR);
        ColumnConstraints columnConstraints = new ColumnConstraints(4, 4);
        this.add((Component)jScrollPane, columnConstraints);
        if (this._progressBarVisible) {
            this.add(Spacing.createVerticalSpacing(4));
            this._progressBar = new JProgressBar();
            this.add((Component)this._progressBar, ColumnConstraints.createHorizontalFill());
            this._progressBar.setMinimum(0);
            this._progressBar.setMaximum(100);
            this._progressBar.setStringPainted(true);
            if (execCommandProgressRenderer.getOverrideSwingColors()) {
                this._progressBar.setForeground(PropertyUtils.createColor(execCommandProgressRenderer.getProgressForeground(), this._progressBar.getForeground()));
                this._progressBar.setBackground(PropertyUtils.createColor(execCommandProgressRenderer.getProgressBackground(), this._progressBar.getBackground()));
            }
        }
        this.setVisible(true);
    }

    public void starting() {
        Font font = this._title.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this._title.setFont(font2);
        if (this._progressBarVisible) {
            this._progressBar.setValue(0);
        }
        this._outputArea.setText("");
        this._curStatusDetail = "";
        this._curLastMessage = "";
    }

    public void updateProgress(Progress progress) {
        String string;
        boolean bl = false;
        String string2 = progress.getTitle();
        if (string2 != null && string2.length() > 0 && !string2.equals(this._title.getText())) {
            this._title.setText(string2);
            bl = true;
        }
        if ((string = progress.getStatusDetail()) != null && string.length() > 0 && !string.equals(this._curStatusDetail)) {
            this._curStatusDetail = string;
            this.appendToOutputText(string);
            bl = true;
        }
        if ((string = progress.getLastMessage()) != null && string.length() > 0 && !string.equals(this._curLastMessage)) {
            this._curLastMessage = string;
            this.appendToOutputText(string);
            bl = true;
        }
        if (this._progressBarVisible) {
            this._progressBar.setValue(progress.getPercentComplete());
            bl = true;
        }
        if (bl) {
            this.validate();
            this.repaint();
        }
    }

    public JComponent getComponent() {
        return this;
    }

    private synchronized void appendToOutputText(String string) {
        this._outputArea.append(string);
        this._outputArea.setCaretPosition(this._outputArea.getText().length());
    }
}

