/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.util.FileUtils;
import com.installshield.util.ProcessOutputHandler;
import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.actions.ExecWizardAction;
import com.sybase.ismp.ase.ExecCommand;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ExecCommandWithProgress
extends ExecWizardAction {
    protected String[] environment = new String[0];
    protected String workdir = "$P(installLocation)";
    protected int estimatedTimeToCompletion = 60;
    private RunnableWizardBeanState _state;
    private ExecCommand _execCommand = null;
    private long _millisPerIncrement = 0L;
    private long _lastTime = 0L;
    private String errorMessages = "";
    private StringBuffer _errorBuffer = null;
    private int returnValue = 0;

    public void setEstimatedTimeToCompletion(int n) {
        this.estimatedTimeToCompletion = n;
    }

    public int getEstimatedTimeToCompletion() {
        return this.estimatedTimeToCompletion;
    }

    public int getPercentComplete(String string) {
        return this._state.getPercentComplete();
    }

    public void recalibrateProgress(String string) {
        int n = this.getPercentComplete(string);
        int n2 = this._state.getPercentComplete();
        if (n > 0 && n2 > 0) {
            this._millisPerIncrement = (int)((double)this._millisPerIncrement * (double)n2 / (double)n);
        }
        if (n > 99) {
            n = 99;
        }
        this._state.setPercentComplete(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProgress() {
        this._millisPerIncrement = this.estimatedTimeToCompletion * 1000 / 100;
        this._lastTime = System.currentTimeMillis();
        RunnableWizardBeanState runnableWizardBeanState = this._state;
        synchronized (runnableWizardBeanState) {
            this._state.clear();
            this._state.setLastMessage("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementProgress() {
        long l;
        if (this._state.getPercentComplete() < 99 && (l = System.currentTimeMillis()) - this._lastTime >= this._millisPerIncrement) {
            RunnableWizardBeanState runnableWizardBeanState = this._state;
            synchronized (runnableWizardBeanState) {
                this._state.incrementProgress(1);
            }
            this._lastTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WizardBeanEvent wizardBeanEvent) {
        this._state = this.getState();
        this._state.setTitle(this.resolveString(this.getDescription()));
        this.resetProgress();
        Thread thread = new Thread((Runnable)((Object)this));
        thread.setPriority(5);
        thread.start();
        while (this._execCommand == null || this._execCommand.getStatus() != 2 && this._execCommand.getStatus() != 3) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.incrementProgress();
        }
        if (!this._state.isCanceled()) {
            RunnableWizardBeanState runnableWizardBeanState = this._state;
            synchronized (runnableWizardBeanState) {
                this._state.setPercentComplete(100);
            }
        }
        this.setReturnValue(this._execCommand.getExitCode());
        this.logEvent((Object)this, "dbg", "returnValue = " + this.returnValue);
        this.setErrorMessages(this._errorBuffer.toString());
        this._execCommand = null;
        this.resetProgress();
    }

    public int getStatus() {
        return this._execCommand != null ? this._execCommand.getStatus() : 0;
    }

    public void setReturnValue(int n) {
        this.returnValue = n;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void run() {
        try {
            this._execCommand = this.createExecCommand();
            this._execCommand.executeProcess();
        }
        catch (Exception exception) {
            this._errorBuffer.append(exception.getMessage());
            this.logEvent((Object)this, "err", exception);
            this.logEvent((Object)this, "dbg", "returnValue = " + this.returnValue);
        }
    }

    protected ExecCommand createExecCommand() {
        this.setReturnValue(3);
        this._errorBuffer = new StringBuffer("");
        try {
            String string = this.isBundleExecutable() ? this.getProcessRuntimeLocation() : this.resolveString(this.getCommand());
            this.logEvent((Object)this, "dbg", "command: '" + string + "'");
            String[] stringArray = this.getArguments();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.resolveString(stringArray[i]);
                this.logEvent((Object)this, "dbg", "arg[" + i + "]: '" + stringArray2[i] + "'");
            }
            String[] stringArray3 = new String[this.environment.length];
            for (int i = 0; i < this.environment.length; ++i) {
                stringArray3[i] = this.resolveString(this.environment[i]);
                this.logEvent((Object)this, "dbg", "env[" + i + "]: '" + stringArray3[i] + "'");
            }
            String string2 = this.resolveString(this.workdir);
            File file = new File(string2);
            if (file.isDirectory()) {
                this.logEvent((Object)this, "dbg", "... in '" + string2 + "' directory.");
                this._execCommand = new ExecCommand(string, stringArray2, stringArray3, string2);
            } else {
                this.logEvent((Object)this, "dbg", "... in current directory.");
                this._execCommand = new ExecCommand(string, stringArray2, stringArray3);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent((Object)this, "err", serviceException);
        }
        this._execCommand.setProcessOutputHandler((ProcessOutputHandler)new ExecCommandOutputHandler());
        return this._execCommand;
    }

    private String getProcessRuntimeLocation() throws ServiceException {
        String string = null;
        String string2 = FileUtils.normalizeFileName(this.getCommand());
        String string3 = new File(string2).getName();
        try {
            string = FileUtils.createTempFile(this.getResource(this.getBeanId() + File.separator + string3), FileUtils.getName(string3));
            FileService fileService = (FileService)this.getServices().getService("fileService");
            fileService.setFileExecutable(string);
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot extract executable " + string3 + ": " + iOException);
        }
        return string;
    }

    public void setEnvironment(String[] stringArray) {
        this.environment = stringArray;
    }

    public String[] getEnvironment() {
        return this.environment;
    }

    public void setWorkDirectory(String string) {
        this.workdir = string;
    }

    public String getWorkDirectory() {
        return this.workdir;
    }

    public void setErrorMessages(String string) {
        this.errorMessages = string;
    }

    public String getErrorMessages() {
        return this.errorMessages;
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        String string = this.getCommand();
        if (string == null || string.equals("")) {
            wizardBuilderSupport.logEvent((Object)this, "err", "You must specify a command to run as the 'Command' property for this bean.");
        }
        if (this.getProgressRenderer() == null) {
            wizardBuilderSupport.logEvent((Object)this, "err", "You must specify an ExecCommandProgressRenderer to run as the 'Progress Renderer' property for this bean");
        }
        try {
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ExecCommandWithProgressBeanInfo");
            wizardBuilderSupport.putClass("com.installshield.wizardx.actions.ExecWizardAction");
            wizardBuilderSupport.putClass("com.installshield.wizardx.actions.ExecWizardActionBeanInfo");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.ExecCommand");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.ExecCommand$InputSink");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.ExecCommand$InputSinkTerminator");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.ExecCommand$OutputHandler");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.ExecCommand$OutputSink");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ExecCommandWithProgress$ExecCommandOutputHandler");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ExecCommandProgressRenderer");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ExecCommandProgressRendererConsoleImpl");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ExecCommandProgressRendererSwingImpl");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.ui.UIConstants");
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent((Object)this, "err", exception);
        }
    }

    public class ExecCommandOutputHandler
    implements ProcessOutputHandler {
        protected String _stdoutLastMessage = "";
        protected String _stderrLastMessage = "";

        public ExecCommandOutputHandler() {
        }

        public ExecCommandOutputHandler(ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processOutputData(InputStream inputStream) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = "";
            String string3 = System.getProperty("line.separator");
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    String string4 = this.removeUnprintable(string + string3);
                    ExecCommandWithProgress.this.logEvent(this, "err", string4);
                    ExecCommandWithProgress.this._errorBuffer.append(string4);
                    if (this._stdoutLastMessage.equals(string4)) {
                        string2 = string4.concat(" ");
                    } else {
                        string2 = string4;
                        this._stdoutLastMessage = string4;
                    }
                    RunnableWizardBeanState runnableWizardBeanState = ExecCommandWithProgress.this._state;
                    synchronized (runnableWizardBeanState) {
                        ExecCommandWithProgress.this._state.setStatusDetail(string2);
                        ExecCommandWithProgress.this.recalibrateProgress(string4);
                    }
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processErrorData(InputStream inputStream) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = System.getProperty("line.separator");
            String string3 = "";
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    String string4 = this.removeUnprintable(string + string2);
                    ExecCommandWithProgress.this.logEvent(this, "err", string4);
                    ExecCommandWithProgress.this._errorBuffer.append(string4);
                    if (this._stderrLastMessage.equals(string4)) {
                        string3 = string4.concat(" ");
                    } else {
                        string3 = string4;
                        this._stderrLastMessage = string4;
                    }
                    RunnableWizardBeanState runnableWizardBeanState = ExecCommandWithProgress.this._state;
                    synchronized (runnableWizardBeanState) {
                        ExecCommandWithProgress.this._state.setLastMessage(string3);
                        ExecCommandWithProgress.this._state.setPercentComplete(ExecCommandWithProgress.this._state.getPercentComplete());
                    }
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private String removeUnprintable(String string) {
            if (string == null) {
                return null;
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                if (!Character.isWhitespace(cArray[i]) && Character.isISOControl(cArray[i])) continue;
                stringBuffer.append(cArray[i]);
            }
            return stringBuffer.toString();
        }
    }
}

