/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class FileSystemManipulationWizardAction
extends WizardAction {
    public static final int COPY = 0;
    public static final int MOVE = 1;
    public static final int DELETE = 2;
    private FileService fileService = null;
    private String source = "";
    private String destination = "";
    private int action = 0;

    public void setSource(String string) {
        this.source = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public int getAction() {
        return this.action;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            this.fileService = (FileService)this.getService("fileService");
            String string = "";
            String string2 = "";
            string = this.resolveString(this.source);
            string2 = this.resolveString(this.destination);
            switch (this.action) {
                case 0: {
                    this.logEvent(this, "dbg", "Copying " + string + " to " + string2);
                    this.copy(string, string2);
                    break;
                }
                case 1: {
                    this.logEvent(this, "dbg", "Moving " + string + " to " + string2);
                    this.copy(string, string2);
                    this.delete(string);
                    break;
                }
                case 2: {
                    this.logEvent(this, "dbg", "Deleting " + string);
                    this.delete(string);
                    break;
                }
                default: {
                    this.logEvent(this, "err", "Unknown action!!!");
                }
            }
            return;
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
            return;
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("fileService");
    }

    private void copy(String string, String string2) throws ServiceException {
        if (!this.fileService.fileExists(string)) {
            this.logEvent(this, "wrn", string + " doesn't exist; skip copy.");
            return;
        }
        if (this.fileService.isDirectory(string)) {
            this.fileService.copyDirectory(string, string2, true, true);
        } else {
            this.fileService.copyFile(string, string2, true);
        }
    }

    private void delete(String string) throws ServiceException {
        if (!this.fileService.fileExists(string)) {
            this.logEvent(this, "wrn", string + " doesn't exist; skip delete.");
            return;
        }
        if (this.fileService.isDirectory(string)) {
            this.fileService.deleteDirectory(string, false, true);
        } else {
            this.fileService.deleteFile(string);
        }
    }
}

