/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.sybase.ismp.ase.LogWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PropertyInspector
extends ExtendedWizardPanel {
    private String[] _reportableProperties = new String[0];
    public static final String PROPERTIES_REPORTABLE_PROPERTIES = "reportableProperties";
    private Vector _reportableBeansAsVector = new Vector();
    private boolean _suiteFlag = false;
    public static final String PROPERTIES_SUITE_FLAG = "suite";
    public static final boolean IN_SUITE = true;
    public static final boolean IN_STANDALONE = false;
    protected Hashtable _propertyHash = new Hashtable();
    public static final String PROPERTY_DELIMITER = ".";
    public static final String PROPERTY_PRODUCT = "P";
    public static final String PROPERTY_WIZARD = "W";

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.LogWriter");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
        }
        catch (IOException iOException) {
            LogWriter.logException((WizardServices)super.getServices(), (Exception)iOException);
        }
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        String string;
        StringTokenizer stringTokenizer;
        this._reportableBeansAsVector = new Vector<String>(Arrays.asList(this._reportableProperties));
        for (int i = 0; i < this._reportableProperties.length; ++i) {
            stringTokenizer = new StringTokenizer(this._reportableProperties[i], PROPERTY_DELIMITER);
            string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            WizardServices wizardServices = null;
            if (this._suiteFlag) {
                wizardServices = PropertyInspector.getSubWizardServices(string, super.getServices());
            } else if (!this._suiteFlag) {
                wizardServices = super.getServices();
            }
            this._propertyHash.put(this._reportableProperties[i], PropertyInspector.inspectProperty(string3, string4, string2, wizardServices));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringTokenizer = this._propertyHash.keys();
        while (stringTokenizer.hasMoreElements()) {
            string = (String)stringTokenizer.nextElement();
            stringBuffer.append(string + "---------------------" + (String)this._propertyHash.get(string) + "\n");
        }
        if (!super.isConsoleInteraction()) {
            JOptionPane.showMessageDialog(null, stringBuffer);
        } else {
            TTYDisplay.pageText(stringBuffer.toString());
        }
        return true;
    }

    public String[] getReportableProperties() {
        return this._reportableProperties;
    }

    public void setReportableProperties(String[] stringArray) {
        this._reportableProperties = stringArray;
    }

    public boolean getSuite() {
        return this._suiteFlag;
    }

    public void setSuite(boolean bl) {
        this._suiteFlag = bl;
    }

    public static Object inspectProperty(String string, String string2, String string3, WizardServices wizardServices) {
        if (string == null && string3.equals(PROPERTY_PRODUCT)) {
            try {
                ProductService productService = (ProductService)wizardServices.getService("productService");
                return productService.getProductBeanProperty("/product.xml", null, string2);
            }
            catch (ServiceException serviceException) {
                LogWriter.logException((WizardServices)wizardServices, (Exception)serviceException);
                return null;
            }
        }
        if (string3.equals(PROPERTY_PRODUCT)) {
            return wizardServices.resolveString("$P(" + string + PROPERTY_DELIMITER + string2 + ")");
        }
        if (string3.equals(PROPERTY_WIZARD)) {
            return wizardServices.resolveString("$W(" + string + PROPERTY_DELIMITER + string2 + ")");
        }
        return null;
    }

    public static Object resolveProperty(String string, Wizard wizard) {
        if (string.startsWith("$P") || string.startsWith("$W")) {
            String string2 = string.substring(string.indexOf("(") + 1, string.lastIndexOf(")"));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, PROPERTY_DELIMITER);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string.startsWith("$P")) {
                try {
                    ProductService productService = (ProductService)wizard.getServices().getService("productService");
                    return productService.getProductBeanProperty("/product.xml", string3, string4);
                }
                catch (ServiceException serviceException) {
                    serviceException.printStackTrace();
                    return null;
                }
            }
            try {
                WizardTree wizardTree = wizard.getWizardTree();
                WizardBean wizardBean = wizardTree.getBean(string3);
                Class<?> clazz = wizardBean.getClass();
                String string5 = "get" + string4.substring(0, 1).toUpperCase() + string4.substring(1);
                Method method = clazz.getMethod(string5, null);
                return method.invoke((Object)wizardBean, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static WizardServices getSubWizardServices(String string, WizardServices wizardServices) {
        try {
            String string2 = wizardServices.resolveString("$P(" + string + ".installer)");
            return wizardServices.getWizardServices(string2);
        }
        catch (ServiceException serviceException) {
            LogWriter.logException((WizardServices)wizardServices, (Exception)serviceException);
            return null;
        }
    }

    public static Wizard getSubWizard(String string, Wizard wizard) {
        try {
            return wizard.getExternalWizard(string);
        }
        catch (WizardException wizardException) {
            wizardException.printStackTrace();
            LogWriter.logException((WizardServices)wizard.getServices(), (Exception)wizardException);
            return null;
        }
    }

    public static String[] getAllProductReferenceBeanIds(WizardServices wizardServices) {
        try {
            ProductService productService = (ProductService)wizardServices.getService("productService");
            Properties[] propertiesArray = productService.getProductBeanChildren("/product.xml", null, new String[]{"beanId"}, null);
            String[] stringArray = new String[propertiesArray.length];
            for (int i = 0; i < propertiesArray.length; ++i) {
                stringArray[i] = (String)propertiesArray[i].get("beanId");
            }
            return stringArray;
        }
        catch (ServiceException serviceException) {
            LogWriter.logException((WizardServices)wizardServices, (Exception)serviceException);
            return null;
        }
    }

    public static WizardServices[] getAllProductReferenceWizardServices(WizardServices wizardServices) {
        try {
            String[] stringArray = PropertyInspector.getAllProductReferenceBeanIds(wizardServices);
            WizardServices[] wizardServicesArray = new WizardServices[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                wizardServicesArray[i] = PropertyInspector.getSubWizardServices(stringArray[i], wizardServices);
            }
            return wizardServicesArray;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Wizard[] getAllProductReferenceWizards(Wizard wizard) {
        try {
            String[] stringArray = PropertyInspector.getAllProductReferenceBeanIds(wizard.getServices());
            Wizard[] wizardArray = new Wizard[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                wizardArray[i] = PropertyInspector.getSubWizard(wizard.getServices().resolveString("$P(" + stringArray[i] + ".installer)"), wizard);
            }
            return wizardArray;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

