/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.ldap.LDAPWarning;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;

public class ServerPort {
    private static boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private static Hashtable _serverPorts = new Hashtable();
    private Category LOG = Category.getInstance((class$com$sybase$ismp$ase$wizardbean$ServerPort == null ? (class$com$sybase$ismp$ase$wizardbean$ServerPort = ServerPort.class$("com.sybase.ismp.ase.wizardbean.ServerPort")) : class$com$sybase$ismp$ase$wizardbean$ServerPort).getName());
    private SyInterfacesDriver iDriver = null;
    private SyLDAPServer ldapServer = null;
    private String[] servers = null;
    private static String _hostName = "localhost";
    public static final String SYBASE_OCS = "OCS-15_0";
    private String _releaseDir = null;
    private String _ocsDir = null;
    private Properties _resevedPorts = new Properties();
    static /* synthetic */ Class class$com$sybase$ismp$ase$wizardbean$ServerPort;

    ServerPort(String string, String string2) {
        this._releaseDir = string;
        this._ocsDir = string2;
        if (this.initLibctlDriver()) {
            this.servers = this.ldapServer.getASEServerNames();
        } else if (this.initInterfaceDriver()) {
            this.servers = this.iDriver.getServers();
        }
    }

    public static ServerPort getInstanceServerPort(String string, String string2) {
        String string3 = string + File.separator + string2;
        ServerPort serverPort = (ServerPort)_serverPorts.get(string3);
        if (serverPort == null) {
            serverPort = new ServerPort(string, string2);
            _serverPorts.put(string3, serverPort);
        }
        return serverPort;
    }

    public void reservePort(String string, String string2) {
        this._resevedPorts.setProperty(string, string2);
    }

    public void unReservePort(String string) {
        this._resevedPorts.remove(string);
    }

    private boolean initInterfaceDriver() {
        String string = this._releaseDir + File.separator + "interfaces";
        if (_isWindows) {
            string = this._releaseDir + File.separator + "ini" + File.separator + "sql.ini";
        }
        try {
            this.iDriver = new SyInterfacesDriver(string);
        }
        catch (Exception exception) {
            this.LOG.debug("Failed to open interfaces file " + string);
            return false;
        }
        return true;
    }

    private boolean initLibctlDriver() {
        LibctlDriver libctlDriver;
        try {
            System.setProperty("sybase.home", this._releaseDir);
            System.setProperty("ocs.home", this._ocsDir);
            libctlDriver = new LibctlDriver();
        }
        catch (LDAPWarning lDAPWarning) {
            this.LOG.warn(lDAPWarning.getMessage());
            return false;
        }
        catch (Exception exception) {
            this.LOG.error(exception);
            return false;
        }
        Vector vector = libctlDriver.getLDAPServers();
        for (int i = 0; i < vector.size(); ++i) {
            this.ldapServer = (SyLDAPServer)vector.elementAt(i);
            try {
                if (this.ldapServer.connectLDAP(180)) {
                    this.ldapServer.initASEEntries();
                    this.LOG.debug("Connect to LDAP " + this.ldapServer.getHost() + ":" + this.ldapServer.getPort());
                    return true;
                }
                this.LOG.debug("Failed to connect to LDAP " + this.ldapServer.getHost() + ":" + this.ldapServer.getPort());
                continue;
            }
            catch (Exception exception) {
                this.ldapServer = null;
                this.LOG.debug("Failed to connect to LDAP " + this.ldapServer.getHost() + ":" + this.ldapServer.getPort());
            }
        }
        return false;
    }

    public boolean isServerNameUsed(String string) {
        if (this.servers == null) {
            return false;
        }
        for (int i = 0; i < this.servers.length; ++i) {
            if (!this.servers[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getUnusedServerName(String string) {
        if (!this.isServerNameUsed(string)) {
            return string;
        }
        int n = 0;
        while (this.isServerNameUsed(string + String.valueOf(++n))) {
        }
        return string + String.valueOf(n);
    }

    public boolean isPortUsed(int n) throws Exception {
        int n2;
        String string;
        Object object;
        int n3;
        Object[] objectArray = new Object[2];
        if (n < 1025 || n > 65535) {
            objectArray[0] = String.valueOf(n);
            throw new Exception(ASEResourceGetter.getAltFormatted("port_invalid_number", objectArray));
        }
        if (this.ldapServer != null && this.servers != null) {
            for (n3 = 0; n3 < this.servers.length; ++n3) {
                object = this.ldapServer.getASEServer(this.servers[n3]);
                string = object.getHost();
                n2 = -1;
                try {
                    n2 = Integer.parseInt(object.getPort());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                if (string == null || n2 == -1 || n != n2 || !string.equalsIgnoreCase(_hostName)) continue;
                objectArray[0] = String.valueOf(n);
                objectArray[1] = this.servers[n3];
                String string2 = ASEResourceGetter.getAltFormatted("port_in_ldap", objectArray);
                throw new Exception(string2);
            }
        } else if (this.iDriver != null && this.servers != null) {
            for (n3 = 0; n3 < this.servers.length; ++n3) {
                object = this.iDriver.getEntry(this.servers[n3]);
                string = object.getHost();
                n2 = -1;
                try {
                    n2 = Integer.parseInt(object.getPort());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                if (string == null || n2 == -1 || n != n2 || !string.equalsIgnoreCase(_hostName)) continue;
                objectArray[0] = String.valueOf(n);
                objectArray[1] = this.servers[n3];
                String string3 = ASEResourceGetter.getAltFormatted("port_in_ifile", objectArray);
                throw new Exception(string3);
            }
        }
        try {
            Socket socket = new Socket(_hostName, n);
            objectArray[0] = String.valueOf(n);
            object = ASEResourceGetter.getAltFormatted("port_in_use", objectArray);
            throw new Exception((String)object);
        }
        catch (IOException iOException) {
            String string4 = null;
            object = this._resevedPorts.propertyNames();
            while (object.hasMoreElements()) {
                string4 = object.nextElement().toString();
                int n4 = Integer.parseInt(this._resevedPorts.getProperty(string4));
                if (n4 != n) continue;
                objectArray[0] = String.valueOf(n);
                objectArray[1] = string4;
                String string5 = ASEResourceGetter.getAltFormatted("port_already_allocated", objectArray);
                throw new Exception(string5);
            }
            return false;
        }
    }

    public int getNextOpenPort(int n) {
        while (true) {
            try {
                while (this.isPortUsed(n)) {
                }
            }
            catch (Exception exception) {
                ++n;
                continue;
            }
            break;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            _hostName = "localhost";
        }
    }
}

