/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.product.Product;
import com.installshield.product.service.product.ProductService;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringUtils;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.console.ConsoleWizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.sybase.ismp.ase.OSUtil;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Category;

public class SybaseDestinationPanel
extends WizardPanel {
    private static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$wizardbean$SybaseDestinationPanel == null ? (class$com$sybase$ismp$ase$wizardbean$SybaseDestinationPanel = SybaseDestinationPanel.class$("com.sybase.ismp.ase.wizardbean.SybaseDestinationPanel")) : class$com$sybase$ismp$ase$wizardbean$SybaseDestinationPanel).getName());
    private String _release = "";
    private String productURL = "/product.xml";
    private FileService fileService = null;
    private String origTitle = "";
    private static final String CREATE_DIR = "createDirectoryResponse";
    private static final String YES_RESPONSE = "yes";
    private static final String NO_RESPONSE = "no";
    protected boolean hasEntered = false;
    static /* synthetic */ Class class$com$sybase$ismp$ase$wizardbean$SybaseDestinationPanel;

    public SybaseDestinationPanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, destination_dir_description)");
    }

    private String getProductInstallLocation() {
        String string = "";
        boolean bl = OSUtil.isOperatingSystemOk(0);
        try {
            ProductService productService = (ProductService)this.getService("productService");
            string = (String)productService.getProductBeanProperty(this.productURL, null, "installLocation");
            if (string != null) {
                this.logEvent(this, "dbg", "Product bean installLocation=" + string);
                return string;
            }
            if (bl) {
                Product product = (Product)productService.getSoftwareObjectTree(this.productURL).getRoot();
                RegistryService registryService = (RegistryService)this.getService("registryService");
                if (registryService.getNewestSoftwareObject(product.getKey().getUID()) != null && (string = (String)productService.getProductBeanProperty(this.productURL, null, "absoluteInstallLocation")) != null) {
                    this.resolveString(string);
                    this.logEvent(this, "dbg", "location of previous install: " + string);
                    return string;
                }
            }
            if ((string = this.resolveString("$E(SYBASE)")) != null && string.length() != 0 && !string.equals("null")) {
                this.logEvent(this, "dbg", "location of $SYBASE:" + string);
                return string;
            }
            string = bl ? this.resolveString("$N($D(install)/../sybase)") : this.resolveString("$D(install)/sybase");
            this.logEvent(this, "dbg", "default location:" + string);
            return string;
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
            return "";
        }
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        WizardUI wizardUI = wizardBeanEvent.getUserInterface();
        if (wizardUI != null) {
            wizardUI.setBusy();
        }
        super.queryEnter(wizardBeanEvent);
        this.hasEntered = true;
        if (wizardUI instanceof ConsoleWizardUI) {
            this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, destination_dir_description_console)");
        }
        try {
            this.fileService = (FileService)this.getService("fileService");
            String string = this.getProductInstallLocation();
            if (string != null && this.getRelease().length() == 0) {
                this.setRelease(this.resolveString(string));
            }
        }
        catch (Exception exception) {
            LOG.error(exception);
        }
        if (wizardUI != null) {
            wizardUI.clearBusy();
        }
        return true;
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        if (super.entered(wizardBeanEvent)) {
            if (this.origTitle.length() == 0) {
                this.origTitle = this.getWizard().getTitle();
            }
            this.getWizard().setTitle(this.origTitle + " - " + ASEResourceGetter.getString("destination_title"));
            return true;
        }
        return false;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        boolean bl = true;
        String string = this.getRelease();
        if (string.length() != 0 && (bl = this.validateDestination(wizardBeanEvent))) {
            bl = this.verifyVPD(wizardBeanEvent);
            this.updateProductTree(string);
        }
        if (bl) {
            this.logEvent(this, "dbg", "install location:" + string);
        }
        return bl;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        super.exited(wizardBeanEvent);
        this.getWizard().setTitle(this.origTitle);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean.ui");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.PropertyInspector");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.TypedKeyInfo");
            wizardBuilderSupport.putPackage("com.installshield.wizard.i18n");
            wizardBuilderSupport.putPackage("com.installshield.product.i18n");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.AWTMnemonicLibrary$1");
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ui");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.SybaseDestinationPanel");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.SybaseDestinationPanelSwingImpl");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.SybaseDestinationPanelBeanInfo");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.wizardbean.SybaseDestinationPanelConsoleImpl");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.OSInfo");
            wizardBuilderSupport.putClass("com.sybase.ismp.ase.OSUtil");
            wizardBuilderSupport.putPackage("com.installshield.beans.editors");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    private boolean validateDestination(WizardBeanEvent wizardBeanEvent) {
        block13: {
            if (StringUtils.isWhitespace(this._release)) {
                this.showLocalizedErrorMsg("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory", "DestinationPanel.specifyDirectory");
                return false;
            }
            if (!OSUtil.isOperatingSystemOk(0) && this._release.indexOf(32) != -1) {
                String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory");
                String string2 = ASEResourceGetter.getAltFormatted("destination_contains_spaces", new String[]{this._release});
                this.showErrorMsg(string, string2);
                return false;
            }
            try {
                this.fileService.validateFileName(this._release);
            }
            catch (ServiceException serviceException) {
                String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory");
                this.showErrorMsg(string, serviceException.getMessage());
                return false;
            }
            try {
                if (this.isInSilentMode()) break block13;
                if (!this.fileService.fileExists(this._release)) {
                    Object[] objectArray = new String[]{this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, yes)"), this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, no)")};
                    if (((String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.directoryNotExist"), objectArray, objectArray[1])).equals(objectArray[1])) {
                        return false;
                    }
                    break block13;
                }
                String[] stringArray = this.fileService.getDirectoryList(this._release, 0);
                if (Arrays.asList(stringArray).size() == 0) break block13;
                String string = "";
                if (OSUtil.isOperatingSystemOk(0)) {
                    try {
                        if (this.resolveString("$P(suite.displayName)").indexOf("Adaptive") < 0) {
                            string = ASEResourceGetter.getString("install_over_pre1251ASE");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String string3 = ASEResourceGetter.getAltFormatted("install_into_existing", new String[]{string});
                Object[] objectArray = new String[]{this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, yes)"), this.resolveString("$L(com.installshield.wizard.i18n.WizardResources, no)")};
                if (((String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory"), string3, objectArray, objectArray[1])).equals(objectArray[1])) {
                    return false;
                }
            }
            catch (Exception exception) {
                LOG.error(exception);
                return false;
            }
        }
        return this.isDirectoryWritable(this._release);
    }

    private void showErrorMsg(String string, String string2) {
        try {
            if (this.isInSilentMode()) {
                System.err.println(string);
                System.err.println(string2);
            } else {
                this.getWizard().getServices().displayUserMessage(string, string2, 4);
            }
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void showLocalizedErrorMsg(String string, String string2, String string3) {
        try {
            String string4 = LocalizedStringResolver.resolve(string, string2);
            String string5 = LocalizedStringResolver.resolve(string, string3);
            if (this.isInSilentMode()) {
                System.err.println(string4);
                System.err.println(string5);
            } else {
                this.getWizard().getServices().displayUserMessage(string4, string5, 4);
            }
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void showLocalizedErrorMsg(String string, String string2, String string3, String[] stringArray) {
        try {
            String string4 = LocalizedStringResolver.resolve(string, string2);
            String string5 = LocalizedStringResolver.resolve(string, string3, stringArray);
            if (this.isInSilentMode()) {
                System.err.println(string4);
                System.err.println(string5);
            } else {
                this.getWizard().getServices().displayUserMessage(string4, string5, 4);
            }
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void updateProductTree(String string) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty(this.productURL, null, "installLocation", "foo");
            productService.setProductBeanProperty(this.productURL, null, "installLocation", this.resolveString(string));
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            String string = this.getProductInstallLocation();
            this.fileService = (FileService)this.getService("fileService");
            String string2 = "";
            if (string != null) {
                string2 = this.resolveString(string);
            }
            this.setRelease(string2);
            if (!this.validateDestination(wizardBeanEvent)) {
                this.getWizard().exit(-1);
                return;
            }
            boolean bl = false;
            if (string2.trim().length() > 0 && !string2.equals("")) {
                String string3;
                boolean bl2 = bl = this.fileService.fileExists(string2);
                if (!bl && this.getWizard().getServices().getValue(CREATE_DIR) != null && (string3 = (String)this.getWizard().getServices().getValue(CREATE_DIR)).equalsIgnoreCase(YES_RESPONSE)) {
                    this.fileService.createDirectory(string2);
                }
            }
        }
        catch (ServiceException serviceException) {
            LOG.error(serviceException);
            this.getWizard().exit(-1);
            return;
        }
        if (!this.verifyVPD(wizardBeanEvent)) {
            this.getWizard().exit(-1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDirectoryWritable(String string) {
        try {
            if (this.fileService.fileExists(string) && !this.fileService.isDirectoryWritable(string)) {
                throw new IOException("Directory exists and its read-only");
            }
            Stack<String> stack = new Stack<String>();
            String string2 = string;
            while (string2 != null && !this.fileService.fileExists(string2)) {
                stack.push(string2);
                string2 = this.fileService.getParent(string2);
            }
            Vector<String> vector = new Vector<String>();
            while (!stack.isEmpty()) {
                String string3 = (String)stack.pop();
                this.fileService.createDirectory(string3);
                vector.addElement(string3);
            }
            boolean bl = true;
            if (OSUtil.isOperatingSystemOk(6)) {
                String string4 = "/bin/chmod 755 " + string;
                int n = this.execCommand(string4);
                if (n != 0) {
                    this.logEvent(this, "msg1", "'" + string4 + "' failed");
                    n = this.execCommand(string4);
                    if (n == 0) {
                        this.logEvent(this, "msg1", "'" + string4 + "' retry was successful");
                        return true;
                    }
                    String string5 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory");
                    String string6 = ASEResourceGetter.getAltFormatted("destination_chmod_fail", new String[]{string4});
                    this.showErrorMsg(string5, string6);
                    this.logEvent(this, "err", string6);
                    bl = false;
                } else {
                    this.logEvent(this, "msg1", "'" + string4 + "' was successful");
                }
            }
            int n = vector.size() - 1;
            while (true) {
                if (n < 0) {
                    return bl;
                }
                this.fileService.deleteDirectory((String)vector.elementAt(n));
                --n;
            }
        }
        catch (Exception exception) {
            LOG.error(exception);
            this.showLocalizedErrorMsg("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory", "notWritable", new String[]{this._release});
            return false;
        }
    }

    private int execCommand(String string) {
        Process process;
        int n = 1;
        int n2 = 0;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (Exception exception) {
            this.logEvent(this, "err", "Failed to execute command '" + string + "'. " + exception.getMessage());
            return 1;
        }
        for (n2 = 0; n2 < 10000; ++n2) {
            try {
                n = process.waitFor();
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (n2 >= 10000) {
            this.logEvent(this, "err", "Thread continually interrupted while executing command '" + string + "'.");
            return 1;
        }
        return n;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        String string = this.resolveString("$P(displayName)");
        String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.ote1Title", new String[]{string});
        String string3 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.ote1Doc");
        StringBuffer stringBuffer = new StringBuffer("-P installLocation=");
        if (n == 1) {
            stringBuffer.append(this.getOptionsFileTemplateValueStr());
        } else {
            stringBuffer.append("\"" + this.getProductInstallLocation() + "\"");
        }
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string2, string3, stringBuffer.toString())};
    }

    public boolean verifyVPD(WizardBeanEvent wizardBeanEvent) {
        Object object;
        String string = "";
        String string2 = "vpd.properties";
        String string3 = System.getProperty("file.separator");
        boolean bl = OSUtil.isOperatingSystemOk(0);
        String string4 = this.getRelease();
        if (!bl) {
            object = System.getProperty("user.home");
            string = (String)object + string3 + string2;
            System.setProperty("user.home", string4);
        } else {
            string = System.getProperty("windir") + string3 + string2;
        }
        try {
            Object object2;
            object = (RegistryService)this.getService("registryService");
            object.initializeRegistry();
            string = object.getVPDFileName();
            this.logEvent(this, "dbg", "Initialized Registry VPD file '" + string);
            if (!bl && !((File)(object2 = new File(string4))).exists()) {
                this.logEvent(this, "dbg", "VPD directory '" + string4 + "' does not yet exist");
                return true;
            }
            object.finalizeRegistry();
            object2 = new FileReader(string);
            ((InputStreamReader)object2).close();
            FileWriter fileWriter = new FileWriter(string, true);
            fileWriter.close();
            this.logEvent(this, "dbg", "VPD file '" + string + "' is writable");
            return true;
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception.toString());
            String string5 = ASEResourceGetter.getAltFormatted("vpd_not_writable", new String[]{string});
            this.logEvent(this, "err", string5);
            if (wizardBeanEvent.getUserInterface() != null) {
                String string6 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory");
                this.showErrorMsg(string6, string5);
            }
            return false;
        }
    }

    private boolean isInSilentMode() {
        return this.getWizard().getInterfaceName().equals("none");
    }

    public String getRelease() {
        return this._release;
    }

    public void setRelease(String string) {
        this._release = string.trim();
        if (this.hasEntered) {
            this.propertyChanged(ASEResourceGetter.getString("destination_dir"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

