/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductTree;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerJVMResolution;
import com.installshield.product.service.product.ProductService;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.ArrayList;

public class UninstallDeletePanel
extends WizardPanel {
    private static final String PRODUCT_URL = "/product.xml";
    private String uninstallerDir = null;
    private String uninstallerJVM = null;
    private String logFile = null;
    private String vpdFile = null;
    private FileService fileService = null;
    private SystemUtilService utilService = null;
    private RegistryService regService = null;
    private String[] files = null;
    private ArrayList array = null;
    private boolean delUserFiles = false;

    public UninstallDeletePanel() {
        this.setDescription("$L(com.sybase.ismp.ase.lang.ASEResourceBundle, uninstall_delete_description, $P(suite.displayName))");
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        String[] stringArray;
        boolean bl = true;
        bl = super.queryEnter(wizardBeanEvent);
        WizardUI wizardUI = wizardBeanEvent.getUserInterface();
        if (wizardUI != null) {
            wizardUI.setBusy();
        }
        if (bl) {
            try {
                stringArray = (String[])this.getServices().getService("productService");
                ProductTree productTree = stringArray.getSoftwareObjectTree(PRODUCT_URL);
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productTree.getRoot();
                int n = genericSoftwareObject.getInstallStatus();
                if (n != 4) {
                    this.logEvent(this, "dbg", "Uninstall not successful; skipping UninstallDeletePanel");
                    bl = false;
                }
            }
            catch (ServiceException serviceException) {
                bl = false;
                this.logEvent(this, "err", serviceException);
            }
        }
        if (bl) {
            bl = !this.hasProductInSybase();
        }
        if (bl) {
            stringArray = this.filesInSybase();
            bl = stringArray != null && stringArray.length > 0;
        }
        if (bl) {
            this.setNavigationOptions(6);
        }
        if (wizardUI != null) {
            wizardUI.clearBusy();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public boolean queryExit(WizardBeanEvent var1_1) {
        var2_2 = true;
        var3_3 = var1_1.getUserInterface();
        if (var3_3 != null) {
            var3_3.setBusy();
        }
        if (super.queryExit(var1_1)) {
            try {
                if (!this.getDeleteUserFiles()) ** GOTO lbl19
                var4_4 = (SystemUtilService)this.getService("systemUtilService");
                for (var5_6 = 0; var5_6 < this.files.length; ++var5_6) {
                    this.logEvent(this, "msg1", "Deleting " + this.files[var5_6] + "...");
                    var4_4.deleteFileOnExit(this.files[var5_6]);
                }
            }
            catch (ServiceException var4_5) {
                this.logEvent(this, "err", var4_5);
                var2_2 = false;
            }
        } else {
            var2_2 = false;
        }
lbl19:
        // 4 sources

        if (var3_3 != null) {
            var3_3.clearBusy();
        }
        return var2_2;
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean");
            wizardBuilderSupport.putRequiredService("fileService");
            wizardBuilderSupport.putRequiredService("systemUtilService");
            wizardBuilderSupport.putRequiredService("registryService");
            wizardBuilderSupport.putRequiredService("productService");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    public void setDeleteUserFiles(boolean bl) {
        this.delUserFiles = bl;
    }

    public boolean getDeleteUserFiles() {
        return this.delUserFiles;
    }

    public String[] filesInSybase() {
        if (this.files == null) {
            String string = this.resolveString("$P(installLocation)");
            this.array = new ArrayList();
            this.uninstallerDir = this.uninstallDirectory();
            this.uninstallerJVM = this.uninstallJVMDirectory();
            this.logFile = this.uninstallLogFile();
            this.vpdFile = this.vpdPropertiesFile();
            this.findFiles(string);
            int n = this.array.size();
            if (n > 0) {
                this.files = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.files[i] = (String)this.array.get(i);
                }
            } else {
                this.logEvent(this, "dbg", "No user files in $SYBASE; skipping UninstallDeletePanel");
            }
        }
        return this.files;
    }

    private void findFiles(String string) {
        try {
            String string2;
            int n;
            String[] stringArray;
            if (this.fileService == null) {
                this.fileService = (FileService)this.getService("fileService");
            }
            if ((stringArray = this.fileService.getDirectoryList(string, 0)) != null && stringArray.length > 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    string2 = string + this.fileService.getSeparator() + stringArray[n];
                    if (string2.equals(this.logFile) || string2.equals(this.vpdFile)) continue;
                    this.array.add(string2);
                }
            }
            if ((stringArray = this.fileService.getDirectoryList(string, 1)) != null && stringArray.length > 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    string2 = string + this.fileService.getSeparator() + stringArray[n];
                    if (string2.equals(this.uninstallerDir) || string2.equals(this.uninstallerJVM)) continue;
                    this.findFiles(string2);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private boolean hasProductInSybase() {
        try {
            if (this.regService == null) {
                this.regService = (RegistryService)this.getService("registryService");
            }
            String[] stringArray = this.regService.getAllSoftwareObjectUIDs();
            String string = this.resolveString("$P(installLocation)");
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.regService.getSoftwareObject(stringArray[i], string) == null) continue;
                this.logEvent(this, "dbg", "$SYBASE still has products.");
                return true;
            }
            this.logEvent(this, "dbg", "$SYBASE has no more product.");
            return false;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return true;
        }
    }

    private String uninstallJVMDirectory() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            UninstallerJVMResolution uninstallerJVMResolution = (UninstallerJVMResolution)productService.getProductTreeProperty(PRODUCT_URL, "uninstallerJVMResolution");
            if (this.fileService == null) {
                this.fileService = (FileService)this.getService("fileService");
            }
            String string = uninstallerJVMResolution.getInstallLocation();
            String string2 = this.resolveString("$P(absoluteInstallLocation)");
            return this.fileService.normalizeFileName(string2 + System.getProperty("file.separator") + string);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return "";
        }
    }

    private String uninstallDirectory() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            UninstallerArchive uninstallerArchive = (UninstallerArchive)productService.getProductTreeProperty(PRODUCT_URL, "uninstallerArchive");
            if (this.fileService == null) {
                this.fileService = (FileService)this.getService("fileService");
            }
            String string = uninstallerArchive.getInstallLocation();
            String string2 = this.resolveString("$P(absoluteInstallLocation)");
            return this.fileService.normalizeFileName(string2 + System.getProperty("file.separator") + string);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return "";
        }
    }

    private String uninstallLogFile() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            String string = productService.getSoftwareObjectTree(PRODUCT_URL).getLogFile();
            String string2 = this.resolveString("$P(absoluteInstallLocation)");
            return string2 + System.getProperty("file.separator") + string;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return "";
        }
    }

    private String vpdPropertiesFile() {
        String string = this.resolveString("$P(absoluteInstallLocation)");
        return string + System.getProperty("file.separator") + "vpd.properties";
    }
}

