/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.util.FileAttributes;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ConfigASEPanel;
import com.sybase.ismp.ase.wizardbean.ConfigBackupPanel;
import com.sybase.ismp.ase.wizardbean.ConfigEJBPanel;
import com.sybase.ismp.ase.wizardbean.ConfigMonitorPanel;
import com.sybase.ismp.ase.wizardbean.ConfigTextPanel;
import com.sybase.ismp.ase.wizardbean.ConfigWSPanel;
import com.sybase.ismp.ase.wizardbean.ConfigXPPanel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;

public class WriteResourceFileASE
extends WizardAction {
    private static ConfigASEPanel _asePanel = null;
    private static ConfigBackupPanel _bsPanel = null;
    private static ConfigMonitorPanel _msPanel = null;
    private static ConfigXPPanel _xpPanel = null;
    private static ConfigTextPanel _eftsPanel = null;
    private static ConfigEJBPanel _ejbPanel = null;
    private static ConfigWSPanel _wsPanel = null;
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private String serverType = SERVER_TYPES[0];
    private String resourceFile = "$P(installLocation)/" + this.serverType + ".rs";
    private String Sybase = "";
    FileService fs = null;
    boolean isWSConfig = false;
    public static final String[] SERVER_TYPES = new String[]{"ase", "bsrv", "msrv", "xp", "txtsvr", "ejb", "ws", "uaf_ase_plugin"};

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            this.fs = (FileService)this.getService("fileService");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return;
        }
        this.isWSConfig = this.getServerType().equals(SERVER_TYPES[6]);
        this.Sybase = this.resolveString("$P(installLocation)");
        this.findWizardBeans(this.getWizardTree().getRoot());
        String string = null;
        Object var3_4 = null;
        Object[] objectArray = this.getFormatedObjects();
        if (this.getServerType().equals(SERVER_TYPES[0])) {
            string = !this._isWindows ? ASEResourceGetter.getAltFormatted("sqlsrv_unix", objectArray) : ASEResourceGetter.getAltFormatted("sqlsrv_win", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[1])) {
            string = !this._isWindows ? ASEResourceGetter.getAltFormatted("bsrv_unix", objectArray) : ASEResourceGetter.getAltFormatted("bsrv_win", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[2])) {
            string = !this._isWindows ? ASEResourceGetter.getAltFormatted("msrv_unix", objectArray) : ASEResourceGetter.getAltFormatted("msrv_win", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[3])) {
            if (this._isWindows) return;
            string = ASEResourceGetter.getAltFormatted("xp_unix", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[4])) {
            if (this._isWindows) return;
            string = ASEResourceGetter.getAltFormatted("text_unix", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[5])) {
            string = ASEResourceGetter.getAltFormatted("ejb_generic", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[6])) {
            string = ASEResourceGetter.getAltFormatted("ws_generic", objectArray);
        } else if (this.getServerType().equals(SERVER_TYPES[7])) {
            string = !this._isWindows ? ASEResourceGetter.getAltFormatted("uaf_ase_plugin_unix", objectArray) : ASEResourceGetter.getAltFormatted("uaf_ase_plugin_win", objectArray);
        }
        this.writeFile(string, this.resolveString(this.getResourceFile()));
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.lang");
            wizardBuilderSupport.putPackage("com.sybase.ismp.ase.wizardbean");
            wizardBuilderSupport.putPackage("com.installshield.beans.editors");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent(this, "err", exception.getMessage());
        }
    }

    private void findWizardBeans(WizardBean wizardBean) {
        WizardTree wizardTree = this.getWizardTree();
        Enumeration enumeration = wizardTree.children(wizardBean);
        while (enumeration.hasMoreElements()) {
            wizardBean = (WizardBean)enumeration.nextElement();
            if (wizardTree.getChildCount(wizardBean) > 0) {
                this.findWizardBeans(wizardBean);
            }
            if (wizardBean instanceof ConfigASEPanel) {
                _asePanel = (ConfigASEPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigBackupPanel) {
                _bsPanel = (ConfigBackupPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigMonitorPanel) {
                _msPanel = (ConfigMonitorPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigXPPanel) {
                _xpPanel = (ConfigXPPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigTextPanel) {
                _eftsPanel = (ConfigTextPanel)wizardBean;
                continue;
            }
            if (wizardBean instanceof ConfigEJBPanel) {
                _ejbPanel = (ConfigEJBPanel)wizardBean;
                continue;
            }
            if (!(wizardBean instanceof ConfigWSPanel)) continue;
            _wsPanel = (ConfigWSPanel)wizardBean;
        }
    }

    private Object[] getFormatedObjects() {
        return new Object[]{this.getSYBASE(), this.getASEName(), this.getASEPort(), this.getASEHost(), this.getASEPageSize(), this.getASEUser(), this.getASEPassword(), this.getASEErrorLog(), this.getASEMasterDev(), this.getASEMasterDevSize(), this.getASEMasterDbSize(), this.getASESysProcDev(), this.getASESysProcDevSize(), this.getASESysProcDbSize(), this.getBackupName(), this.getBackupPort(), this.getBackupHost(), this.getBackupErrorLog(), this.getMonitorName(), this.getMonitorPort(), this.getMonitorHost(), this.getMonitorErrorLog(), this.getXPName(), this.getXPPort(), this.getXPHost(), this.getXPErrorLog(), this.getTextName(), this.getTextPort(), this.getTextHost(), this.getTextErrorLog(), this.getTextCollectionDir(), this.getTextDefaultDb(), this.getTextMinSession(), this.getTextMaxSession(), this.getEjbHost(), this.getEjbPort(), this.getSybaseWs(), this.getWsProducerHTTPPort(), this.getWsProducerHTTPSPort(), this.getWsProducerHostName(), this.getWsCertificatePassword(), this.getWsKeystorePassword(), this.getWsProducerLogFile(), this.getWsConsumerPort(), this.getWsConsumerLogFile(), this.getASESystemDev(), this.getASESystemDevSize(), this.getASESystemDbSize()};
    }

    private void writeFile(String string, String string2) {
        try {
            this.logEvent(this, "dbg", "Write file:" + string2 + ":message:" + string);
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setAttributes(3);
            this.fs.setFileAttributes(string2, fileAttributes);
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", "Problem writing resource file " + string2);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", "Problem changing resource file '" + string2 + "' permission.");
        }
    }

    private String getSYBASE() {
        try {
            if (this.isWSConfig) {
                this.Sybase = this.fs.normalizeFileName(this.Sybase, '/');
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return this.Sybase;
    }

    private String getASEName() {
        if (_asePanel != null) {
            return _asePanel.getServerName();
        }
        return "";
    }

    private String getASEPort() {
        if (_asePanel != null) {
            return _asePanel.getPortNumber();
        }
        return "";
    }

    private String getASEHost() {
        if (_asePanel != null) {
            return _asePanel.getHostName();
        }
        return "";
    }

    private String getASEPageSize() {
        if (_asePanel != null) {
            return _asePanel.getPageSize();
        }
        return "";
    }

    private String getASEUser() {
        if (_asePanel != null) {
            return _asePanel.getUser();
        }
        return "";
    }

    private String getASEPassword() {
        if (_asePanel != null) {
            return _asePanel.getPassword();
        }
        return "";
    }

    private String getASEErrorLog() {
        if (_asePanel != null) {
            return _asePanel.getErrorLog();
        }
        return "";
    }

    private String getASEMasterDev() {
        if (_asePanel != null) {
            return _asePanel.getMasterDevice();
        }
        return "";
    }

    private String getASEMasterDevSize() {
        if (_asePanel != null) {
            return _asePanel.getMasterDeviceSize();
        }
        return "";
    }

    private String getASEMasterDbSize() {
        if (_asePanel != null) {
            return _asePanel.getMasterDatabaseSize();
        }
        return "";
    }

    private String getASESysProcDev() {
        if (_asePanel != null) {
            return _asePanel.getSystemProcedureDevice();
        }
        return "";
    }

    private String getASESysProcDevSize() {
        if (_asePanel != null) {
            return _asePanel.getSystemProcedureDeviceSize();
        }
        return "";
    }

    private String getASESysProcDbSize() {
        if (_asePanel != null) {
            return _asePanel.getSystemProcedureDatabaseSize();
        }
        return "";
    }

    private String getASESystemDev() {
        if (_asePanel != null) {
            return _asePanel.getSystemDevice();
        }
        return "";
    }

    private String getASESystemDevSize() {
        if (_asePanel != null) {
            return _asePanel.getSystemDeviceSize();
        }
        return "";
    }

    private String getASESystemDbSize() {
        if (_asePanel != null) {
            return _asePanel.getSystemDatabaseSize();
        }
        return "";
    }

    private String getBackupName() {
        if (_bsPanel != null) {
            return _bsPanel.getServerName();
        }
        return "";
    }

    private String getBackupPort() {
        if (_bsPanel != null) {
            return _bsPanel.getPortNumber();
        }
        return "";
    }

    private String getBackupHost() {
        if (_bsPanel != null) {
            return _bsPanel.getHostName();
        }
        return "";
    }

    private String getBackupErrorLog() {
        if (_bsPanel != null) {
            return _bsPanel.getErrorLog();
        }
        return "";
    }

    private String getMonitorName() {
        if (_msPanel != null) {
            return _msPanel.getServerName();
        }
        return "";
    }

    private String getMonitorPort() {
        if (_msPanel != null) {
            return _msPanel.getPortNumber();
        }
        return "";
    }

    private String getMonitorHost() {
        if (_msPanel != null) {
            return _msPanel.getHostName();
        }
        return "";
    }

    private String getMonitorErrorLog() {
        if (_msPanel != null) {
            return _msPanel.getErrorLog();
        }
        return "";
    }

    private String getXPName() {
        if (_xpPanel != null) {
            return _xpPanel.getServerName();
        }
        return "";
    }

    private String getXPPort() {
        if (_xpPanel != null) {
            return _xpPanel.getPortNumber();
        }
        return "";
    }

    private String getXPHost() {
        if (_xpPanel != null) {
            return _xpPanel.getHostName();
        }
        return "";
    }

    private String getXPErrorLog() {
        if (_xpPanel != null) {
            return _xpPanel.getErrorLog();
        }
        return "";
    }

    private String getTextName() {
        if (_eftsPanel != null) {
            return _eftsPanel.getServerName();
        }
        return "";
    }

    private String getTextPort() {
        if (_eftsPanel != null) {
            return _eftsPanel.getPortNumber();
        }
        return "";
    }

    private String getTextHost() {
        if (_eftsPanel != null) {
            return _eftsPanel.getHostName();
        }
        return "";
    }

    private String getTextErrorLog() {
        if (_eftsPanel != null) {
            return _eftsPanel.getErrorLog();
        }
        return "";
    }

    private String getTextCollectionDir() {
        if (_eftsPanel != null) {
            return _eftsPanel.getTextCollectionDirectory();
        }
        return "";
    }

    private String getTextDefaultDb() {
        if (_eftsPanel != null) {
            return _eftsPanel.getTextDefaultDatabase();
        }
        return "";
    }

    private String getTextMinSession() {
        if (_eftsPanel != null) {
            return _eftsPanel.getTextMinimumSession();
        }
        return "";
    }

    private String getTextMaxSession() {
        if (_eftsPanel != null) {
            return _eftsPanel.getTextMaximumSession();
        }
        return "";
    }

    private String getEjbHost() {
        if (_ejbPanel != null) {
            return _ejbPanel.getHostName();
        }
        return "";
    }

    private String getEjbPort() {
        if (_ejbPanel != null) {
            return _ejbPanel.getPortNumber();
        }
        return "";
    }

    private String getSybaseWs() {
        if (_wsPanel != null) {
            return _wsPanel.getSybaseWs();
        }
        return "";
    }

    private String getWsProducerHTTPPort() {
        if (_wsPanel != null) {
            return _wsPanel.getProducerHttpPortNumber();
        }
        return "";
    }

    private String getWsProducerHTTPSPort() {
        if (_wsPanel != null) {
            return _wsPanel.getProducerHttpsPortNumber();
        }
        return "";
    }

    private String getWsProducerHostName() {
        if (_wsPanel != null) {
            return _wsPanel.getProducerHostName();
        }
        return "";
    }

    private String getWsCertificatePassword() {
        if (_wsPanel != null) {
            return _wsPanel.getCertificatePassword();
        }
        return "";
    }

    private String getWsKeystorePassword() {
        if (_wsPanel != null) {
            return _wsPanel.getKeystorePassword();
        }
        return "";
    }

    private String getWsProducerLogFile() {
        try {
            if (_wsPanel != null) {
                return this.fs.normalizeFileName(_wsPanel.getProducerLogFile(), '/');
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return "";
    }

    private String getWsConsumerPort() {
        if (_wsPanel != null) {
            return _wsPanel.getConsumerPortNumber();
        }
        return "";
    }

    private String getWsConsumerLogFile() {
        try {
            if (_wsPanel != null) {
                return this.fs.normalizeFileName(_wsPanel.getConsumerLogFile(), '/');
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return "";
    }

    public void setResourceFile(String string) {
        this.resourceFile = string;
    }

    public String getResourceFile() {
        return this.resourceFile;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public String getServerType() {
        return this.serverType;
    }
}

