/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import com.installshield.wizard.awt.AWTWizardPanelImpl;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.installshield.wizardx.ui.DirectoryInputComponent;
import com.installshield.wizardx.ui.TextInputComponent;
import com.sybase.ismp.ase.AWTMnemonicLibrary;
import com.sybase.ismp.ase.TypedKeyInfo;
import com.sybase.ismp.ase.lang.SISResourceGetter;
import com.sybase.ismp.ase.wizardbean.ui.ComboBoxComponent;
import com.sybase.ismp.ase.wizardbean.ui.LabelComponent;
import com.sybase.ismp.ase.wizardbean.ui.TextBrowseButtonComponent;
import com.sybase.ismp.ase.wizardbean.ui.UIConstants;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Category;

public class GenericInputLine
extends AbstractUIComponent
implements ConsoleUIComponent {
    private static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$wizardbean$ui$GenericInputLine == null ? (class$com$sybase$ismp$ase$wizardbean$ui$GenericInputLine = GenericInputLine.class$("com.sybase.ismp.ase.wizardbean.ui.GenericInputLine")) : class$com$sybase$ismp$ase$wizardbean$ui$GenericInputLine).getName());
    protected Component _inputComponent = null;
    protected Component _browseButtonComponent = null;
    protected LabelComponent _displayComponent = null;
    public static int FIELD_SIZE_SMALL = 5;
    public static int FIELD_SIZE_MEDIUM = 15;
    public static int FIELD_SIZE_LARGE = 25;
    public static int FIELD_SIZE_FIT_TO_DEFAULT = -1;
    protected char _mnemonic = '\u0000';
    protected int _inputWidth = FIELD_SIZE_FIT_TO_DEFAULT;
    protected String _defaultValue = "";
    protected String _labelText = "";
    public static final char PASSWORD_FIELD_ECHO_CHARACTER = '*';
    char _echoChar = '\u0000';
    AWTWizardPanelImpl _containerPanel = null;
    boolean _uiCreated = false;
    boolean _inputLocked = false;
    boolean _inputBorderHidden = false;
    protected boolean _isFile = false;
    protected boolean _isDirectory = false;
    protected boolean _isInteger = false;
    protected boolean _checkForWritePermission = false;
    protected boolean _isConsole = false;
    protected boolean _isCombo = false;
    protected int _minValue = -999;
    protected int _maxValue = -999;
    protected String[] _comboValues = null;
    static /* synthetic */ Class class$com$sybase$ismp$ase$wizardbean$ui$GenericInputLine;

    public GenericInputLine(String string, String string2, int n) {
        this._inputWidth = n;
        this._defaultValue = string2;
        this._labelText = string;
    }

    public GenericInputLine(String string, String[] stringArray, int n) {
        this._inputWidth = n;
        this._comboValues = stringArray;
        this._labelText = string;
    }

    public GenericInputLine(String string, String string2, int n, char c, AWTWizardPanelImpl aWTWizardPanelImpl) {
        this(string, string2, n);
        this._mnemonic = c;
        this._containerPanel = aWTWizardPanelImpl;
        this.createComponentUI();
    }

    public GenericInputLine(String string, String string2, int n, char c, char c2, AWTWizardPanelImpl aWTWizardPanelImpl) {
        this(string, string2, n, c2, aWTWizardPanelImpl);
        this._echoChar = c;
    }

    public GenericInputLine(String string, String string2, int n, char c) {
        this(string, string2, n);
        this._echoChar = c;
        this.createComponentUI();
    }

    public void createComponentUI() {
        if (this._isFile) {
            this._inputComponent = new TextBrowseButtonComponent(this._labelText, this._defaultValue, this._inputWidth, this._checkForWritePermission);
            ((TextBrowseButtonComponent)this._inputComponent).createComponentUI();
        } else if (this._isDirectory) {
            this._inputComponent = new TextBrowseButtonComponent(this._labelText, this._defaultValue, this._inputWidth, this._checkForWritePermission, true);
            ((TextBrowseButtonComponent)this._inputComponent).createComponentUI();
        } else if (this._isCombo) {
            LOG.debug("Combo:" + this._comboValues);
            this._inputComponent = new ComboBoxComponent(this._comboValues, this._inputWidth);
            ((ComboBoxComponent)this._inputComponent).createComponentUI();
        } else if (this._inputWidth == FIELD_SIZE_FIT_TO_DEFAULT && this._defaultValue != null) {
            if (this._echoChar != '\u0000') {
                this._inputComponent = new JPasswordField(this._defaultValue);
                ((JPasswordField)this._inputComponent).setEchoChar(this._echoChar);
            } else {
                this._inputComponent = new JTextField(this._defaultValue);
            }
        } else if (this._inputWidth == FIELD_SIZE_FIT_TO_DEFAULT && this._defaultValue == null) {
            if (this._echoChar != '\u0000') {
                this._inputComponent = new JPasswordField(this._defaultValue, FIELD_SIZE_MEDIUM);
                ((JPasswordField)this._inputComponent).setEchoChar(this._echoChar);
            } else {
                this._inputComponent = new JTextField(this._defaultValue, FIELD_SIZE_MEDIUM);
            }
        } else if (this._echoChar != '\u0000') {
            this._inputComponent = new JPasswordField(this._defaultValue, this._inputWidth);
            ((JPasswordField)this._inputComponent).setEchoChar(this._echoChar);
        } else {
            this._inputComponent = new JTextField(this._defaultValue, this._inputWidth);
            if (this._isInteger) {
                this._inputComponent.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent focusEvent) {
                        JTextField jTextField = (JTextField)focusEvent.getSource();
                        String string = jTextField.getText();
                        int n = 0;
                        if (string.length() != 0) {
                            try {
                                n = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, SISResourceGetter.getString("integer_error"), SISResourceGetter.getString("integer_error_title"), 0);
                                jTextField.requestFocus();
                            }
                        }
                        if (GenericInputLine.this._minValue != -999 && GenericInputLine.this._maxValue != -999 && (GenericInputLine.this._minValue > n || n > GenericInputLine.this._maxValue)) {
                            JOptionPane.showMessageDialog(null, SISResourceGetter.getFormatted("integer_range_error", new Object[]{GenericInputLine.this._labelText, new Integer(GenericInputLine.this._minValue), new Integer(GenericInputLine.this._maxValue)}), SISResourceGetter.getString("integer_range_error_title"), 0);
                            jTextField.requestFocus();
                        }
                    }
                });
            }
        }
        this._displayComponent = new LabelComponent(this._labelText, LabelComponent.ALIGNMENT_RIGHT);
        this._displayComponent.createComponentUI();
        super.setLayout(new BoxLayout(this, 0));
        super.add(this._displayComponent);
        super.add(this._inputComponent);
        if (this._mnemonic != '\u0000') {
            this._displayComponent.getSwingLabelComponent().setDisplayedMnemonic(this._mnemonic);
            this._displayComponent.getSwingLabelComponent().setLabelFor(this._inputComponent);
            if (this._containerPanel != null) {
                AWTMnemonicLibrary.addMnemonic((Component)this._displayComponent.getSwingLabelComponent(), new TypedKeyInfo(8L, this._mnemonic), this._inputComponent);
            }
        }
        this._uiCreated = true;
        if (!(this._isCombo || this._isFile || this._isDirectory)) {
            this.hideBorder(this._inputBorderHidden);
            this.lockInput(this._inputLocked);
        }
    }

    public void consoleInteraction() {
        this._isConsole = true;
        this._displayComponent = new LabelComponent(this._labelText);
        this._displayComponent.consoleInteraction();
        if (this._isFile) {
            this._inputComponent = new TextBrowseButtonComponent(this._labelText, this._defaultValue, this._inputWidth, this._checkForWritePermission);
            ((TextBrowseButtonComponent)this._inputComponent).consoleInteraction();
        }
        if (this._isDirectory) {
            this._inputComponent = new TextBrowseButtonComponent(this._labelText, this._defaultValue, this._inputWidth, this._checkForWritePermission, true);
            ((TextBrowseButtonComponent)this._inputComponent).consoleInteraction();
        }
        if (this._isCombo) {
            this._inputComponent = new ComboBoxComponent(this._comboValues, this._inputWidth);
            ((ComboBoxComponent)this._inputComponent).consoleInteraction();
        } else if (this._isInteger) {
            boolean bl = true;
            String string = null;
            while (bl) {
                this.getTTYDisplay().printLine();
                string = this.getTTYDisplay().prompt("", this._defaultValue);
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                    if (this._minValue != -999 && this._maxValue != -999 && (this._minValue > n || n > this._maxValue)) {
                        this.getTTYDisplay().printLine(SISResourceGetter.getFormatted("integer_range_error", new Object[]{this._labelText, new Integer(this._minValue), new Integer(this._maxValue)}));
                        this.getTTYDisplay().printLine();
                        continue;
                    }
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {
                    this.getTTYDisplay().printLine(SISResourceGetter.getString("integer_error"));
                    this.getTTYDisplay().printLine();
                }
            }
            this.setInputText(string);
        } else {
            this._inputComponent = new TextInputComponent(this._defaultValue, true);
            ((TextInputComponent)this._inputComponent).consoleInteraction();
        }
    }

    public void setMnemonic(char c) {
        this._mnemonic = c;
    }

    public char getMnemonic() {
        return this._mnemonic;
    }

    public void setMnemonic(String string) {
        this._mnemonic = string.toCharArray()[0];
    }

    public LabelComponent getLabel() {
        return this._displayComponent;
    }

    public Component getField() {
        return this._inputComponent;
    }

    public String getInputText() {
        if (this._inputComponent instanceof TextInputComponent) {
            return ((TextInputComponent)this._inputComponent).getText();
        }
        if (this._inputComponent instanceof JTextField) {
            return ((JTextField)this._inputComponent).getText();
        }
        if (this._inputComponent instanceof TextBrowseButtonComponent) {
            return ((TextBrowseButtonComponent)this._inputComponent).getText();
        }
        if (this._inputComponent instanceof ComboBoxComponent) {
            return ((ComboBoxComponent)this._inputComponent).getText();
        }
        if (this._inputComponent instanceof JPasswordField) {
            return new String(((JPasswordField)this._inputComponent).getPassword());
        }
        return null;
    }

    public String getLabelText() {
        return this._displayComponent.getText();
    }

    public void setInputText(String string) {
        if (this._inputComponent instanceof TextInputComponent) {
            ((TextInputComponent)this._inputComponent).setText(string);
        } else if (this._inputComponent instanceof JTextField) {
            ((JTextField)this._inputComponent).setText(string);
        } else if (this._inputComponent instanceof TextBrowseButtonComponent) {
            ((TextBrowseButtonComponent)this._inputComponent).setText(string);
        } else if (this._inputComponent instanceof ComboBoxComponent) {
            ((ComboBoxComponent)this._inputComponent).setText(string);
        } else if (this._inputComponent instanceof DirectoryInputComponent) {
            ((DirectoryInputComponent)this._inputComponent).getInputComponent().setText(string);
        }
    }

    public void clearLine() {
        this.setInputText("");
    }

    public void hideBorder(boolean bl) {
        this._inputBorderHidden = bl;
        if (this._uiCreated) {
            if (bl) {
                ((JTextField)this._inputComponent).setBorder(BorderFactory.createEmptyBorder());
            } else {
                JTextField jTextField = new JTextField();
                ((JTextField)this._inputComponent).setBorder(jTextField.getBorder());
            }
        }
    }

    public void lockInput(boolean bl) {
        this._inputLocked = bl;
        if (this._uiCreated) {
            ((JTextField)this._inputComponent).setEditable(!bl);
            ((JTextField)this._inputComponent).setBackground(UIConstants.SYB_BACKGROUND_COLOR);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

