/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import com.sybase.ismp.ase.wizardbean.ui.SwingGenericInputLine;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SwingFileInputLine
extends SwingGenericInputLine
implements ActionListener {
    boolean isDirectory = false;
    JButton browseButton = null;

    public SwingFileInputLine(String string, String string2) {
        this.type = 3;
        this.labelText = string;
        this.initValue = string2;
        this.initComponent();
    }

    public SwingFileInputLine(String string, String string2, char c) {
        this.type = 3;
        this.labelText = string;
        this.initValue = string2;
        this.mnemonic = c;
        this.initComponent();
    }

    public SwingFileInputLine(String string, String string2, char c, String string3, int n, boolean bl) {
        this.type = 3;
        this.labelText = string;
        this.initValue = string2;
        this.mnemonic = c;
        this.tooltip = string3;
        this.inputWidth = n;
        this.isDirectory = bl;
        this.initComponent();
    }

    private void initComponent() {
        this.textFieldComponent = new JTextField(this.initValue, this.inputWidth);
        this.textFieldComponent.setBackground(SystemColor.text);
        this.textFieldComponent.setForeground(SystemColor.textText);
        if (this.tooltip != null) {
            this.textFieldComponent.setToolTipText(this.tooltip);
        }
        if (!this.labelHasMnenomics(this.labelText, this.mnemonic)) {
            this.labelText = this.appendMnenomicsToLabel(this.labelText, this.mnemonic);
        }
        this.labelComponent = new JLabel(this.labelText);
        if (this.mnemonic != '\u0000') {
            this.labelComponent.setLabelFor(this.textFieldComponent);
            this.labelComponent.setDisplayedMnemonic(this.mnemonic);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/installshield/wizard/i18n/WizardResources");
        String string = "Browse";
        try {
            string = resourceBundle.getString("browse");
        }
        catch (Exception exception) {
            string = "Browse";
        }
        this.browseButton = new JButton(string);
        this.browseButton.addActionListener(this);
        this.setLayout(new FlowLayout(0));
        this.add(this.labelComponent);
        this.add(this.textFieldComponent);
        this.add(this.browseButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseButton) {
            String string = this.textFieldComponent.getText();
            if (string == null || string.length() == 0) {
                string = this.initValue;
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            if (this.isDirectory) {
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.changeToParentDirectory();
            }
            jFileChooser.setDialogTitle(this.stripMnenomicsFromLabel(this.labelText));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0 && this.textFieldComponent != null) {
                this.textFieldComponent.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

