/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SwingGenericInputLine
extends JPanel {
    public static final int TEXT_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int PASSWORD_TYPE = 2;
    public static final int FILE_TYPE = 3;
    public static final int DIR_TYPE = 4;
    public static final int COMBO_TYPE = 5;
    public static final int FIELD_SIZE_SMALL = 5;
    public static final int FIELD_SIZE_MEDIUM = 15;
    public static final int FIELD_SIZE_LARGE = 25;
    protected JLabel labelComponent = null;
    protected JButton browseButtonComponent = null;
    protected JTextField textFieldComponent = null;
    protected JPasswordField passwordFieldComponent = null;
    protected JComboBox comboBoxComponent = null;
    protected String initValue = null;
    protected String labelText = "";
    protected char mnemonic = '\u0000';
    protected String tooltip = null;
    protected int type = 0;
    protected int inputWidth = 15;

    SwingGenericInputLine() {
    }

    protected boolean labelHasMnenomics(String string, char c) {
        if (c == '\u0000') {
            return false;
        }
        return string.indexOf(c) >= 0;
    }

    protected String appendMnenomicsToLabel(String string, char c) {
        if (c != '\u0000') {
            string = string + " (" + c + ")";
        }
        return string;
    }

    protected String stripMnenomicsFromLabel(String string) {
        int n = string.length();
        if (n < 4) {
            return string;
        }
        if (string.charAt(n - 3) == '(' && string.charAt(n - 1) == ')') {
            return string.substring(0, n - 4);
        }
        return string;
    }

    public void setLabelText(String string) {
        this.labelText = string;
        if (string != null && this.labelComponent != null) {
            this.labelComponent.setText(string);
        }
    }

    public String getLabelText() {
        return this.stripMnenomicsFromLabel(this.labelText);
    }

    public void setMnenomics(char c) {
        this.mnemonic = c;
        if (this.mnemonic != '\u0000' && this.labelComponent != null) {
            switch (this.type) {
                case 2: {
                    if (this.passwordFieldComponent == null) break;
                    this.labelComponent.setLabelFor(this.passwordFieldComponent);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    if (this.textFieldComponent == null) break;
                    this.labelComponent.setLabelFor(this.textFieldComponent);
                    break;
                }
                case 5: {
                    if (this.comboBoxComponent == null) break;
                    this.labelComponent.setLabelFor(this.comboBoxComponent);
                }
            }
            this.labelComponent.setDisplayedMnemonic(this.mnemonic);
        }
    }

    public char getMnenomics() {
        if (this.labelComponent != null) {
            return (char)this.labelComponent.getDisplayedMnemonic();
        }
        return this.mnemonic;
    }

    public void setToolTip(String string) {
        this.tooltip = string;
        if (this.tooltip == null) {
            return;
        }
        switch (this.type) {
            case 2: {
                if (this.passwordFieldComponent == null) break;
                this.passwordFieldComponent.setText(this.tooltip);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (this.textFieldComponent == null) break;
                this.textFieldComponent.setText(this.tooltip);
                break;
            }
            case 5: {
                if (this.comboBoxComponent == null) break;
                this.comboBoxComponent.setSelectedItem(this.tooltip);
            }
        }
    }

    public String getToolTip() {
        String string = this.tooltip;
        switch (this.type) {
            case 2: {
                if (this.passwordFieldComponent == null) break;
                string = this.passwordFieldComponent.getToolTipText();
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (this.textFieldComponent == null) break;
                string = this.textFieldComponent.getToolTipText();
                break;
            }
            case 5: {
                if (this.comboBoxComponent == null) break;
                string = this.comboBoxComponent.getToolTipText();
            }
        }
        return string;
    }

    public void setValue(String string) {
        this.initValue = string;
        if (string == null) {
            return;
        }
        switch (this.type) {
            case 2: {
                if (this.passwordFieldComponent == null) break;
                this.passwordFieldComponent.setText(string);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (this.textFieldComponent == null) break;
                this.textFieldComponent.setText(string);
                break;
            }
            case 5: {
                if (this.comboBoxComponent == null) break;
                this.comboBoxComponent.setSelectedItem(string);
            }
        }
    }

    public String getValue() {
        String string = this.initValue;
        switch (this.type) {
            case 2: {
                if (this.passwordFieldComponent == null) break;
                string = new String(this.passwordFieldComponent.getPassword());
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (this.textFieldComponent == null) break;
                string = this.textFieldComponent.getText();
                break;
            }
            case 5: {
                if (this.comboBoxComponent == null) break;
                string = (String)this.comboBoxComponent.getSelectedItem();
            }
        }
        return string;
    }

    public void setInputWidth(int n) {
        this.inputWidth = n;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public JLabel getLabelComponent() {
        return this.labelComponent;
    }

    public JComponent getInputComponent() {
        if (this.type == 0 || this.type == 1 || this.type == 3 || this.type == 4) {
            return this.textFieldComponent;
        }
        if (this.type == 2) {
            return this.passwordFieldComponent;
        }
        if (this.type == 5) {
            return this.comboBoxComponent;
        }
        return null;
    }
}

