/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import com.sybase.ismp.ase.lang.SISResourceGetter;
import com.sybase.ismp.ase.wizardbean.ui.SwingGenericInputLine;
import com.sybase.ismp.ase.wizardbean.ui.WholeNumberField;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class SwingIntegerInputLine
extends SwingGenericInputLine
implements FocusListener {
    int minValue = Integer.MIN_VALUE;
    int maxValue = Integer.MAX_VALUE;

    public SwingIntegerInputLine(String string, String string2) {
        this.type = 1;
        this.labelText = string;
        this.initValue = string2;
        this.initComponent();
    }

    public SwingIntegerInputLine(String string, String string2, char c) {
        this.type = 1;
        this.labelText = string;
        this.initValue = string2;
        this.mnemonic = c;
        this.initComponent();
    }

    public SwingIntegerInputLine(String string, String string2, char c, String string3) {
        this.type = 1;
        this.labelText = string;
        this.initValue = string2;
        this.mnemonic = c;
        this.tooltip = string3;
        this.initComponent();
    }

    public SwingIntegerInputLine(String string, String string2, char c, String string3, int n, int n2, int n3) {
        this.type = 1;
        this.labelText = string;
        this.initValue = string2;
        this.mnemonic = c;
        this.tooltip = string3;
        this.inputWidth = n;
        this.minValue = n2;
        this.maxValue = n3;
        this.initComponent();
    }

    private void initComponent() {
        this.textFieldComponent = new WholeNumberField(this.initValue, this.inputWidth);
        this.textFieldComponent.addFocusListener(this);
        this.textFieldComponent.setBackground(SystemColor.text);
        this.textFieldComponent.setForeground(SystemColor.textText);
        if (this.tooltip != null) {
            this.textFieldComponent.setToolTipText(this.tooltip);
        }
        if (!this.labelHasMnenomics(this.labelText, this.mnemonic)) {
            this.labelText = this.appendMnenomicsToLabel(this.labelText, this.mnemonic);
        }
        this.labelComponent = new JLabel(this.labelText);
        if (this.mnemonic != '\u0000') {
            this.labelComponent.setLabelFor(this.textFieldComponent);
            this.labelComponent.setDisplayedMnemonic(this.mnemonic);
        }
        this.setLayout(new FlowLayout(0));
        this.add(this.labelComponent);
        this.add(this.textFieldComponent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        block5: {
            Object object = focusEvent.getSource();
            if (object == this.textFieldComponent) {
                String string = this.textFieldComponent.getText();
                int n = 0;
                if (string.length() != 0) {
                    try {
                        n = Integer.parseInt(string);
                        if (this.minValue > n || n > this.maxValue) {
                            Object[] objectArray = new Object[]{this.stripMnenomicsFromLabel(this.labelText), new Integer(this.minValue), new Integer(this.maxValue)};
                            JOptionPane.showMessageDialog(this, SISResourceGetter.getFormatted("integer_range_error", objectArray), SISResourceGetter.getString("integer_range_error_title"), 0);
                            return;
                        }
                        break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(this, SISResourceGetter.getString("integer_error"), SISResourceGetter.getString("integer_error_title"), 0);
                        return;
                    }
                }
                Object[] objectArray = new Object[]{this.stripMnenomicsFromLabel(this.labelText), new Integer(this.minValue), new Integer(this.maxValue)};
                JOptionPane.showMessageDialog(this, SISResourceGetter.getFormatted("integer_range_error", objectArray), SISResourceGetter.getString("integer_range_error_title"), 0);
                this.setValue("0");
                return;
            }
        }
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public int getMinValue() {
        return this.minValue;
    }
}

