/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ChoiceComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.sybase.ismp.ase.lang.SISResourceGetter;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedContainer
extends AbstractUIComponent
implements ConsoleUIComponent {
    protected JTabbedPane _physicalPane = null;
    protected TreeMap _tabs = new TreeMap(new Comparator(){

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = SISResourceGetter.getString("Normal");
            n = object.equals(string) && object.equals(object2) ? 0 : (object.equals(string) ? -1 : (object2.equals(string) ? 1 : ((String)object).compareTo(object2)));
            return n;
        }
    });
    protected boolean _isGUISupported = false;
    public static String CONSOLE_DONE_CHOICE = null;
    protected String _chosenTab = null;

    public TabbedContainer() {
        CONSOLE_DONE_CHOICE = SISResourceGetter.getString("tabbed_container_console_done_choice");
    }

    public void initSwingComponents() {
        this._isGUISupported = true;
        this._physicalPane = new JTabbedPane();
        this._physicalPane.setBorder(BorderFactory.createEmptyBorder());
        if (this._tabs.size() > 0) {
            Iterator iterator = this._tabs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Component component = (Component)this._tabs.get(string);
                this._physicalPane.addTab(string, component);
            }
        }
        this._physicalPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabbedContainer.this.undraw();
                TabbedContainer.this.draw();
                TabbedContainer.this._physicalPane.validate();
            }
        });
    }

    public void draw() {
        if (this._isGUISupported) {
            int n = this._physicalPane.getSelectedIndex();
            this._physicalPane.getComponentAt(n).setVisible(true);
        }
    }

    public void undraw() {
        if (this._isGUISupported) {
            int n = this._physicalPane.getSelectedIndex();
            this._physicalPane.getComponentAt(n).setVisible(false);
        }
    }

    public void addTab(String string, Icon icon, Component component) {
        this._tabs.put(string, component);
    }

    protected Vector getConsoleComponents(Component component) {
        Vector<Component> vector = new Vector<Component>();
        if (component instanceof ConsoleUIComponent) {
            vector.addElement(component);
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != null && componentArray[i] instanceof ConsoleUIComponent) {
                    vector.addElement(componentArray[i]);
                    continue;
                }
                if (!(componentArray[i] instanceof Container)) continue;
                this.getConsoleComponents((Container)componentArray[i]);
            }
        }
        return vector;
    }

    public void createComponentUI() {
        JPanel jPanel = new JPanel();
        if (this._physicalPane == null) {
            this.initSwingComponents();
        }
        jPanel.add(this._physicalPane);
        super.setLayout(new FlowLayout(1));
        super.add(jPanel);
    }

    public ChoiceComponent generateConsoleChoiceComponent() {
        Vector vector = new Vector(this._tabs.keySet());
        vector.addElement(CONSOLE_DONE_CHOICE);
        ChoiceComponent choiceComponent = new ChoiceComponent(vector.toArray(new String[0]));
        choiceComponent.setComponentType(3);
        choiceComponent.setMultipleSelection(false);
        choiceComponent.addChoiceComponentListener(new ChoiceComponentListener(){

            public void choiceComponentStateChanged(ChoiceComponentEvent choiceComponentEvent) {
                TabbedContainer.this._chosenTab = choiceComponentEvent.getItem();
            }
        });
        choiceComponent.setSelectedIndex(0);
        return choiceComponent;
    }

    public void consoleInteraction() {
        ChoiceComponent choiceComponent = this.generateConsoleChoiceComponent();
        while (!choiceComponent.getSelectedItem().equals(CONSOLE_DONE_CHOICE)) {
            choiceComponent.consoleInteraction();
            this.consoleInteraction(choiceComponent.getSelectedIndex());
        }
    }

    public void consoleInteraction(int n) {
        Enumeration enumeration = null;
        enumeration = this._isGUISupported ? this.getConsoleComponents(this._physicalPane.getComponentAt(n)).elements() : this.getConsoleComponents((Component)this._tabs.values().toArray()[n]).elements();
        while (enumeration.hasMoreElements()) {
            ((ConsoleUIComponent)enumeration.nextElement()).consoleInteraction();
        }
    }

    public JTabbedPane getSwingTabbedPane() {
        return this._physicalPane;
    }

    public void setVisible(boolean bl) {
        if (this._isGUISupported) {
            super.setVisible(bl);
            if (bl) {
                this.draw();
            } else {
                this.undraw();
            }
        }
    }

    public Component getShownComponent() {
        if (this._isGUISupported) {
            return this._physicalPane.getSelectedComponent();
        }
        return (Component)this._tabs.get(this._chosenTab);
    }

    public void setShownComponent(Component component) {
        try {
            this._physicalPane.setSelectedComponent(component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

